/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DisplayType {
    SPICE("spice"),
    VNC("vnc");

    private static final Logger log;
    private String image;

    private DisplayType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static DisplayType fromValue(String value) {
        try {
            return DisplayType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'DisplayType' enumerated type. Valid values are 'spice' and 'vnc'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(DisplayType.class);
    }
}

