/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.NetworkAttachmentBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkAttachmentReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkAttachmentWriter;
import org.ovirt.engine.sdk4.services.NetworkAttachmentService;
import org.ovirt.engine.sdk4.types.NetworkAttachment;

public class NetworkAttachmentServiceImpl
extends ServiceImpl
implements NetworkAttachmentService {
    public NetworkAttachmentServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public NetworkAttachmentService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public NetworkAttachmentService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public NetworkAttachmentService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "NetworkAttachmentService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements NetworkAttachmentService.UpdateResponse {
        private NetworkAttachment attachment;

        private UpdateResponseImpl() {
        }

        public void attachment(NetworkAttachment attachment) {
            this.attachment = attachment;
        }

        @Override
        public NetworkAttachment attachment() {
            return this.attachment;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<NetworkAttachmentService.UpdateRequest, NetworkAttachmentService.UpdateResponse>
    implements NetworkAttachmentService.UpdateRequest {
        private Boolean async;
        private NetworkAttachment attachment;

        private UpdateRequestImpl() {
        }

        @Override
        public NetworkAttachmentService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public NetworkAttachmentService.UpdateRequest attachment(NetworkAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        @Override
        public NetworkAttachmentService.UpdateRequest attachment(NetworkAttachmentBuilder attachment) {
            this.attachment = attachment.build();
            return this;
        }

        @Override
        public NetworkAttachmentService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NetworkAttachmentServiceImpl.this.getConnection().getUrl() + NetworkAttachmentServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlNetworkAttachmentWriter.writeOne(this.attachment, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NetworkAttachmentServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.attachment(XmlNetworkAttachmentReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NetworkAttachmentServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements NetworkAttachmentService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<NetworkAttachmentService.RemoveRequest, NetworkAttachmentService.RemoveResponse>
    implements NetworkAttachmentService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public NetworkAttachmentService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public NetworkAttachmentService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NetworkAttachmentServiceImpl.this.getConnection().getUrl() + NetworkAttachmentServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NetworkAttachmentServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            NetworkAttachmentServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements NetworkAttachmentService.GetResponse {
        private NetworkAttachment attachment;

        private GetResponseImpl() {
        }

        public void attachment(NetworkAttachment attachment) {
            this.attachment = attachment;
        }

        @Override
        public NetworkAttachment attachment() {
            return this.attachment;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<NetworkAttachmentService.GetRequest, NetworkAttachmentService.GetResponse>
    implements NetworkAttachmentService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public NetworkAttachmentService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public NetworkAttachmentService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(NetworkAttachmentServiceImpl.this.getConnection().getUrl() + NetworkAttachmentServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = NetworkAttachmentServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.attachment(XmlNetworkAttachmentReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            NetworkAttachmentServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

