/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QcowVersion {
    QCOW2_V2("qcow2_v2"),
    QCOW2_V3("qcow2_v3");

    private static final Logger log;
    private String image;

    private QcowVersion(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static QcowVersion fromValue(String value) {
        try {
            return QcowVersion.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'QcowVersion' enumerated type. Valid values are 'qcow2_v2' and 'qcow2_v3'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(QcowVersion.class);
    }
}

