/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.internal.containers.SshContainer;
import org.ovirt.engine.sdk4.types.Ssh;
import org.ovirt.engine.sdk4.types.SshAuthenticationMethod;
import org.ovirt.engine.sdk4.types.User;

public class SshBuilder {
    private SshAuthenticationMethod authenticationMethod;
    private String comment;
    private String description;
    private String fingerprint;
    private String href;
    private String id;
    private String name;
    private BigInteger port;
    private User user;

    public SshBuilder authenticationMethod(SshAuthenticationMethod newAuthenticationMethod) {
        this.authenticationMethod = newAuthenticationMethod;
        return this;
    }

    public SshBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public SshBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public SshBuilder fingerprint(String newFingerprint) {
        this.fingerprint = newFingerprint;
        return this;
    }

    public SshBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public SshBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public SshBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public SshBuilder port(int newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public SshBuilder port(Integer newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort.longValue());
        return this;
    }

    public SshBuilder port(long newPort) {
        this.port = BigInteger.valueOf(newPort);
        return this;
    }

    public SshBuilder port(Long newPort) {
        this.port = newPort == null ? null : BigInteger.valueOf(newPort);
        return this;
    }

    public SshBuilder port(BigInteger newPort) {
        this.port = newPort;
        return this;
    }

    public SshBuilder user(User newUser) {
        this.user = newUser;
        return this;
    }

    public SshBuilder user(UserBuilder newUser) {
        this.user = newUser == null ? null : newUser.build();
        return this;
    }

    public Ssh build() {
        SshContainer container = new SshContainer();
        container.authenticationMethod(this.authenticationMethod);
        container.comment(this.comment);
        container.description(this.description);
        container.fingerprint(this.fingerprint);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.port(this.port);
        container.user(this.user);
        return container;
    }
}

