/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.MacPoolBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.MacPoolServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlMacPoolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlMacPoolWriter;
import org.ovirt.engine.sdk4.services.MacPoolService;
import org.ovirt.engine.sdk4.services.MacPoolsService;
import org.ovirt.engine.sdk4.types.MacPool;

public class MacPoolsServiceImpl
extends ServiceImpl
implements MacPoolsService {
    public MacPoolsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public MacPoolsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public MacPoolsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public MacPoolService macPoolService(String id) {
        return new MacPoolServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.macPoolService(path);
        }
        return this.macPoolService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "MacPoolsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements MacPoolsService.ListResponse {
        private List<MacPool> pools;

        private ListResponseImpl() {
        }

        public void pools(List<MacPool> pools) {
            this.pools = pools;
        }

        @Override
        public List<MacPool> pools() {
            return this.pools;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<MacPoolsService.ListRequest, MacPoolsService.ListResponse>
    implements MacPoolsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public MacPoolsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public MacPoolsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public MacPoolsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public MacPoolsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public MacPoolsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(MacPoolsServiceImpl.this.getConnection().getUrl() + MacPoolsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = MacPoolsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.pools(XmlMacPoolReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            MacPoolsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements MacPoolsService.AddResponse {
        private MacPool pool;

        private AddResponseImpl() {
        }

        public void pool(MacPool pool) {
            this.pool = pool;
        }

        @Override
        public MacPool pool() {
            return this.pool;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<MacPoolsService.AddRequest, MacPoolsService.AddResponse>
    implements MacPoolsService.AddRequest {
        private MacPool pool;

        private AddRequestImpl() {
        }

        @Override
        public MacPoolsService.AddRequest pool(MacPool pool) {
            this.pool = pool;
            return this;
        }

        @Override
        public MacPoolsService.AddRequest pool(MacPoolBuilder pool) {
            this.pool = pool.build();
            return this;
        }

        @Override
        public MacPoolsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(MacPoolsServiceImpl.this.getConnection().getUrl() + MacPoolsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlMacPoolWriter.writeOne(this.pool, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = MacPoolsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.pool(XmlMacPoolReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            MacPoolsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

