/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.AgentBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlAgentReader;
import org.ovirt.engine.sdk4.internal.xml.XmlAgentWriter;
import org.ovirt.engine.sdk4.services.FenceAgentService;
import org.ovirt.engine.sdk4.types.Agent;

public class FenceAgentServiceImpl
extends ServiceImpl
implements FenceAgentService {
    public FenceAgentServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public FenceAgentService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public FenceAgentService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public FenceAgentService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "FenceAgentService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements FenceAgentService.UpdateResponse {
        private Agent agent;

        private UpdateResponseImpl() {
        }

        public void agent(Agent agent) {
            this.agent = agent;
        }

        @Override
        public Agent agent() {
            return this.agent;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<FenceAgentService.UpdateRequest, FenceAgentService.UpdateResponse>
    implements FenceAgentService.UpdateRequest {
        private Agent agent;
        private Boolean async;

        private UpdateRequestImpl() {
        }

        @Override
        public FenceAgentService.UpdateRequest agent(Agent agent) {
            this.agent = agent;
            return this;
        }

        @Override
        public FenceAgentService.UpdateRequest agent(AgentBuilder agent) {
            this.agent = agent.build();
            return this;
        }

        @Override
        public FenceAgentService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public FenceAgentService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(FenceAgentServiceImpl.this.getConnection().getUrl() + FenceAgentServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlAgentWriter.writeOne(this.agent, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = FenceAgentServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.agent(XmlAgentReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            FenceAgentServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements FenceAgentService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<FenceAgentService.RemoveRequest, FenceAgentService.RemoveResponse>
    implements FenceAgentService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public FenceAgentService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public FenceAgentService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(FenceAgentServiceImpl.this.getConnection().getUrl() + FenceAgentServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = FenceAgentServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            FenceAgentServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements FenceAgentService.GetResponse {
        private Agent agent;

        private GetResponseImpl() {
        }

        public void agent(Agent agent) {
            this.agent = agent;
        }

        @Override
        public Agent agent() {
            return this.agent;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<FenceAgentService.GetRequest, FenceAgentService.GetResponse>
    implements FenceAgentService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public FenceAgentService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public FenceAgentService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(FenceAgentServiceImpl.this.getConnection().getUrl() + FenceAgentServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = FenceAgentServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.agent(XmlAgentReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            FenceAgentServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

