#
# Copyright 2012 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license
#

from __future__ import absolute_import
from __future__ import division

PROFILE_INFO = {'bricks': [
    {'brick': '10.16.159.6:/m1',
     'cumulativeStats': {
         'blockStats': [{'read': '0',
                         'size': '1',
                         'write': '0'},
                        {'read': '0',
                         'size': '2',
                         'write': '0'},
                        {'read': '0',
                         'size': '4',
                         'write': '0'},
                        {'read': '0',
                         'size': '8',
                         'write': '0'},
                        {'read': '0',
                         'size': '16',
                         'write': '0'},
                        {'read': '0',
                         'size': '32',
                         'write': '0'},
                        {'read': '0',
                         'size': '64',
                         'write': '0'},
                        {'read': '0',
                         'size': '128',
                         'write': '0'},
                        {'read': '0',
                         'size': '256',
                         'write': '0'},
                        {'read': '0',
                         'size': '512',
                         'write': '0'},
                        {'read': '0',
                         'size': '1024',
                         'write': '0'},
                        {'read': '0',
                         'size': '2048',
                         'write': '0'},
                        {'read': '0',
                         'size': '4096',
                         'write': '0'},
                        {'read': '0',
                         'size': '8192',
                         'write': '0'},
                        {'read': '0',
                         'size': '16384',
                         'write': '0'},
                        {'read': '0',
                         'size': '32768',
                         'write': '0'},
                        {'read': '0',
                         'size': '65536',
                         'write': '0'},
                        {'read': '0',
                         'size': '131072',
                         'write': '0'},
                        {'read': '0',
                         'size': '262144',
                         'write': '0'},
                        {'read': '0',
                         'size': '524288',
                         'write': '0'},
                        {'read': '0',
                         'size': '1048576',
                         'write': '0'},
                        {'read': '0',
                         'size': '2097152',
                         'write': '0'},
                        {'read': '0',
                         'size': '4194304',
                         'write': '0'},
                        {'read': '0',
                         'size': '8388608',
                         'write': '0'},
                        {'read': '0',
                         'size': '16777216',
                         'write': '0'},
                        {'read': '0',
                         'size': '33554432',
                         'write': '0'},
                        {'read': '0',
                         'size': '67108864',
                         'write': '0'},
                        {'read': '0',
                         'size': '134217728',
                         'write': '0'},
                        {'read': '0',
                         'size': '268435456',
                         'write': '0'},
                        {'read': '0',
                         'size': '536870912',
                         'write': '0'},
                        {'read': '0',
                         'size': '1073741824',
                         'write': '0'},
                        {'read': '0',
                         'size': '2147483648',
                         'write': '0'}],
         'duration': '1294181',
         'fopStats': [{'hits': '9',
                       'latencyAvg': '61.333333',
                       'latencyMax': '310.000000',
                       'latencyMin': '22.000000',
                       'name': 'STAT'},
                      {'hits': '8',
                       'latencyAvg': '97.125000',
                       'latencyMax': '369.000000',
                       'latencyMin': '31.000000',
                       'name': 'STATFS'},
                      {'hits': '1',
                       'latencyAvg': '95.000000',
                       'latencyMax': '95.000000',
                       'latencyMin': '95.000000',
                       'name': 'SETXATTR'},
                      {'hits': '1',
                       'latencyAvg': '15606.000000',
                       'latencyMax': '15606.000000',
                       'latencyMin': '15606.000000',
                       'name': 'ACCESS'},
                      {'hits': '1',
                       'latencyAvg': '1387.000000',
                       'latencyMax': '1387.000000',
                       'latencyMin': '1387.000000',
                       'name': 'CREATE'},
                      {'hits': '2',
                       'latencyAvg': '324.500000',
                       'latencyMax': '594.000000',
                       'latencyMin': '55.000000',
                       'name': 'FSTAT'},
                      {'hits': '14',
                       'latencyAvg': '6240.642857',
                       'latencyMax': '85591.000000',
                       'latencyMin': '39.000000',
                       'name': 'LOOKUP'},
                      {'hits': '2',
                       'latencyAvg': '69.000000',
                       'latencyMax': '96.000000',
                       'latencyMin': '42.000000',
                       'name': 'SETATTR'},
                      {'hits': '2',
                       'latencyAvg': '272.000000',
                       'latencyMax': '456.000000',
                       'latencyMin': '88.000000',
                       'name': 'READDIRP'}],
         'totalRead': '0',
         'totalWrite': '0'},
     'intervalStats': {
         'blockStats': [{'read': '0',
                         'size': '1',
                         'write': '0'},
                        {'read': '0',
                         'size': '2',
                         'write': '0'},
                        {'read': '0',
                         'size': '4',
                         'write': '0'},
                        {'read': '0',
                         'size': '8',
                         'write': '0'},
                        {'read': '0',
                         'size': '16',
                         'write': '0'},
                        {'read': '0',
                         'size': '32',
                         'write': '0'},
                        {'read': '0',
                         'size': '64',
                         'write': '0'},
                        {'read': '0',
                         'size': '128',
                         'write': '0'},
                        {'read': '0',
                         'size': '256',
                         'write': '0'},
                        {'read': '0',
                         'size': '512',
                         'write': '0'},
                        {'read': '0',
                         'size': '1024',
                         'write': '0'},
                        {'read': '0',
                         'size': '2048',
                         'write': '0'},
                        {'read': '0',
                         'size': '4096',
                         'write': '0'},
                        {'read': '0',
                         'size': '8192',
                         'write': '0'},
                        {'read': '0',
                         'size': '16384',
                         'write': '0'},
                        {'read': '0',
                         'size': '32768',
                         'write': '0'},
                        {'read': '0',
                         'size': '65536',
                         'write': '0'},
                        {'read': '0',
                         'size': '131072',
                         'write': '0'},
                        {'read': '0',
                         'size': '262144',
                         'write': '0'},
                        {'read': '0',
                         'size': '524288',
                         'write': '0'},
                        {'read': '0',
                         'size': '1048576',
                         'write': '0'},
                        {'read': '0',
                         'size': '2097152',
                         'write': '0'},
                        {'read': '0',
                         'size': '4194304',
                         'write': '0'},
                        {'read': '0',
                         'size': '8388608',
                         'write': '0'},
                        {'read': '0',
                         'size': '16777216',
                         'write': '0'},
                        {'read': '0',
                         'size': '33554432',
                         'write': '0'},
                        {'read': '0',
                         'size': '67108864',
                         'write': '0'},
                        {'read': '0',
                         'size': '134217728',
                         'write': '0'},
                        {'read': '0',
                         'size': '268435456',
                         'write': '0'},
                        {'read': '0',
                         'size': '536870912',
                         'write': '0'},
                        {'read': '0',
                         'size': '1073741824',
                         'write': '0'},
                        {'read': '0',
                         'size': '2147483648',
                         'write': '0'}],
         'duration': '27',
         'fopStats': [],
         'totalRead': '0',
         'totalWrite': '0'}},
    {'brick': '10.16.159.6:/m2',
     'cumulativeStats': {
         'blockStats': [{'read': '0',
                         'size': '1',
                         'write': '0'},
                        {'read': '0',
                         'size': '2',
                         'write': '0'},
                        {'read': '0',
                         'size': '4',
                         'write': '0'},
                        {'read': '0',
                         'size': '8',
                         'write': '0'},
                        {'read': '0',
                         'size': '16',
                         'write': '0'},
                        {'read': '0',
                         'size': '32',
                         'write': '0'},
                        {'read': '0',
                         'size': '64',
                         'write': '0'},
                        {'read': '0',
                         'size': '128',
                         'write': '0'},
                        {'read': '0',
                         'size': '256',
                         'write': '0'},
                        {'read': '0',
                         'size': '512',
                         'write': '0'},
                        {'read': '0',
                         'size': '1024',
                         'write': '0'},
                        {'read': '0',
                         'size': '2048',
                         'write': '0'},
                        {'read': '0',
                         'size': '4096',
                         'write': '0'},
                        {'read': '0',
                         'size': '8192',
                         'write': '0'},
                        {'read': '0',
                         'size': '16384',
                         'write': '0'},
                        {'read': '0',
                         'size': '32768',
                         'write': '0'},
                        {'read': '0',
                         'size': '65536',
                         'write': '0'},
                        {'read': '0',
                         'size': '131072',
                         'write': '0'},
                        {'read': '0',
                         'size': '262144',
                         'write': '0'},
                        {'read': '0',
                         'size': '524288',
                         'write': '0'},
                        {'read': '0',
                         'size': '1048576',
                         'write': '0'},
                        {'read': '0',
                         'size': '2097152',
                         'write': '0'},
                        {'read': '0',
                         'size': '4194304',
                         'write': '0'},
                        {'read': '0',
                         'size': '8388608',
                         'write': '0'},
                        {'read': '0',
                         'size': '16777216',
                         'write': '0'},
                        {'read': '0',
                         'size': '33554432',
                         'write': '0'},
                        {'read': '0',
                         'size': '67108864',
                         'write': '0'},
                        {'read': '0',
                         'size': '134217728',
                         'write': '0'},
                        {'read': '0',
                         'size': '268435456',
                         'write': '0'},
                        {'read': '0',
                         'size': '536870912',
                         'write': '0'},
                        {'read': '0',
                         'size': '1073741824',
                         'write': '0'},
                        {'read': '0',
                         'size': '2147483648',
                         'write': '0'}],
         'duration': '1294181',
         'fopStats': [{'hits': '9',
                       'latencyAvg': '47.555556',
                       'latencyMax': '199.000000',
                       'latencyMin': '23.000000',
                       'name': 'STAT'},
                      {'hits': '8',
                       'latencyAvg': '74.750000',
                       'latencyMax': '248.000000',
                       'latencyMin': '24.000000',
                       'name': 'STATFS'},
                      {'hits': '1',
                       'latencyAvg': '52.000000',
                       'latencyMax': '52.000000',
                       'latencyMin': '52.000000',
                       'name': 'SETXATTR'},
                      {'hits': '1',
                       'latencyAvg': '454.000000',
                       'latencyMax': '454.000000',
                       'latencyMin': '454.000000',
                       'name': 'CREATE'},
                      {'hits': '2',
                       'latencyAvg': '82.000000',
                       'latencyMax': '113.000000',
                       'latencyMin': '51.000000',
                       'name': 'FSTAT'},
                      {'hits': '11',
                       'latencyAvg': '824.181818',
                       'latencyMax': '8381.000000',
                       'latencyMin': '38.000000',
                       'name': 'LOOKUP'},
                      {'hits': '2',
                       'latencyAvg': '59.000000',
                       'latencyMax': '66.000000',
                       'latencyMin': '52.000000',
                       'name': 'SETATTR'},
                      {'hits': '2',
                       'latencyAvg': '161.000000',
                       'latencyMax': '222.000000',
                       'latencyMin': '100.000000',
                       'name': 'READDIRP'}],
         'totalRead': '0',
         'totalWrite': '0'},
     'intervalStats': {
         'blockStats': [{'read': '0',
                         'size': '1',
                         'write': '0'},
                        {'read': '0',
                         'size': '2',
                         'write': '0'},
                        {'read': '0',
                         'size': '4',
                         'write': '0'},
                        {'read': '0',
                         'size': '8',
                         'write': '0'},
                        {'read': '0',
                         'size': '16',
                         'write': '0'},
                        {'read': '0',
                         'size': '32',
                         'write': '0'},
                        {'read': '0',
                         'size': '64',
                         'write': '0'},
                        {'read': '0',
                         'size': '128',
                         'write': '0'},
                        {'read': '0',
                         'size': '256',
                         'write': '0'},
                        {'read': '0',
                         'size': '512',
                         'write': '0'},
                        {'read': '0',
                         'size': '1024',
                         'write': '0'},
                        {'read': '0',
                         'size': '2048',
                         'write': '0'},
                        {'read': '0',
                         'size': '4096',
                         'write': '0'},
                        {'read': '0',
                         'size': '8192',
                         'write': '0'},
                        {'read': '0',
                         'size': '16384',
                         'write': '0'},
                        {'read': '0',
                         'size': '32768',
                         'write': '0'},
                        {'read': '0',
                         'size': '65536',
                         'write': '0'},
                        {'read': '0',
                         'size': '131072',
                         'write': '0'},
                        {'read': '0',
                         'size': '262144',
                         'write': '0'},
                        {'read': '0',
                         'size': '524288',
                         'write': '0'},
                        {'read': '0',
                         'size': '1048576',
                         'write': '0'},
                        {'read': '0',
                         'size': '2097152',
                         'write': '0'},
                        {'read': '0',
                         'size': '4194304',
                         'write': '0'},
                        {'read': '0',
                         'size': '8388608',
                         'write': '0'},
                        {'read': '0',
                         'size': '16777216',
                         'write': '0'},
                        {'read': '0',
                         'size': '33554432',
                         'write': '0'},
                        {'read': '0',
                         'size': '67108864',
                         'write': '0'},
                        {'read': '0',
                         'size': '134217728',
                         'write': '0'},
                        {'read': '0',
                         'size': '268435456',
                         'write': '0'},
                        {'read': '0',
                         'size': '536870912',
                         'write': '0'},
                        {'read': '0',
                         'size': '1073741824',
                         'write': '0'},
                        {'read': '0',
                         'size': '2147483648',
                         'write': '0'}],
         'duration': '27',
         'fopStats': [],
         'totalRead': '0',
         'totalWrite': '0'}}],
    'volumeName': 'music2'}

PROFILE_INFO_NFS = {'nfsServers': [
    {'nfs': '10.16.159.6',
     'cumulativeStats': {
         'blockStats': [{'read': '0',
                         'size': '1',
                         'write': '0'},
                        {'read': '0',
                         'size': '2',
                         'write': '0'},
                        {'read': '0',
                         'size': '4',
                         'write': '0'},
                        {'read': '0',
                         'size': '8',
                         'write': '1'},
                        {'read': '0',
                         'size': '16',
                         'write': '0'},
                        {'read': '0',
                         'size': '32',
                         'write': '0'},
                        {'read': '0',
                         'size': '64',
                         'write': '0'},
                        {'read': '0',
                         'size': '128',
                         'write': '0'},
                        {'read': '0',
                         'size': '256',
                         'write': '0'},
                        {'read': '0',
                         'size': '512',
                         'write': '0'},
                        {'read': '0',
                         'size': '1024',
                         'write': '0'},
                        {'read': '0',
                         'size': '2048',
                         'write': '0'},
                        {'read': '0',
                         'size': '4096',
                         'write': '0'},
                        {'read': '0',
                         'size': '8192',
                         'write': '0'},
                        {'read': '0',
                         'size': '16384',
                         'write': '0'},
                        {'read': '0',
                         'size': '32768',
                         'write': '0'},
                        {'read': '0',
                         'size': '65536',
                         'write': '0'},
                        {'read': '0',
                         'size': '131072',
                         'write': '0'},
                        {'read': '0',
                         'size': '262144',
                         'write': '0'},
                        {'read': '0',
                         'size': '524288',
                         'write': '0'},
                        {'read': '0',
                         'size': '1048576',
                         'write': '0'},
                        {'read': '0',
                         'size': '2097152',
                         'write': '0'},
                        {'read': '0',
                         'size': '4194304',
                         'write': '0'},
                        {'read': '0',
                         'size': '8388608',
                         'write': '0'},
                        {'read': '0',
                         'size': '16777216',
                         'write': '0'},
                        {'read': '0',
                         'size': '33554432',
                         'write': '0'},
                        {'read': '0',
                         'size': '67108864',
                         'write': '0'},
                        {'read': '0',
                         'size': '134217728',
                         'write': '0'},
                        {'read': '0',
                         'size': '268435456',
                         'write': '0'},
                        {'read': '0',
                         'size': '536870912',
                         'write': '0'},
                        {'read': '0',
                         'size': '1073741824',
                         'write': '0'},
                        {'read': '0',
                         'size': '2147483648',
                         'write': '0'}],
         'duration': '1108675',
         'fopStats': [{'hits': '28',
                       'latencyAvg': '1200.678571',
                       'latencyMax': '21977.000000',
                       'latencyMin': '264.000000',
                       'name': 'STAT'},
                      {'hits': '1',
                       'latencyAvg': '426.000000',
                       'latencyMax': '426.000000',
                       'latencyMin': '426.000000',
                       'name': 'WRITE'},
                      {'hits': '3',
                       'latencyAvg': '626.666667',
                       'latencyMax': '717.000000',
                       'latencyMin': '539.000000',
                       'name': 'STATFS'},
                      {'hits': '1',
                       'latencyAvg': '1030.000000',
                       'latencyMax': '1030.000000',
                       'latencyMin': '1030.000000',
                       'name': 'FSYNC'},
                      {'hits': '7',
                       'latencyAvg': '3937.857143',
                       'latencyMax': '26095.000000',
                       'latencyMin': '230.000000',
                       'name': 'ACCESS'},
                      {'hits': '6',
                       'latencyAvg': '1312.833333',
                       'latencyMax': '1996.000000',
                       'latencyMin': '814.000000',
                       'name': 'CREATE'},
                      {'hits': '8',
                       'latencyAvg': '498.125000',
                       'latencyMax': '818.000000',
                       'latencyMin': '389.000000',
                       'name': 'FSTAT'},
                      {'hits': '33',
                       'latencyAvg': '749.818182',
                       'latencyMax': '2354.000000',
                       'latencyMin': '340.000000',
                       'name': 'LOOKUP'},
                      {'hits': '3',
                       'latencyAvg': '231.666667',
                       'latencyMax': '282.000000',
                       'latencyMin': '202.000000',
                       'name': 'SETATTR'},
                      {'hits': '8',
                       'latencyAvg': '1717.875000',
                       'latencyMax': '5339.000000',
                       'latencyMin': '684.000000',
                       'name': 'READDIRP'}],
         'totalRead': '0',
         'totalWrite': '12'},
     'intervalStats': {
         'blockStats': [{'read': '0',
                         'size': '1',
                         'write': '0'},
                        {'read': '0',
                         'size': '2',
                         'write': '0'},
                        {'read': '0',
                         'size': '4',
                         'write': '0'},
                        {'read': '0',
                         'size': '8',
                         'write': '0'},
                        {'read': '0',
                         'size': '16',
                         'write': '0'},
                        {'read': '0',
                         'size': '32',
                         'write': '0'},
                        {'read': '0',
                         'size': '64',
                         'write': '0'},
                        {'read': '0',
                         'size': '128',
                         'write': '0'},
                        {'read': '0',
                         'size': '256',
                         'write': '0'},
                        {'read': '0',
                         'size': '512',
                         'write': '0'},
                        {'read': '0',
                         'size': '1024',
                         'write': '0'},
                        {'read': '0',
                         'size': '2048',
                         'write': '0'},
                        {'read': '0',
                         'size': '4096',
                         'write': '0'},
                        {'read': '0',
                         'size': '8192',
                         'write': '0'},
                        {'read': '0',
                         'size': '16384',
                         'write': '0'},
                        {'read': '0',
                         'size': '32768',
                         'write': '0'},
                        {'read': '0',
                         'size': '65536',
                         'write': '0'},
                        {'read': '0',
                         'size': '131072',
                         'write': '0'},
                        {'read': '0',
                         'size': '262144',
                         'write': '0'},
                        {'read': '0',
                         'size': '524288',
                         'write': '0'},
                        {'read': '0',
                         'size': '1048576',
                         'write': '0'},
                        {'read': '0',
                         'size': '2097152',
                         'write': '0'},
                        {'read': '0',
                         'size': '4194304',
                         'write': '0'},
                        {'read': '0',
                         'size': '8388608',
                         'write': '0'},
                        {'read': '0',
                         'size': '16777216',
                         'write': '0'},
                        {'read': '0',
                         'size': '33554432',
                         'write': '0'},
                        {'read': '0',
                         'size': '67108864',
                         'write': '0'},
                        {'read': '0',
                         'size': '134217728',
                         'write': '0'},
                        {'read': '0',
                         'size': '268435456',
                         'write': '0'},
                        {'read': '0',
                         'size': '536870912',
                         'write': '0'},
                        {'read': '0',
                         'size': '1073741824',
                         'write': '0'},
                        {'read': '0',
                         'size': '2147483648',
                         'write': '0'}],
         'duration': '24',
         'fopStats': [],
         'totalRead': '0',
         'totalWrite': '0'}}],
    'volumeName': 'music2'}


REBALANCE_REMOVE_BRICK_STATUS = {
    'summary': {
        'runtime': '10.2',
        'filesScanned': '278',
        'filesMoved': '78',
        'filesFailed': '0',
        'filesSkipped': '0',
        'totalSizeMoved': '79872',
        'status': 'COMPLETED'
    },
    'hosts': [{
        'name': 'localhost',
        'id': '883626f8-4d29-4d02-8c5d-c9f48c5b2445',
        'runtime': '10.2',
        'filesScanned': '278',
        'filesMoved': '78',
        'filesFailed': '0',
        'filesSkipped': '0',
        'totalSizeMoved': '79872',
        'status': 'COMPLETED'
    }]}


GLUSTER_VOLUME_TASKS = {
    '5e7fb5b7-1e23-415c-9b3f-e7e7fd896ea1': {
        'volumeName': 'gv1',
        'taskType': 'REMOVE_BRICK',
        'status': 'COMPLETED',
        'bricks': ['bricknode1:/gfs/b3']
    },
    '1bea87af-d176-4044-b4a2-46724ab0f070': {
        'volumeName': 'gv1',
        'taskType': 'REBALANCE',
        'status': 'IN_PROGRESS',
        'bricks': []
    },
    '5e7fb5b7-1e23-415c-9b3f-e7e7fd896eae': {
        'volumeName': 'gv2',
        'taskType': 'REMOVE_BRICK',
        'status': 'COMPLETED',
        'bricks': ['bricknode1:/gfs/b3']
    }
}

GLUSTER_STORAGE_DEVICES = [{'createBrick': True,
                            'devPath': '/dev/vdd',
                            'devUuid': '',
                            'bus': '',
                            'fsType': '',
                            'model': 'disk',
                            'mountPoint': '',
                            'name': 'lvm1',
                            'size': '3072.0',
                            'uuid': ''},
                           {'createBrick': False,
                            'devPath': '/dev/vdc',
                            'devUuid': '',
                            'bus': '',
                            'fsType': 'multipath_member',
                            'model': 'Virtio Block Device (disk)',
                            'mountPoint': '',
                            'name': 'vdc',
                            'size': '1024.0',
                            'uuid': ''},
                           {'createBrick': False,
                            'devPath': '/dev/vdc',
                            'devUuid': '',
                            'bus': '',
                            'fsType': '',
                            'model': 'Virtio Block Device (disk)',
                            'mountPoint': '',
                            'name': 'vdc',
                            'size': '1024.0',
                            'uuid': ''},
                           {'createBrick': False,
                            'devPath': '/dev/vda5',
                            'devUuid': 'ee18ca64-806a-4a84-b69e-1f939265fa68',
                            'bus': '',
                            'fsType': 'xfs',
                            'model': 'Virtio Block Device (partition)',
                            'mountPoint': '/',
                            'name': 'vda5',
                            'size': '1024.0',
                            'uuid': '12345-12345-12345'},
                           {'createBrick': False,
                            'devPath': '/dev/vda4',
                            'devUuid': '',
                            'bus': '',
                            'fsType': 'xfs',
                            'model': 'Virtio Block Device (partition)',
                            'mountPoint': '',
                            'name': 'vda4',
                            'size': '1024.0',
                            'uuid': '12344-12344-12344'},
                           {'createBrick': True,
                            'devPath': '/dev/vda3',
                            'devUuid': '',
                            'bus': '',
                            'fsType': '',
                            'model': 'Virtio Block Device (partition)',
                            'mountPoint': '',
                            'name': 'vda3',
                            'size': '1024.0',
                            'uuid': ''},
                           {'createBrick': False,
                            'devPath': '/dev/vda',
                            'devUuid': '',
                            'bus': '',
                            'fsType': '',
                            'model': 'Virtio Block Device (disk)',
                            'mountPoint': '',
                            'name': 'vda',
                            'size': '1024.0',
                            'uuid': ''},
                           {'createBrick': False,
                            'devPath': '/dev/sr0',
                            'devUuid': '',
                            'bus': '',
                            'fsType': '',
                            'model': 'QEMU_DVD-ROM (cdrom)',
                            'mountPoint': '',
                            'name': 'sr0',
                            'size': '0',
                            'uuid': ''},
                           {'createBrick': False,
                            'devPath': '/dev/mapper/testvg1',
                            'devUuid': '',
                            'bus': '',
                            'fsType': '',
                            'model': 'lvmvg',
                            'mountPoint': '',
                            'name': 'testvg1',
                            'size': '3060',
                            'uuid': ''}]


def glusterStorageDevData():
    class TestStorageDev(object):
        {}

    devices = []
    # empty uuid, model, format.type
    device = TestStorageDev()
    device.name = 'lvm1'
    device.size = 3072.0
    device.path = '/dev/vdd'
    device.uuid = None
    device.parents = []
    device.bus = ''
    device.kids = 0
    device.model = None
    device.type = "disk"
    device.sysfsPath = ''
    device.format = TestStorageDev()
    device.format.type = None
    device.format.uuid = None
    devices.append(device)

    # Check model
    device = TestStorageDev()
    device.name = 'vdc'
    device.size = 1024.0
    device.path = '/dev/vdc'
    device.uuid = None
    device.parents = []
    device.bus = ''
    device.kids = 1
    device.model = "Virtio Block Device"
    device.type = "disk"
    device.sysfsPath = ''
    device.format = TestStorageDev()
    device.format.type = 'multipath_member'
    device.format.status = True
    device.format.mountpoint = None
    device.format.uuid = None
    devices.append(device)

    # check fstype
    device = TestStorageDev()
    device.name = 'vdc'
    device.size = 1024.0
    device.path = '/dev/vdc'
    device.uuid = None
    device.parents = []
    device.bus = ''
    device.kids = 1
    device.model = "Virtio Block Device"
    device.type = "disk"
    device.sysfsPath = ''
    device.format = TestStorageDev()
    device.format.type = None
    device.format.uuid = None
    devices.append(device)

    device = TestStorageDev()
    device.name = 'vda5'
    device.size = 1024.0
    device.path = '/dev/vda5'
    device.uuid = 'ee18ca64-806a-4a84-b69e-1f939265fa68'
    device.parents = []
    device.bus = ''
    device.kids = 0
    device.model = "Virtio Block Device"
    device.type = "partition"
    device.sysfsPath = ''
    device.format = TestStorageDev()
    device.format.type = 'xfs'
    device.format.uuid = "12345-12345-12345"
    device.format.mountpoint = '/'
    devices.append(device)

    # check fstype, no mountpoint attribute
    device = TestStorageDev()
    device.name = 'vda4'
    device.size = 1024.0
    device.path = '/dev/vda4'
    device.uuid = None
    device.parents = []
    device.bus = ''
    device.kids = 0
    device.model = "Virtio Block Device"
    device.type = "partition"
    device.sysfsPath = ''
    device.format = TestStorageDev()
    device.format.type = 'xfs'
    device.format.uuid = "12344-12344-12344"
    devices.append(device)

    # check empty mountpoint
    device = TestStorageDev()
    device.name = 'vda3'
    device.size = 1024.0
    device.path = '/dev/vda3'
    device.uuid = None
    device.parents = []
    device.bus = ''
    device.kids = 0
    device.model = "Virtio Block Device"
    device.type = "partition"
    device.sysfsPath = ''
    device.format = TestStorageDev()
    device.format.type = None
    device.format.uuid = None
    devices.append(device)

    # check kids > 0
    device = TestStorageDev()
    device.name = 'vda'
    device.size = 1024.0
    device.path = '/dev/vda'
    device.uuid = None
    device.parents = []
    device.bus = ''
    device.kids = 3
    device.model = "Virtio Block Device"
    device.type = "disk"
    device.sysfsPath = ''
    device.format = TestStorageDev()
    device.format.type = None
    device.format.uuid = None
    devices.append(device)

    # device type cd-rom
    device = TestStorageDev()
    device.name = 'sr0'
    device.size = 0
    device.path = '/dev/sr0'
    device.uuid = None
    device.parents = []
    device.bus = ''
    device.kids = 0
    device.model = "QEMU_DVD-ROM"
    device.type = "cdrom"
    device.sysfsPath = ''
    device.format = TestStorageDev()
    device.format.uuid = None
    device.format.type = None
    devices.append(device)

    # device type is lvmvg
    device = TestStorageDev()
    device.name = 'testvg1'
    device.size = 3060
    device.path = '/dev/mapper/testvg1'
    device.uuid = None
    device.parents = []
    device.bus = ''
    device.kids = 0
    device.model = ''
    device.type = 'lvmvg'
    device.sysfsPath = ''
    device.format = TestStorageDev()
    device.format.type = None
    device.format.uuid = None
    devices.append(device)
    return devices

GLUSTER_GEOREP_STATUS = {
    'vol1': {
        'sessions': [
            {'bricks': [
                {'status': 'Stopped',
                 'brickName': '/root/b1_vol1',
                 'crawlStatus': 'N/A',
                 'hostUuid': '6a2f7584-05a8-4651-8786-1cd6ae87b896',
                 'remoteHost': '192.168.122.145',
                 'checkpointCompletionTime': 1418361500,
                 'meta': '0',
                 'checkpointCompleted': 'Yes',
                 'host': 'localhost.localdomain',
                 'checkpointTime': 1418361443,
                 'lastSynced': 1418361503,
                 'failures': '0',
                 'entry': '0',
                 'remoteUserName': 'root',
                 'timeZone': 'IST',
                 'data': '0'}],
             'remoteVolumeName': 'vol2',
             'sessionKey': '6a2f7584-05a8-4651-8786-1cd6ae87b896:ssh:'
             '//192.168.122.145::vol2'}
        ]
    }
}

GLUSTER_GEOREP_CONFIG_LIST = {
    'geoRepConfig': {
        'special_sync_mode': 'partial',
        'state_socket_unencoded': '/var/lib/glusterd/geo-replication'
        '/master2_10.70.43.63_slave3/ssh%3A%2F%2Froot%4010'
        '.70.43.63%3Agluster%3A%2F%2F127.0.0.1%3Aslave3.socket',
        'gluster_log_file': '/var/log/glusterfs/geo-replication/'
        'master2/ssh%3A%2F%2Froot%4010.70.43.63%3Agluster%3'
        'A%2F%2F127.0.0.1%3Aslave3.gluster.log',
        'ssh_command': 'ssh -oPasswordAuthentication=no '
        '-oStrictHostKeyChecking=no -i /var/lib/glusterd'
        '/geo-replication/secret.pem',
        'ignore_deletes': 'true',
        'change_detector': 'changelog',
        'ssh_command_tar': 'ssh -oPasswordAuthentication=no -oStrict'
        'HostKeyChecking=no -i /var/lib/glusterd/geo-replication'
        '/tar_ssh.pem',
        'state_file': '/var/lib/glusterd/geo-replication/master2'
        '_10.70.43.63_slave3/ssh%3A%2F%2Froot%4010.70.43.63%3Aglu'
        'ster%3A%2F%2F127.0.0.1%3Aslave3.status',
        'remote_gsyncd': '/nonexistent/gsyncd',
        'log_file': '/var/log/glusterfs/geo-replication/master2'
        '/ssh%3A%2F%2Froot%4010.70.43.63%3Agluster%3A%2F%2F127.0.0'
        '.1%3Aslave3.log',
        'changelog_log_file': '/var/log/glusterfs/geo-replication/master2/'
        'ssh%3A%2F%2Froot%4010.70.43.63%3Agluster%3A%2F%2F127.0.0.1'
        '%3Aslave3-changes.log',
        'socketdir': '/var/run',
        'working_dir': '/var/lib/misc/glusterfsd/master2/ssh%3A%2F%2'
        'Froot%4010.70.43.63%3Agluster%3A%2F%2F127.0.0.1%3Aslave3',
        'state_detail_file': '/var/lib/glusterd/geo-replication/master2_10.'
        '70.43.63_slave3/ssh%3A%2F%2Froot%4010.70.43.63%3Agluster%3A%2'
        'F%2F127.0.0.1%3Aslave3-detail.status',
        'session_owner': '67186261-91a7-4930-b681-9f127f485a0e',
        'gluster_command_dir': '/usr/sbin/',
        'pid_file': '/var/lib/glusterd/geo-replication/master2_10.70.'
        '43.63_slave3/ssh%3A%2F%2Froot%4010.70.43.63%3Agluster%3A%2F%2F1'
        '27.0.0.1%3Aslave3.pid',
        'georep_session_working_dir': '/var/lib/glusterd/geo-replication/'
        'master2_10.70.43.63_slave3/',
        'gluster_params': 'aux-gfid-mount',
        'volume_id': '67186261-91a7-4930-b681-9f127f485a0e'
    }
}

GLUSTER_SNAPSHOT_RESTORE = {
    'snapshotName': 'snap1',
    'snapshotUuid': 'ef4b5442-2d6e-498b-9e42-fd0e566ac74c',
    'volumeName': 'snap-vol2',
    'volumeUuid': '8558c40f-1581-414e-89d6-46854376ae3d'
}

GLUSTER_SNAPSHOT_CONFIG_LIST = {
    'volume': {
        'snap-vol': {
            'snap-max-hard-limit': '255'
        },
        'snap-vol2': {
            'snap-max-hard-limit': '254'
        }
    },
    'system': {
        'snap-max-hard-limit': '255',
        'auto-delete': 'disable',
        'snap-max-soft-limit': '91%',
        'activate-on-create': 'disable'
    }
}

GLUSTER_VOLUME_SNAPSHOT_LIST = {
    'snap-vol': {
        'snapRemaining': '252',
        'snapshots': [
            {
                'description': '',
                'snapVolumeStatus': 'ACTIVATED',
                'createTime': {
                    'timeZone': 'IST',
                    'epochTime': 1418061170},
                'snapVolume': 'fca1ad5a73e9447ea541a7d2d141c979',
                'id': 'a5967958-705e-4835-9089-66e6358d7514',
                'name': 'snap7'
            },
            {
                'description': '',
                'snapVolumeStatus': 'ACTIVATED',
                'createTime': {
                    'timeZone': 'IST',
                    'epochTime': 1418061175},
                'snapVolume': 'b25e8490fdef46dd82bff94b27df15a8',
                'id': 'cc8b262f-a6d5-4d41-ad5d-e5ac90d73ca4',
                'name': 'snap6'
            },
            {
                'description': 'this is a sample description',
                'snapVolumeStatus': 'ACTIVATED',
                'createTime': {
                    'timeZone': 'IST',
                    'epochTime': 1418293687},
                'snapVolume': '9368c4cd2b8d42e494c929357dd1bc44',
                'id': '8f7135a8-452b-4c14-ba7a-8bf9cbd0efb2',
                'name': 'snap10'
            }
        ]
    }
}

GLUSTER_ALL_VOLUME_SNAPSHOT_LIST = {
    'v1': {
        'snapRemaining': '252',
        'snapshots': [
            {
                'name': 'snap1_v1',
                'snapVolumeStatus': 'ACTIVATED',
                'snapVolumeName': '5eeaf23def3f446d898e1de8461a6aa7',
                'createTime': {
                    'timeZone': 'IST',
                    'epochTime': 1414427103},
                'id': '8add41ae-c60c-4023-a1a6-5093a5d35603',
                'description': ''},
            {
                'name': 'snap2_v1',
                'snapVolumeStatus': 'ACTIVATED',
                'snapVolumeName': '20ddd7e468244bb8a46d70f98b998d62',
                'createTime': {
                    'timeZone': 'IST',
                    'epochTime': 1414427107},
                'id': '96f4f3eb-bab4-40f8-b4d7-3edbc5112b44',
                'description': ''},
            {
                'name': 'snap3_v1',
                'snapVolumeStatus': 'ACTIVATED',
                'snapVolumeName': '692b1b4504304a708aaafb19e7e85118',
                'createTime': {'timeZone': 'IST',
                               'epochTime': 1414427114},
                'id': '309a98d7-e650-4ecd-8d97-b0a5b744c03c',
                'description': ''}
        ]
    }
}

GLUSTER_VOLUME_HEAL_INFO = {
    'bricks': [
        {
            'name': 'ovirt-node-1.test.com:/brick-1',
            'status': 'Connected',
            'hostUuid': 'f0ef3d05-3ef3-411a-af2c-628b0a14278b',
            'numberOfEntries': '10'},
        {
            'name': 'ovirt-node-1.test.com:/brick-2',
            'status': 'Transport endpoint is not connected',
            'hostUuid': 'f0ef3d05-3ef3-411a-af2c-628b0a14278b'},
        {
            'name': 'ovirt-node-1.test.com:/brick-3',
            'status': 'Connected',
            'hostUuid': 'f0ef3d05-3ef3-411a-af2c-628b0a14278b',
            'numberOfEntries': '50'}
    ]
}
