/*
Copyright (c) 2016-2017 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

import React, { Component } from 'react'
import Doc from 'Doc'
import * as concepts from 'concepts'

export default class Document extends Component {
  render () {
    // Find the document:
    const id = this.props.match.params.docId
    const doc = concepts.Concept.find(document.model.documents, id)

    // Return a doc component:
    return <Doc concept={doc}/>
  }
}
