/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.GlusterBrickBuilder;
import org.ovirt.engine.sdk4.builders.OptionBuilder;
import org.ovirt.engine.sdk4.builders.StatisticBuilder;
import org.ovirt.engine.sdk4.internal.containers.GlusterVolumeContainer;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.GlusterBrick;
import org.ovirt.engine.sdk4.types.GlusterVolume;
import org.ovirt.engine.sdk4.types.GlusterVolumeStatus;
import org.ovirt.engine.sdk4.types.GlusterVolumeType;
import org.ovirt.engine.sdk4.types.Option;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.TransportType;

public class GlusterVolumeBuilder {
    private List<GlusterBrick> bricks;
    private Cluster cluster;
    private String comment;
    private String description;
    private BigInteger disperseCount;
    private String href;
    private String id;
    private String name;
    private List<Option> options;
    private BigInteger redundancyCount;
    private BigInteger replicaCount;
    private List<Statistic> statistics;
    private GlusterVolumeStatus status;
    private BigInteger stripeCount;
    private List<TransportType> transportTypes;
    private GlusterVolumeType volumeType;

    public GlusterVolumeBuilder bricks(List<GlusterBrick> newBricks) {
        if (newBricks != null) {
            if (this.bricks == null) {
                this.bricks = new ArrayList<GlusterBrick>(newBricks);
            } else {
                this.bricks.addAll(newBricks);
            }
        }
        return this;
    }

    public GlusterVolumeBuilder bricks(GlusterBrick ... newBricks) {
        if (newBricks != null) {
            if (this.bricks == null) {
                this.bricks = new ArrayList<GlusterBrick>(newBricks.length);
            }
            Collections.addAll(this.bricks, newBricks);
        }
        return this;
    }

    public GlusterVolumeBuilder bricks(GlusterBrickBuilder ... newBricks) {
        if (newBricks != null) {
            if (this.bricks == null) {
                this.bricks = new ArrayList<GlusterBrick>(newBricks.length);
            }
            for (GlusterBrickBuilder builder : newBricks) {
                this.bricks.add(builder.build());
            }
        }
        return this;
    }

    public GlusterVolumeBuilder cluster(Cluster newCluster) {
        this.cluster = newCluster;
        return this;
    }

    public GlusterVolumeBuilder cluster(ClusterBuilder newCluster) {
        this.cluster = newCluster == null ? null : newCluster.build();
        return this;
    }

    public GlusterVolumeBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public GlusterVolumeBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public GlusterVolumeBuilder disperseCount(int newDisperseCount) {
        this.disperseCount = BigInteger.valueOf(newDisperseCount);
        return this;
    }

    public GlusterVolumeBuilder disperseCount(Integer newDisperseCount) {
        this.disperseCount = newDisperseCount == null ? null : BigInteger.valueOf(newDisperseCount.longValue());
        return this;
    }

    public GlusterVolumeBuilder disperseCount(long newDisperseCount) {
        this.disperseCount = BigInteger.valueOf(newDisperseCount);
        return this;
    }

    public GlusterVolumeBuilder disperseCount(Long newDisperseCount) {
        this.disperseCount = newDisperseCount == null ? null : BigInteger.valueOf(newDisperseCount);
        return this;
    }

    public GlusterVolumeBuilder disperseCount(BigInteger newDisperseCount) {
        this.disperseCount = newDisperseCount;
        return this;
    }

    public GlusterVolumeBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public GlusterVolumeBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public GlusterVolumeBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public GlusterVolumeBuilder options(List<Option> newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions);
            } else {
                this.options.addAll(newOptions);
            }
        }
        return this;
    }

    public GlusterVolumeBuilder options(Option ... newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions.length);
            }
            Collections.addAll(this.options, newOptions);
        }
        return this;
    }

    public GlusterVolumeBuilder options(OptionBuilder ... newOptions) {
        if (newOptions != null) {
            if (this.options == null) {
                this.options = new ArrayList<Option>(newOptions.length);
            }
            for (OptionBuilder builder : newOptions) {
                this.options.add(builder.build());
            }
        }
        return this;
    }

    public GlusterVolumeBuilder redundancyCount(int newRedundancyCount) {
        this.redundancyCount = BigInteger.valueOf(newRedundancyCount);
        return this;
    }

    public GlusterVolumeBuilder redundancyCount(Integer newRedundancyCount) {
        this.redundancyCount = newRedundancyCount == null ? null : BigInteger.valueOf(newRedundancyCount.longValue());
        return this;
    }

    public GlusterVolumeBuilder redundancyCount(long newRedundancyCount) {
        this.redundancyCount = BigInteger.valueOf(newRedundancyCount);
        return this;
    }

    public GlusterVolumeBuilder redundancyCount(Long newRedundancyCount) {
        this.redundancyCount = newRedundancyCount == null ? null : BigInteger.valueOf(newRedundancyCount);
        return this;
    }

    public GlusterVolumeBuilder redundancyCount(BigInteger newRedundancyCount) {
        this.redundancyCount = newRedundancyCount;
        return this;
    }

    public GlusterVolumeBuilder replicaCount(int newReplicaCount) {
        this.replicaCount = BigInteger.valueOf(newReplicaCount);
        return this;
    }

    public GlusterVolumeBuilder replicaCount(Integer newReplicaCount) {
        this.replicaCount = newReplicaCount == null ? null : BigInteger.valueOf(newReplicaCount.longValue());
        return this;
    }

    public GlusterVolumeBuilder replicaCount(long newReplicaCount) {
        this.replicaCount = BigInteger.valueOf(newReplicaCount);
        return this;
    }

    public GlusterVolumeBuilder replicaCount(Long newReplicaCount) {
        this.replicaCount = newReplicaCount == null ? null : BigInteger.valueOf(newReplicaCount);
        return this;
    }

    public GlusterVolumeBuilder replicaCount(BigInteger newReplicaCount) {
        this.replicaCount = newReplicaCount;
        return this;
    }

    public GlusterVolumeBuilder statistics(List<Statistic> newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics);
            } else {
                this.statistics.addAll(newStatistics);
            }
        }
        return this;
    }

    public GlusterVolumeBuilder statistics(Statistic ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            Collections.addAll(this.statistics, newStatistics);
        }
        return this;
    }

    public GlusterVolumeBuilder statistics(StatisticBuilder ... newStatistics) {
        if (newStatistics != null) {
            if (this.statistics == null) {
                this.statistics = new ArrayList<Statistic>(newStatistics.length);
            }
            for (StatisticBuilder builder : newStatistics) {
                this.statistics.add(builder.build());
            }
        }
        return this;
    }

    public GlusterVolumeBuilder status(GlusterVolumeStatus newStatus) {
        this.status = newStatus;
        return this;
    }

    public GlusterVolumeBuilder stripeCount(int newStripeCount) {
        this.stripeCount = BigInteger.valueOf(newStripeCount);
        return this;
    }

    public GlusterVolumeBuilder stripeCount(Integer newStripeCount) {
        this.stripeCount = newStripeCount == null ? null : BigInteger.valueOf(newStripeCount.longValue());
        return this;
    }

    public GlusterVolumeBuilder stripeCount(long newStripeCount) {
        this.stripeCount = BigInteger.valueOf(newStripeCount);
        return this;
    }

    public GlusterVolumeBuilder stripeCount(Long newStripeCount) {
        this.stripeCount = newStripeCount == null ? null : BigInteger.valueOf(newStripeCount);
        return this;
    }

    public GlusterVolumeBuilder stripeCount(BigInteger newStripeCount) {
        this.stripeCount = newStripeCount;
        return this;
    }

    public GlusterVolumeBuilder transportTypes(List<TransportType> newTransportTypes) {
        if (newTransportTypes != null) {
            if (this.transportTypes == null) {
                this.transportTypes = new ArrayList<TransportType>(newTransportTypes);
            } else {
                this.transportTypes.addAll(newTransportTypes);
            }
        }
        return this;
    }

    public GlusterVolumeBuilder transportTypes(TransportType ... newTransportTypes) {
        if (newTransportTypes != null) {
            if (this.transportTypes == null) {
                this.transportTypes = new ArrayList<TransportType>(newTransportTypes.length);
            }
            Collections.addAll(this.transportTypes, newTransportTypes);
        }
        return this;
    }

    public GlusterVolumeBuilder volumeType(GlusterVolumeType newVolumeType) {
        this.volumeType = newVolumeType;
        return this;
    }

    public GlusterVolume build() {
        GlusterVolumeContainer container = new GlusterVolumeContainer();
        container.bricks(this.bricks);
        container.cluster(this.cluster);
        container.comment(this.comment);
        container.description(this.description);
        container.disperseCount(this.disperseCount);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.options(this.options);
        container.redundancyCount(this.redundancyCount);
        container.replicaCount(this.replicaCount);
        container.statistics(this.statistics);
        container.status(this.status);
        container.stripeCount(this.stripeCount);
        container.transportTypes(this.transportTypes);
        container.volumeType(this.volumeType);
        return container;
    }
}

