/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.BootContainer;
import org.ovirt.engine.sdk4.types.Boot;
import org.ovirt.engine.sdk4.types.BootDevice;

public class BootBuilder {
    private List<BootDevice> devices;
    
    public BootBuilder devices(List<BootDevice> newDevices) {
        if (newDevices != null) {
            if (devices == null) {
                devices = new ArrayList<>(newDevices);
            }
            else {
                devices.addAll(newDevices);
            }
        }
        return this;
    }
    
    public BootBuilder devices(BootDevice... newDevices) {
        if (newDevices != null) {
            if (devices == null) {
                devices = new ArrayList<>(newDevices.length);
            }
            Collections.addAll(devices, newDevices);
        }
        return this;
    }
    
    
    public Boot build() {
        BootContainer container = new BootContainer();
        container.devices(devices);
        return container;
    }
}
