#
# Copyright 2009-2017 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license
#

from __future__ import absolute_import
import os

GLUSTER_MGMT_ENABLED = bool(1)

# SMBIOS manufacturer
SMBIOS_MANUFACTURER = 'oVirt'
SMBIOS_OSNAME = 'oVirt Node'

#
# file ownership definitions
#
VDSM_USER = 'vdsm'
VDSM_GROUP = 'kvm'
DISKIMAGE_USER = 'vdsm'
DISKIMAGE_GROUP = 'qemu'
METADATA_USER = 'vdsm'
METADATA_GROUP = 'kvm'
QEMU_PROCESS_USER = 'qemu'
QEMU_PROCESS_GROUP = 'qemu'
OVIRT_VMCONSOLE_USER = 'ovirt-vmconsole'
OVIRT_VMCONSOLE_GROUP = 'ovirt-vmconsole'


# Sanlock definitions
SANLOCK_ENABLED = 'yes' == 'yes'
SANLOCK_USER = 'sanlock'

# Libvirt selinux
LIBVIRT_SELINUX = 'yes' == 'yes'

MEGAB = 2 ** 20  # = 1024 ** 2 = 1 MiB
GIB = 1024 * MEGAB

#
# Path definitions
#
P_LIBVIRT_VMCHANNELS = '/var/lib/libvirt/qemu/channels/'
P_OVIRT_VMCONSOLES = '/var/run/ovirt-vmconsole-console/'
P_VDSM = '/usr/share/vdsm/'  # NOQA: E501 (potentially long line)
P_VDSM_HOOKS = '/usr/libexec/vdsm/hooks/'  # NOQA: E501 (potentially long line)
P_VDSM_LIB = '/var/lib/vdsm/'  # NOQA: E501 (potentially long line)
P_VDSM_RUN = '/var/run/vdsm/'  # NOQA: E501 (potentially long line)
P_VDSM_CONF = '/etc/vdsm/'  # NOQA: E501 (potentially long line)

P_VDSM_LOG = '/var/log/vdsm'  # NOQA: E501 (potentially long line)

P_VDSM_EXEC = '/usr/libexec/vdsm'  # NOQA: E501 (potentially long line)

#
# Configuration file definitions
#
SYSCONF_PATH = '/etc'

#
# External programs (sorted, please keep in order).
#
EXT_CHOWN = '/usr/bin/chown'

EXT_DD = '/usr/bin/dd'
EXT_DMIDECODE = '/usr/sbin/dmidecode'
EXT_DMSETUP = '/usr/sbin/dmsetup'

EXT_FENCE_PREFIX = os.path.dirname('/usr/sbin/fence_ilo') + '/fence_'
EXT_FSCK = '/usr/sbin/fsck'
EXT_FUSER = '/usr/sbin/fuser'

EXT_GREP = '/usr/bin/grep'

EXT_IONICE = '/usr/bin/ionice'
EXT_ISCSIADM = '/usr/sbin/iscsiadm'

EXT_KILL = '/usr/bin/kill'

EXT_LVM = '/usr/sbin/lvm'

EXT_MKFS = '/usr/sbin/mkfs'
EXT_MKFS_MSDOS = '/usr/sbin/mkfs.msdos'
EXT_MKISOFS = '/usr/bin/mkisofs'
EXT_MOUNT = '/usr/bin/mount'
EXT_MULTIPATH = '/usr/sbin/multipath'

EXT_NICE = '/usr/bin/nice'

EXT_SETSID = '/usr/bin/setsid'
EXT_SH = '/bin/sh'  # The shell path is invariable
EXT_SU = '/usr/bin/su'
EXT_SUDO = '/usr/bin/sudo'

EXT_TAR = '/usr/bin/tar'
EXT_TASKSET = '/usr/bin/taskset'
EXT_TUNE2FS = '/usr/sbin/tune2fs'

EXT_UMOUNT = '/usr/bin/umount'

EXT_SAFELEASE = '/usr/libexec/safelease/safelease'

EXT_CURL_IMG_WRAP = '/usr/libexec/vdsm/curl-img-wrap'  # NOQA: E501 (potentially long line)
EXT_FC_SCAN = '/usr/libexec/vdsm/fc-scan'  # NOQA: E501 (potentially long line)
EXT_KVM_2_OVIRT = '/usr/libexec/vdsm/kvm2ovirt'  # NOQA: E501 (potentially long line)
