#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

%if 0%{?fedora}
%global		with_python3 1
%global		__python_bin %{__python3}
%global		__python_sitelib %{python3_sitelib}
%else
%global		__python_bin %{__python2}
%global		__python_sitelib %{python2_sitelib}
%endif

%if 0%{?fedora}
%global ovirt_rh_postgresql95 0
%else
%global ovirt_rh_postgresql95 1
%endif

%global		package_version 4.2.6
%global		package_name ovirt-log-collector

Summary:	Log Collector for oVirt Engine
Name:		%{package_name}
Version:	4.2.6
Release:	1%{?release_suffix}%{?dist}
License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/src/%{package_name}/%{package_name}-%{package_version}.tar.gz

BuildArch:	noarch

Requires:	logrotate
Requires:	openssl
Requires:	openssh-clients
Requires:	sos >= 3.3

Requires:	ovirt-engine-lib

BuildRequires:	gettext

%if 0%{?with_python3}
Requires:	python3
Requires:	python3-dateutil
Requires:	python3-lxml
Requires:	python3-ovirt-engine-sdk4 >= 4.2.0
BuildRequires:	python3-devel
%else
Requires:	python
Requires:	python-dateutil
Requires:	python-lxml
Requires:	python-ovirt-engine-sdk4 >= 4.2.0
BuildRequires:	python2-devel
%endif

%description
Log Collector tool for oVirt Engine

%package analyzer
Summary:	Log Collector for oVirt Engine - Analysis tools
Requires:	rubygem-asciidoctor
Requires:	libxml2

%if %{ovirt_rh_postgresql95}
Requires:       rh-postgresql95-postgresql-server
%else
Requires:       postgresql-server
%endif

Requires:	coreutils
License:	ASL 2.0 and GPLv2+

%description analyzer
This package contains tools to help analyze oVirt Log Collector archives

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure \
	--docdir="%{_docdir}/%{package_name}-%{version}" \
	--disable-python-syntax-check \
	PYTHON="%{__python_bin}"
make %{?_smp_mflags}

%check
make check

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files
%doc AUTHORS
%license COPYING
%dir %{_localstatedir}/log/ovirt-engine/%{package_name}
%dir %{_sysconfdir}/ovirt-engine/logcollector.conf.d
%config(noreplace) %{_sysconfdir}/ovirt-engine/logcollector.conf
%config(noreplace) %{_sysconfdir}/logrotate.d/%{package_name}
%{__python_sitelib}/ovirt_log_collector/
%{_bindir}/ovirt-log-collector
%{_mandir}/man8/ovirt-log-collector.8*

%files analyzer
%doc AUTHORS
%license COPYING
%license COPYING-GPL
%{_bindir}/ovirt-log-collector-analyzer
%dir %{_datadir}/%{name}/analyzer
%{_datadir}/%{name}/analyzer/
%{_mandir}/man8/ovirt-log-collector-analyzer.8*

%changelog
* Thu May 24 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.6-1
- 4.2.6-1

* Thu Apr 19 2018 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.2.5-1
- 4.2.5-1

* Tue Feb 20 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.4-1
- 4.2.4-1

* Fri Jan 19 2018 Douglas Schilling Landgraf <dougsland@redhat.com> - 4.2.3-1
- 4.2.3-1

* Thu Jan 11 2018 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.1-1
- 4.2.1-1

* Wed Nov 29 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-1
- 4.2.0-1

* Thu May 25 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 4.2.0-0.0.master
- 4.2.0-0.0.master

* Thu Aug  4 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 4.1.0-0.0.master
- 4.1.0-0.0.master

* Wed Aug  5 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 4.0.0-0.0.master
- 4.0.0-0.0.master
