'use strict';

// Credit for list: http://www.i18nguy.com/markup/idna-examples.html
module.exports = {
  valid: [
    { ascii: 'xn--mgbaal8b0b9b2b.icom.museum',
      unicode: 'افغانستا.icom.museum'
    },
    {
      ascii: 'xn--lgbbat1ad8j.icom.museum',
      unicode: 'الجزائر.icom.museum'
    },
    {
      ascii: 'xn--sterreich-z7a.icom.museum',
      unicode: 'österreich.icom.museum'
    },
    {
      ascii: 'xn--54b6eqazv8bc7e.icom.museum',
      unicode: 'বাংলাদেশ.icom.museum'
    },
    {
      ascii: 'xn--80abmy0agn7e.icom.museum',
      unicode: 'беларусь.icom.museum'
    },
    {
      ascii: 'xn--belgi-rsa.icom.museum',
      unicode: 'belgië.icom.museum'
    },
    {
      ascii: 'xn--80abgvm6a7d2b.icom.museum',
      unicode: 'българия.icom.museum'
    },
    {
      ascii: 'xn--mgbfqim.icom.museum',
      unicode: 'تشادر.icom.museum'
    },
    {
      ascii: 'xn--fiqs8s.icom.museum',
      unicode: '中国.icom.museum'
    },
    {
      ascii: 'xn--mgbu4chg.icom.museum',
      unicode: 'القمر.icom.museum'
    },
    {
      ascii: 'xn--vxakcego.icom.museum',
      unicode: 'κυπρος.icom.museum'
    },
    {
      ascii: 'xn--eskrepublika-ebb62d.icom.museum',
      unicode: 'českárepublika.icom.museum'
    },
    {
      ascii: 'xn--wgbh1c.icom.museum',
      unicode: 'مصر.icom.museum'
    },
    {
      ascii: 'xn--hxakic4aa.icom.museum',
      unicode: 'ελλάδα.icom.museum'
    },
    {
      ascii: 'xn--magyarorszg-t7a.icom.museum',
      unicode: 'magyarország.icom.museum'
    },
    {
      ascii: 'xn--sland-ysa.icom.museum',
      unicode: 'ísland.icom.museum'
    },
    {
      ascii: 'xn--h2brj9c.icom.museum',
      unicode: 'भारत.icom.museum'
    },
    {
      ascii: 'xn--mgba3a4fra.icom.museum',
      unicode: 'ايران.icom.museum'
    },
    {
      ascii: 'xn--ire-9la.icom.museum',
      unicode: 'éire.icom.museum'
    },
    {
      ascii: 'xn--4dbklr2c8d.xn--4dbrk0ce.museum',
      unicode: 'איקו״ם.ישראל.museum'
    },
    {
      ascii: 'xn--wgv71a.icom.museum',
      unicode: '日本.icom.museum'
    },
    {
      ascii: 'xn--igbhzh7gpa.icom.museum',
      unicode: 'الأردن.icom.museum'
    },
    {
      ascii: 'xn--80aaa0a6awh12ed.icom.museum',
      unicode: 'қазақстан.icom.museum'
    },
    {
      ascii: 'xn--3e0b707e.icom.museum',
      unicode: '한국.icom.museum'
    },
    {
      ascii: 'xn--80afmksoji0fc.icom.museum',
      unicode: 'кыргызстан.icom.museum'
    },
    {
      ascii: 'xn--q7ce6a.icom.museum',
      unicode: 'ລາວ.icom.museum'
    },
    {
      ascii: 'xn--mgbb7fjb.icom.museum',
      unicode: 'لبنان.icom.museum'
    },
    {
      ascii: 'xn--80aaldqjmmi6x.icom.museum',
      unicode: 'македонија.icom.museum'
    },
    {
      ascii: 'xn--mgbah1a3hjkrd.icom.museum',
      unicode: 'موريتانيا.icom.museum'
    },
    {
      ascii: 'xn--mxico-bsa.icom.museum',
      unicode: 'méxico.icom.museum'
    },
    {
      ascii: 'xn--c1aqabffc0aq.icom.museum',
      unicode: 'монголулс.icom.museum'
    },
    {
      ascii: 'xn--mgbc0a9azcg.icom.museum',
      unicode: 'المغرب.icom.museum'
    },
    {
      ascii: 'xn--l2bey1c2b.icom.museum',
      unicode: 'नेपाल.icom.museum'
    },
    {
      ascii: 'xn--mgb9awbf.icom.museum',
      unicode: 'عمان.icom.museum'
    },
    {
      ascii: 'xn--wgbl6a.icom.museum',
      unicode: 'قطر.icom.museum'
    },
    {
      ascii: 'xn--romnia-yta.icom.museum',
      unicode: 'românia.icom.museum'
    },
    {
      ascii: 'xn--h1alffa9f.xn--h1aegh.museum',
      unicode: 'россия.иком.museum'
    },
    {
      ascii: 'xn--80aaabm1ab4blmeec9e7n.xn--h1aegh.museum',
      unicode: 'србијаицрнагора.иком.museum'
    },
    {
      ascii: 'xn--xkc2al3hye2a.icom.museum',
      unicode: 'இலங்கை.icom.museum'
    },
    {
      ascii: 'xn--espaa-rta.icom.museum',
      unicode: 'españa.icom.museum'
    },
    {
      ascii: 'xn--o3cw4h.icom.museum',
      unicode: 'ไทย.icom.museum'
    },
    {
      ascii: 'xn--pgbs0dh.icom.museum',
      unicode: 'تونس.icom.museum'
    },
    {
      ascii: 'xn--trkiye-3ya.icom.museum',
      unicode: 'türkiye.icom.museum'
    },
    {
      ascii: 'xn--80aaxgrpt.icom.museum',
      unicode: 'украина.icom.museum'
    },
    {
      ascii: 'xn--vitnam-jk8b.icom.museum',
      unicode: 'việtnam.icom.museum'
    },
    // long label
    {
      ascii: `${'a'.repeat(64)}.com`,
      unicode: `${'a'.repeat(64)}.com`,
    },
    // long URL
    {
      ascii: `${`${'a'.repeat(64)}.`.repeat(4)}com`,
      unicode: `${`${'a'.repeat(64)}.`.repeat(4)}com`
    },
    // URLs with hyphen
    {
      ascii: 'r4---sn-a5mlrn7s.gevideo.com',
      unicode: 'r4---sn-a5mlrn7s.gevideo.com'
    },
    {
      ascii: '-sn-a5mlrn7s.gevideo.com',
      unicode: '-sn-a5mlrn7s.gevideo.com'
    },
    {
      ascii: 'sn-a5mlrn7s-.gevideo.com',
      unicode: 'sn-a5mlrn7s-.gevideo.com'
    },
    {
      ascii: '-sn-a5mlrn7s-.gevideo.com',
      unicode: '-sn-a5mlrn7s-.gevideo.com'
    },
    {
      ascii: '-sn--a5mlrn7s-.gevideo.com',
      unicode: '-sn--a5mlrn7s-.gevideo.com'
    }
  ],
  invalid: [
    // invalid character
    '\ufffd.com',
    // invalid bi-directional character
    'تشادرlatin.icom.museum'
  ]
}
