/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.OpenStackNetworkProviderContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlAgentConfigurationReader;
import org.ovirt.engine.sdk4.internal.xml.XmlCertificateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkPluginTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackNetworkProviderTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenStackSubnetReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPropertyReader;
import org.ovirt.engine.sdk4.types.Certificate;
import org.ovirt.engine.sdk4.types.OpenStackNetwork;
import org.ovirt.engine.sdk4.types.OpenStackNetworkProvider;
import org.ovirt.engine.sdk4.types.OpenStackSubnet;

public class XmlOpenStackNetworkProviderReader {
    public static OpenStackNetworkProvider readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        OpenStackNetworkProviderContainer object = new OpenStackNetworkProviderContainer();
        block54: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block54;
                }
                case "id": {
                    object.id(image);
                    continue block54;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block55: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "agent_configuration": {
                    object.agentConfiguration(XmlAgentConfigurationReader.readOne(reader));
                    continue block55;
                }
                case "authentication_url": {
                    object.authenticationUrl(reader.readString());
                    continue block55;
                }
                case "auto_sync": {
                    object.autoSync(reader.readBoolean());
                    continue block55;
                }
                case "certificates": {
                    object.certificates(XmlCertificateReader.readMany(reader));
                    continue block55;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block55;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block55;
                }
                case "external_plugin_type": {
                    object.externalPluginType(reader.readString());
                    continue block55;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block55;
                }
                case "networks": {
                    object.networks(XmlOpenStackNetworkReader.readMany(reader));
                    continue block55;
                }
                case "password": {
                    object.password(reader.readString());
                    continue block55;
                }
                case "plugin_type": {
                    object.pluginType(XmlNetworkPluginTypeReader.readOne(reader));
                    continue block55;
                }
                case "properties": {
                    object.properties(XmlPropertyReader.readMany(reader));
                    continue block55;
                }
                case "read_only": {
                    object.readOnly(reader.readBoolean());
                    continue block55;
                }
                case "requires_authentication": {
                    object.requiresAuthentication(reader.readBoolean());
                    continue block55;
                }
                case "subnets": {
                    object.subnets(XmlOpenStackSubnetReader.readMany(reader));
                    continue block55;
                }
                case "tenant_name": {
                    object.tenantName(reader.readString());
                    continue block55;
                }
                case "type": {
                    object.type(XmlOpenStackNetworkProviderTypeReader.readOne(reader));
                    continue block55;
                }
                case "unmanaged": {
                    object.unmanaged(reader.readBoolean());
                    continue block55;
                }
                case "url": {
                    object.url(reader.readString());
                    continue block55;
                }
                case "username": {
                    object.username(reader.readString());
                    continue block55;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block55;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlOpenStackNetworkProviderReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<OpenStackNetworkProvider> iterateMany(final XmlReader reader) {
        return new Iterator<OpenStackNetworkProvider>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public OpenStackNetworkProvider next() {
                OpenStackNetworkProvider next = XmlOpenStackNetworkProviderReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<OpenStackNetworkProvider> readMany(XmlReader reader) {
        ArrayList<OpenStackNetworkProvider> list = new ArrayList<OpenStackNetworkProvider>();
        Iterator<OpenStackNetworkProvider> iterator = XmlOpenStackNetworkProviderReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(OpenStackNetworkProviderContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "certificates": {
                    ArrayListWithHref<Certificate> list = new ArrayListWithHref<Certificate>(object.certificates());
                    list.href(href);
                    object.certificates(list);
                    break;
                }
                case "networks": {
                    ArrayListWithHref<OpenStackNetwork> list = new ArrayListWithHref<OpenStackNetwork>(object.networks());
                    list.href(href);
                    object.networks(list);
                    break;
                }
                case "subnets": {
                    ArrayListWithHref<OpenStackSubnet> list = new ArrayListWithHref<OpenStackSubnet>(object.subnets());
                    list.href(href);
                    object.subnets(list);
                    break;
                }
            }
        }
    }
}

