/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.j2ee;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.j2ee.BeanMethodChecker;
import com.puppycrawl.tools.checkstyle.checks.j2ee.MessageBeanCheck;
import com.puppycrawl.tools.checkstyle.checks.j2ee.Utils;

public class MessageBeanMethodChecker
extends BeanMethodChecker {
    private boolean mHasEjbCreate;

    public MessageBeanMethodChecker(MessageBeanCheck aCheck) {
        super(aCheck);
    }

    public void checkMethods(DetailAST aAST) {
        this.mHasEjbCreate = false;
        super.checkMethods(aAST);
        if (!this.mHasEjbCreate) {
            DetailAST nameAST = aAST.findFirstToken(58);
            String name = nameAST.getText();
            String arg = "Message bean '" + name + "'";
            this.log(aAST, "missingmethod.bean", new Object[]{arg, "ejbCreate()"});
        }
    }

    protected void checkCreateMethod(DetailAST aMethodAST) {
        DetailAST nameAST = aMethodAST.findFirstToken(58);
        String name = nameAST.getText();
        if (name.equals("ejbCreate")) {
            DetailAST paramAST;
            int paramCount;
            super.checkCreateMethod(aMethodAST);
            this.mHasEjbCreate = true;
            if (!Utils.isVoid(aMethodAST)) {
                this.logName(aMethodAST, "nonvoidmethod.bean", new Object[0]);
            }
            if ((paramCount = (paramAST = aMethodAST.findFirstToken(20)).getChildCount()) != 0) {
                this.logName(aMethodAST, "paramcount.bean", new Object[]{"0"});
            }
        }
    }
}

