/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;
import java.util.List;

public interface Disk extends Device {
    boolean active();
    
    boolean activePresent();
    
    BigInteger actualSize();
    
    boolean actualSizePresent();
    
    String alias();
    
    boolean aliasPresent();
    
    boolean bootable();
    
    boolean bootablePresent();
    
    DiskFormat format();
    
    boolean formatPresent();
    
    String imageId();
    
    boolean imageIdPresent();
    
    DiskInterface interface_();
    
    boolean interface_Present();
    
    String logicalName();
    
    boolean logicalNamePresent();
    
    HostStorage lunStorage();
    
    boolean lunStoragePresent();
    
    boolean propagateErrors();
    
    boolean propagateErrorsPresent();
    
    BigInteger provisionedSize();
    
    boolean provisionedSizePresent();
    
    boolean readOnly();
    
    boolean readOnlyPresent();
    
    ScsiGenericIO sgio();
    
    boolean sgioPresent();
    
    boolean shareable();
    
    boolean shareablePresent();
    
    boolean sparse();
    
    boolean sparsePresent();
    
    DiskStatus status();
    
    boolean statusPresent();
    
    DiskStorageType storageType();
    
    boolean storageTypePresent();
    
    boolean usesScsiReservation();
    
    boolean usesScsiReservationPresent();
    
    boolean wipeAfterDelete();
    
    boolean wipeAfterDeletePresent();
    
    DiskProfile diskProfile();
    
    boolean diskProfilePresent();
    
    OpenStackVolumeType openstackVolumeType();
    
    boolean openstackVolumeTypePresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    Quota quota();
    
    boolean quotaPresent();
    
    Snapshot snapshot();
    
    boolean snapshotPresent();
    
    List<Statistic> statistics();
    
    boolean statisticsPresent();
    
    StorageDomain storageDomain();
    
    boolean storageDomainPresent();
    
    List<StorageDomain> storageDomains();
    
    boolean storageDomainsPresent();
    
}
