/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.types.Bonding;
import org.ovirt.engine.sdk4.types.HostNic;
import org.ovirt.engine.sdk4.types.Mac;
import org.ovirt.engine.sdk4.types.Option;

public class BondingContainer extends Container implements Bonding {
    private Mac adPartnerMac;
    private List<Option> options;
    private List<HostNic> slaves;
    
    public Mac adPartnerMac() {
        return adPartnerMac;
    }
    
    public void adPartnerMac(Mac newAdPartnerMac) {
        adPartnerMac = newAdPartnerMac;
    }
    
    public boolean adPartnerMacPresent() {
        return adPartnerMac != null;
    }
    
    public List<Option> options() {
        return makeUnmodifiableList(options);
    }
    
    public void options(List<Option> newOptions) {
        options = makeArrayList(newOptions);
    }
    
    public boolean optionsPresent() {
        return options != null && !options.isEmpty();
    }
    
    public List<HostNic> slaves() {
        return makeUnmodifiableList(slaves);
    }
    
    public void slaves(List<HostNic> newSlaves) {
        slaves = makeArrayList(newSlaves);
    }
    
    public boolean slavesPresent() {
        return slaves != null && !slaves.isEmpty();
    }
    
}
