/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import java.lang.String;
import org.ovirt.engine.sdk4.internal.containers.ImageTransferContainer;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.Image;
import org.ovirt.engine.sdk4.types.ImageTransfer;
import org.ovirt.engine.sdk4.types.ImageTransferPhase;

public class ImageTransferBuilder {
    private String comment;
    private String description;
    private Host host;
    private String href;
    private String id;
    private Image image;
    private String name;
    private ImageTransferPhase phase;
    private String proxyUrl;
    private String signedTicket;
    
    public ImageTransferBuilder comment(String newComment) {
        comment = newComment;
        return this;
    }
    
    
    public ImageTransferBuilder description(String newDescription) {
        description = newDescription;
        return this;
    }
    
    
    public ImageTransferBuilder host(Host newHost) {
        host = newHost;
        return this;
    }
    
    public ImageTransferBuilder host(HostBuilder newHost) {
        if (newHost == null) {
            host = null;
        }
        else {
            host = newHost.build();
        }
        return this;
    }
    
    
    public ImageTransferBuilder href(String newHref) {
        href = newHref;
        return this;
    }
    
    
    public ImageTransferBuilder id(String newId) {
        id = newId;
        return this;
    }
    
    
    public ImageTransferBuilder image(Image newImage) {
        image = newImage;
        return this;
    }
    
    public ImageTransferBuilder image(ImageBuilder newImage) {
        if (newImage == null) {
            image = null;
        }
        else {
            image = newImage.build();
        }
        return this;
    }
    
    
    public ImageTransferBuilder name(String newName) {
        name = newName;
        return this;
    }
    
    
    public ImageTransferBuilder phase(ImageTransferPhase newPhase) {
        phase = newPhase;
        return this;
    }
    
    
    public ImageTransferBuilder proxyUrl(String newProxyUrl) {
        proxyUrl = newProxyUrl;
        return this;
    }
    
    
    public ImageTransferBuilder signedTicket(String newSignedTicket) {
        signedTicket = newSignedTicket;
        return this;
    }
    
    
    public ImageTransfer build() {
        ImageTransferContainer container = new ImageTransferContainer();
        container.comment(comment);
        container.description(description);
        container.host(host);
        container.href(href);
        container.id(id);
        container.image(image);
        container.name(name);
        container.phase(phase);
        container.proxyUrl(proxyUrl);
        container.signedTicket(signedTicket);
        return container;
    }
}
