/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.HostNicBuilder;
import org.ovirt.engine.sdk4.builders.IpAddressAssignmentBuilder;
import org.ovirt.engine.sdk4.builders.NetworkBuilder;
import org.ovirt.engine.sdk4.builders.PropertyBuilder;
import org.ovirt.engine.sdk4.builders.QosBuilder;
import org.ovirt.engine.sdk4.builders.ReportedConfigurationBuilder;
import org.ovirt.engine.sdk4.internal.containers.NetworkAttachmentContainer;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.HostNic;
import org.ovirt.engine.sdk4.types.IpAddressAssignment;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkAttachment;
import org.ovirt.engine.sdk4.types.Property;
import org.ovirt.engine.sdk4.types.Qos;
import org.ovirt.engine.sdk4.types.ReportedConfiguration;

public class NetworkAttachmentBuilder {
    private String comment;
    private String description;
    private Host host;
    private HostNic hostNic;
    private String href;
    private String id;
    private Boolean inSync;
    private List<IpAddressAssignment> ipAddressAssignments;
    private String name;
    private Network network;
    private List<Property> properties;
    private Qos qos;
    private List<ReportedConfiguration> reportedConfigurations;

    public NetworkAttachmentBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public NetworkAttachmentBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public NetworkAttachmentBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public NetworkAttachmentBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public NetworkAttachmentBuilder hostNic(HostNic newHostNic) {
        this.hostNic = newHostNic;
        return this;
    }

    public NetworkAttachmentBuilder hostNic(HostNicBuilder newHostNic) {
        this.hostNic = newHostNic == null ? null : newHostNic.build();
        return this;
    }

    public NetworkAttachmentBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public NetworkAttachmentBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public NetworkAttachmentBuilder inSync(boolean newInSync) {
        this.inSync = newInSync;
        return this;
    }

    public NetworkAttachmentBuilder inSync(Boolean newInSync) {
        this.inSync = newInSync;
        return this;
    }

    public NetworkAttachmentBuilder ipAddressAssignments(List<IpAddressAssignment> newIpAddressAssignments) {
        if (newIpAddressAssignments != null) {
            if (this.ipAddressAssignments == null) {
                this.ipAddressAssignments = new ArrayList<IpAddressAssignment>(newIpAddressAssignments);
            } else {
                this.ipAddressAssignments.addAll(newIpAddressAssignments);
            }
        }
        return this;
    }

    public NetworkAttachmentBuilder ipAddressAssignments(IpAddressAssignment ... newIpAddressAssignments) {
        if (newIpAddressAssignments != null) {
            if (this.ipAddressAssignments == null) {
                this.ipAddressAssignments = new ArrayList<IpAddressAssignment>(newIpAddressAssignments.length);
            }
            Collections.addAll(this.ipAddressAssignments, newIpAddressAssignments);
        }
        return this;
    }

    public NetworkAttachmentBuilder ipAddressAssignments(IpAddressAssignmentBuilder ... newIpAddressAssignments) {
        if (newIpAddressAssignments != null) {
            if (this.ipAddressAssignments == null) {
                this.ipAddressAssignments = new ArrayList<IpAddressAssignment>(newIpAddressAssignments.length);
            }
            for (IpAddressAssignmentBuilder builder : newIpAddressAssignments) {
                this.ipAddressAssignments.add(builder.build());
            }
        }
        return this;
    }

    public NetworkAttachmentBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public NetworkAttachmentBuilder network(Network newNetwork) {
        this.network = newNetwork;
        return this;
    }

    public NetworkAttachmentBuilder network(NetworkBuilder newNetwork) {
        this.network = newNetwork == null ? null : newNetwork.build();
        return this;
    }

    public NetworkAttachmentBuilder properties(List<Property> newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties);
            } else {
                this.properties.addAll(newProperties);
            }
        }
        return this;
    }

    public NetworkAttachmentBuilder properties(Property ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            Collections.addAll(this.properties, newProperties);
        }
        return this;
    }

    public NetworkAttachmentBuilder properties(PropertyBuilder ... newProperties) {
        if (newProperties != null) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>(newProperties.length);
            }
            for (PropertyBuilder builder : newProperties) {
                this.properties.add(builder.build());
            }
        }
        return this;
    }

    public NetworkAttachmentBuilder qos(Qos newQos) {
        this.qos = newQos;
        return this;
    }

    public NetworkAttachmentBuilder qos(QosBuilder newQos) {
        this.qos = newQos == null ? null : newQos.build();
        return this;
    }

    public NetworkAttachmentBuilder reportedConfigurations(List<ReportedConfiguration> newReportedConfigurations) {
        if (newReportedConfigurations != null) {
            if (this.reportedConfigurations == null) {
                this.reportedConfigurations = new ArrayList<ReportedConfiguration>(newReportedConfigurations);
            } else {
                this.reportedConfigurations.addAll(newReportedConfigurations);
            }
        }
        return this;
    }

    public NetworkAttachmentBuilder reportedConfigurations(ReportedConfiguration ... newReportedConfigurations) {
        if (newReportedConfigurations != null) {
            if (this.reportedConfigurations == null) {
                this.reportedConfigurations = new ArrayList<ReportedConfiguration>(newReportedConfigurations.length);
            }
            Collections.addAll(this.reportedConfigurations, newReportedConfigurations);
        }
        return this;
    }

    public NetworkAttachmentBuilder reportedConfigurations(ReportedConfigurationBuilder ... newReportedConfigurations) {
        if (newReportedConfigurations != null) {
            if (this.reportedConfigurations == null) {
                this.reportedConfigurations = new ArrayList<ReportedConfiguration>(newReportedConfigurations.length);
            }
            for (ReportedConfigurationBuilder builder : newReportedConfigurations) {
                this.reportedConfigurations.add(builder.build());
            }
        }
        return this;
    }

    public NetworkAttachment build() {
        NetworkAttachmentContainer container = new NetworkAttachmentContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.host(this.host);
        container.hostNic(this.hostNic);
        container.href(this.href);
        container.id(this.id);
        container.inSync(this.inSync);
        container.ipAddressAssignments(this.ipAddressAssignments);
        container.name(this.name);
        container.network(this.network);
        container.properties(this.properties);
        container.qos(this.qos);
        container.reportedConfigurations(this.reportedConfigurations);
        return container;
    }
}

