/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

class JavadocTag {
    private final int mLineNo;
    private int mColumnNo;
    private final String mTag;
    private final String mArg1;

    JavadocTag(int aLine, int aColumn, String aTag, String aArg1) {
        this.mLineNo = aLine;
        this.mColumnNo = aColumn;
        this.mTag = aTag;
        this.mArg1 = aArg1;
    }

    JavadocTag(int aLine, int aColumn, String aTag) {
        this(aLine, aColumn, aTag, null);
    }

    String getTag() {
        return this.mTag;
    }

    String getArg1() {
        return this.mArg1;
    }

    int getLineNo() {
        return this.mLineNo;
    }

    int getColumnNo() {
        return this.mColumnNo;
    }

    public String toString() {
        return "{Tag = '" + this.getTag() + "', lineNo = " + this.getLineNo() + ", columnNo=" + this.mColumnNo + ", Arg1 = '" + this.getArg1() + "'}";
    }

    boolean isAuthorTag() {
        return "author".equals(this.getTag());
    }

    boolean isReturnTag() {
        return "return".equals(this.getTag());
    }

    boolean isParamTag() {
        return "param".equals(this.getTag());
    }

    boolean isThrowsTag() {
        return "throws".equals(this.getTag()) || "exception".equals(this.getTag());
    }

    boolean isSeeOrInheritDocTag() {
        return "see".equals(this.getTag()) || this.isInheritDocTag();
    }

    boolean isInheritDocTag() {
        return "inheritDoc".equals(this.getTag());
    }
}

