/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNRemoteStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusReporter17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgGetStatus
extends SvnNgOperationRunner<SvnStatus, SvnGetStatus>
implements ISvnObjectReceiver<SvnStatus> {
    private boolean targetDeletedInRepository;

    @Override
    protected SvnStatus run(SVNWCContext context) throws SVNException {
        String targetName;
        File directoryPath;
        SVNNodeKind kind = context.readKind(this.getFirstTarget(), false);
        SVNDepth depth = ((SvnGetStatus)this.getOperation()).getDepth();
        if (kind == SVNNodeKind.DIR) {
            directoryPath = this.getFirstTarget();
            targetName = "";
        } else {
            directoryPath = SVNFileUtil.getParentFile(this.getFirstTarget());
            targetName = SVNFileUtil.getFileName(this.getFirstTarget());
            if (kind == SVNNodeKind.FILE) {
                if (depth == SVNDepth.EMPTY) {
                    depth = SVNDepth.FILES;
                }
            } else {
                boolean notAWc = false;
                try {
                    kind = context.readKind(directoryPath, false);
                    notAWc = kind != SVNNodeKind.DIR;
                }
                catch (SVNException e) {
                    notAWc = true;
                }
                if (notAWc) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "The node ''{0}'' was not found", (Object)this.getFirstTarget());
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
        }
        String[] globalIgnores = context.getOptions().getIgnorePatterns();
        if (((SvnGetStatus)this.getOperation()).isRemote()) {
            SVNURL url = context.getUrlFromPath(directoryPath);
            if (url == null) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.ENTRY_MISSING_URL, "Entry ''{0}'' has no URL", (Object)directoryPath);
                SVNErrorManager.error(error, SVNLogType.WC);
            }
            SVNRepository repository = this.getRepositoryAccess().createRepository(url, null, true);
            long rev = ((SvnGetStatus)this.getOperation()).getRevision() == SVNRevision.HEAD ? -1L : context.getRevisionNumber(((SvnGetStatus)this.getOperation()).getRevision(), null, repository, this.getFirstTarget());
            kind = repository.checkPath("", rev);
            this.checkCancelled();
            SVNStatusEditor17 editor = null;
            SVNReporter17 reporter = null;
            if (kind == SVNNodeKind.NONE) {
                boolean replaced;
                boolean added = context.isNodeAdded(directoryPath);
                if (added && (replaced = context.isNodeReplaced(directoryPath))) {
                    added = false;
                }
                this.setTargetDeletedInRepository(!added);
                editor = new SVNStatusEditor17(this.getFirstTarget(), context, ((SvnGetStatus)this.getOperation()).getOptions(), ((SvnGetStatus)this.getOperation()).isReportIgnored(), ((SvnGetStatus)this.getOperation()).isReportAll(), depth, this);
                editor.setFileListHook(((SvnGetStatus)this.getOperation()).getFileListHook());
                this.checkCancelled();
                editor.closeEdit();
            } else {
                editor = new SVNRemoteStatusEditor17(directoryPath, targetName, context, ((SvnGetStatus)this.getOperation()).getOptions(), ((SvnGetStatus)this.getOperation()).isReportIgnored(), ((SvnGetStatus)this.getOperation()).isReportAll(), depth, this);
                editor.setFileListHook(((SvnGetStatus)this.getOperation()).getFileListHook());
                SVNRepository locksRepos = this.getRepositoryAccess().createRepository(url, null, false);
                this.checkCancelled();
                boolean serverSupportsDepth = repository.hasCapability(SVNCapability.DEPTH);
                reporter = new SVNReporter17(this.getFirstTarget(), context, false, !serverSupportsDepth, depth, false, true, true, false, null);
                SVNStatusReporter17 statusReporter = new SVNStatusReporter17(locksRepos, reporter, editor);
                String target = "".equals(targetName) ? null : targetName;
                SVNDepth statusDepth = ((SvnGetStatus)this.getOperation()).isDepthAsSticky() ? depth : SVNDepth.UNKNOWN;
                repository.status(rev, target, statusDepth, (ISVNReporterBaton)statusReporter, SVNCancellableEditor.newInstance((ISVNEditor)((Object)editor), this, null));
            }
            ((SvnGetStatus)this.getOperation()).setRemoteRevision(editor.getTargetRevision());
            long reportedFiles = reporter != null ? (long)reporter.getReportedFilesCount() : 0L;
            long totalFiles = reporter != null ? (long)reporter.getTotalFilesCount() : 0L;
            SVNEvent event = SVNEventFactory.createSVNEvent(this.getFirstTarget(), SVNNodeKind.NONE, null, editor.getTargetRevision(), SVNEventAction.STATUS_COMPLETED, null, null, null, reportedFiles, totalFiles);
            this.handleEvent(event, -1.0);
        } else {
            SVNStatusEditor17 editor = new SVNStatusEditor17(directoryPath, context, context.getOptions(), ((SvnGetStatus)this.getOperation()).isReportIgnored(), ((SvnGetStatus)this.getOperation()).isReportAll(), depth, this);
            editor.setFileListHook(((SvnGetStatus)this.getOperation()).getFileListHook());
            try {
                editor.walkStatus(this.getFirstTarget(), depth, ((SvnGetStatus)this.getOperation()).isReportAll(), ((SvnGetStatus)this.getOperation()).isReportIgnored(), false, globalIgnores != null ? Arrays.asList(globalIgnores) : null);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_MISSING) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_WORKING_COPY, "''{0}'' is not a working copy", (Object)this.getFirstTarget());
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                throw e;
            }
        }
        if (depth.isRecursive() && ((SvnGetStatus)this.getOperation()).isReportExternals()) {
            Map<File, File> externals = context.getDb().getExternalsDefinedBelow(this.getFirstTarget());
            this.doExternalStatus(externals);
        }
        return (SvnStatus)((SvnGetStatus)this.getOperation()).first();
    }

    private void doExternalStatus(Map<File, File> externalsNew) throws SVNException {
        for (File fullPath : externalsNew.keySet()) {
            File wcRootAbsPath = externalsNew.get(fullPath);
            Structure<StructureFields.ExternalNodeInfo> externalInfo = SvnWcDbExternals.readExternal(this.getWcContext(), fullPath, wcRootAbsPath, StructureFields.ExternalNodeInfo.kind);
            ISVNWCDb.SVNWCDbKind externalKind = (ISVNWCDb.SVNWCDbKind)((Object)externalInfo.get(StructureFields.ExternalNodeInfo.kind));
            if (externalKind != ISVNWCDb.SVNWCDbKind.Dir || SVNFileType.getType(fullPath) != SVNFileType.DIRECTORY) continue;
            this.handleEvent(SVNEventFactory.createSVNEvent(fullPath, SVNNodeKind.DIR, null, -1L, SVNEventAction.STATUS_EXTERNAL, null, null, null), -1.0);
            try {
                SvnGetStatus getStatus = ((SvnGetStatus)this.getOperation()).getOperationFactory().createGetStatus();
                getStatus.setSingleTarget(SvnTarget.fromFile(fullPath));
                getStatus.setRevision(SVNRevision.HEAD);
                getStatus.setDepth(((SvnGetStatus)this.getOperation()).getDepth());
                getStatus.setRemote(((SvnGetStatus)this.getOperation()).isRemote());
                getStatus.setReportAll(((SvnGetStatus)this.getOperation()).isReportAll());
                getStatus.setReportIgnored(((SvnGetStatus)this.getOperation()).isReportIgnored());
                getStatus.setReportExternals(((SvnGetStatus)this.getOperation()).isReportExternals());
                getStatus.setReceiver(((SvnGetStatus)this.getOperation()).getReceiver());
                getStatus.setFileListHook(((SvnGetStatus)this.getOperation()).getFileListHook());
                getStatus.run();
            }
            catch (SVNException e) {
                if (!(e instanceof SVNCancelException)) continue;
                throw e;
            }
        }
    }

    private void setTargetDeletedInRepository(boolean deleted) {
        this.targetDeletedInRepository = deleted;
    }

    private boolean isTargetDeletedInRepository() {
        return this.targetDeletedInRepository;
    }

    @Override
    public void receive(SvnTarget target, SvnStatus object) throws SVNException {
        if (((SvnGetStatus)this.getOperation()).getApplicableChangelists() != null && !((SvnGetStatus)this.getOperation()).getApplicableChangelists().isEmpty() && !((SvnGetStatus)this.getOperation()).getApplicableChangelists().contains(object.getChangelist())) {
            return;
        }
        if (this.isTargetDeletedInRepository()) {
            object.setRepositoryNodeStatus(SVNStatusType.STATUS_DELETED);
        }
        ((SvnGetStatus)this.getOperation()).receive(target, object);
    }

    @Override
    public void reset(SvnWcGeneration wcGeneration) {
        super.reset(wcGeneration);
        this.setTargetDeletedInRepository(false);
    }
}

