/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.checks.AbstractOption;
import java.util.HashMap;
import java.util.Map;

public final class LineSeparatorOption
extends AbstractOption {
    private static final Map STR_TO_OPT = new HashMap();
    public static final LineSeparatorOption CRLF = new LineSeparatorOption("crlf", "\r\n");
    public static final LineSeparatorOption CR = new LineSeparatorOption("cr", "\r");
    public static final LineSeparatorOption LF = new LineSeparatorOption("lf", "\n");
    public static final LineSeparatorOption SYSTEM = new LineSeparatorOption("system", System.getProperty("line.separator"));
    private final String mLineSeparator;

    private LineSeparatorOption(String aStrRep, String aSep) {
        super(aStrRep);
        this.mLineSeparator = aSep;
    }

    public boolean matches(byte[] aBytes) {
        String s = new String(aBytes);
        return s.equals(this.mLineSeparator);
    }

    public int length() {
        return this.mLineSeparator.length();
    }

    protected Map getStrToOpt() {
        return STR_TO_OPT;
    }
}

