#
# ovirt-release -- repo files for oVirt projects
# Copyright (C) 2015 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 3.6.7
%global	package_name ovirt-release36
%global	ovirt_version 3.6
%global	ovirt_yum_repo http://resources.ovirt.org
%global	ovirt_repo_path_normal /pub/yum-repo/mirrorlist-ovirt-3.6-snapshot-
%global	ovirt_repo_path_static /pub/yum-repo/mirrorlist-ovirt-3.6-snapshot-static-
%global	repo_url_key mirrorlist


Name:		%{package_name}
Epoch:		1
Version:	3.6.7
Release:	3%{?release_suffix}%{?dist}
Summary:	The oVirt repository configuration
Group:		System Environment/Base

License:	ASL 2.0
URL:		http://www.ovirt.org
Source0:	http://resources.ovirt.org/pub/ovirt-3.6-pre/src/%{package_name}/%{package_name}-%{package_version}.tar.gz
Source1:	http://resources.ovirt.org/pub/keys/RPM-GPG-ovirt

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch

BuildRequires:	automake
BuildRequires:	autoconf
Requires:	system-release
Requires:	tar

%description
This package contains the yum configuration for oVirt repositories

%global	host_node_release_file ovirt-release-host-node
%package -n ovirt-release-host-node
Summary:	The oVirt Node release file
Version:	3.6.7
Release:	3%{?release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		http://www.ovirt.org
BuildArch:	noarch

BuildRequires:	systemd

Requires(post):	systemd
Requires(postun):	systemd

Requires:	cockpit
Requires:	cockpit-ovirt-dashboard
Requires:	firewalld
Requires:	imgbased
Requires:	vdsm
Requires:	vdsm-gluster
Requires:	glusterfs-rdma
Requires:	ovirt-hosted-engine-setup
Requires:	postfix
Requires:	mailx

# Hack to incldue the passive NM config: https://bugzilla.redhat.com/1326798
Requires:	NetworkManager-config-server

# Additional packages for EFI support
# https://www.brianlane.com/creating-live-isos-with-livemedia-creator.html
# http://lorax.readthedocs.org/en/latest/livemedia-creator.html#kickstarts
Requires:	efibootmgr
Requires:	grub2-efi
Requires:	memtest86+
Requires:	syslinux
Requires:	shim

%description -n ovirt-release-host-node
oVirt Node distribution dependencies, presets and required settings.

%package -n ovirt-node-ng-image-update-placeholder
Summary:	The oVirt Node Image Update Placeholder
Version:	3.6.7
Release:	3%{?release_suffix}%{?dist}
Group:		System Environment/Base
License:	GPLv2
URL:		http://www.ovirt.org
BuildArch:	noarch

Requires:	ovirt-release-host-node = %{epoch}:%{version}-%{release}

%description -n ovirt-node-ng-image-update-placeholder
A sub-package to be included into oVirt Node Next squashfs
image to allow upgrading itself


%package snapshot
Summary:	oVirt snapshot repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description snapshot
This package contains the yum configuration for oVirt snapshot repositories


%package pre
Summary:	oVirt pre-release repository configuration
Group:		System Environment/Base
Requires:	system-release
Requires:	tar

%description pre
This package contains the yum configuration for oVirt pre-release repositories


%prep
%setup -q -n "%{package_name}-%{package_version}"

%build
%configure \
	--with-ovirt-yum-repo=%{ovirt_yum_repo} \
	--with-repo-url-key=%{repo_url_key} \
	--with-repo-path-normal=%{ovirt_repo_path_normal} \
	--with-repo-path-static=%{ovirt_repo_path_static}
make "%{?_smp_mflags}"


%install
rm -rf "%{buildroot}"
%make_install
#Allow ghost files
install -d 755 "%{buildroot}%{_sysconfdir}/yum.repos.d"
install -d "%{buildroot}%{_sysconfdir}/pki/rpm-gpg"
install -m 644 "%{SOURCE1}" "%{buildroot}%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"
touch "%{buildroot}%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-snapshot"
cp -rl "%{buildroot}%{_datadir}/%{package_name}" "%{buildroot}%{_datadir}/%{package_name}-pre"

%post

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER}" == "el6" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-el6-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}/ovirt-el7-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc22" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-f22-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
elif [[ "${DISTVER}" == "fc23" ]]; then
	install -m 644 "%{_datadir}/%{package_name}/ovirt-f23-deps.repo" "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}/ovirt.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo"

%post snapshot

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER}" == "el6" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-el6-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
elif [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-el7-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
elif [[ "${DISTVER}" == "fc22" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-f22-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
elif [[ "${DISTVER}" == "fc23" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-snapshot/ovirt-f23-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-snapshot/ovirt-snapshot.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo"

%post pre

# Adjust repos as per dist and version
DIST=fc
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
	DIST=el
fi

if [[ "${DISTVER}" == "el6" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-el6-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
elif [[ "${DISTVER::3}" == "el7" ]] ; then
	# On some systems [el7_1], take only 3 1st chars: ${var::3}
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-el7-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
elif [[ "${DISTVER}" == "fc22" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-f22-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
elif [[ "${DISTVER}" == "fc23" ]]; then
	install -m 644 "%{_datadir}/%{package_name}-pre/ovirt-f23-deps.repo" \
	"%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre-dependencies.repo"
fi

sed \
	-e "s/@DIST@/${DIST}/g; s/@URLKEY@/%{repo_url_key}/g" \
	<"%{_datadir}/%{package_name}-pre/ovirt-pre.repo" > "%{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo"

%files
%defattr(-,root,root,-)
%{_datadir}/%{package_name}/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
# We do not know what distribution we are installed at,
# we copy the actual files at post, but still wants this package to own them.
# ghost in this case solves that issue
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%files snapshot
%defattr(-,root,root,-)
%{_datadir}/%{package_name}-snapshot/
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-snapshot-dependencies.repo


%files pre
%defattr(-,root,root,-)
%{_datadir}/%{package_name}-pre/
%{_sysconfdir}/pki/rpm-gpg/RPM-GPG-ovirt-%{ovirt_version}
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-pre.repo
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt-%{ovirt_version}-dependencies.repo

%post -n ovirt-release-host-node
%systemd_post cockpit.socket
%systemd_post sshd.service
%systemd_post NetworkManager.service

#
# Create the common os-release file

# Import os-release to get some fields
# NAME, VERSION, ID, VERSION_ID, CPE_NAME
. /etc/os-release || :

install -d /usr/lib/os.release.d/
cat << EOF >> /usr/lib/os.release.d/%{host_node_release_file}
NAME="$NAME"
VERSION="$VERSION"
ID="$ID"
ID_LIKE="$ID_LIKE"
VERSION_ID="$VERSION_ID"
VARIANT="oVirt Node %{package_version}"
VARIANT_ID="ovirt-node"
PRETTY_NAME="oVirt Node %{package_version}"
ANSI_COLOR="$ANSI_COLOR"
CPE_NAME="$CPE_NAME"
HOME_URL="https://www.ovirt.org/"
BUG_REPORT_URL="https://bugzilla.redhat.com/"
EOF

# Only on installation
if [ $1 = 1 ]; then
	cp -p /etc/os-release /usr/lib/os.release.d/.host-node-previous-os-release
	ln -sf os.release.d/%{host_node_release_file} /usr/lib/os-release
	ln -sf ../usr/lib/os-release /etc/os-release
	source /etc/os-release
	ln -sf %{_prefix}/share/ovirt-release-host-node/branding %{_prefix}/share/cockpit/branding/$ID-ovirt-node
fi

# Firewalld - add all services required for host
firewall-offline-cmd --add-service=cockpit >/dev/null 2>&1
firewall-offline-cmd --add-service=vdsm >/dev/null 2>&1
firewall-offline-cmd --add-service=libvirt >/dev/null 2>&1
firewall-offline-cmd --add-service=ssh >/dev/null 2>&1
systemctl restart firewalld.service >/dev/null 2>&1

# Restarting cockpit to load the new branding data
systemctl restart cockpit.service >/dev/null 2>&1

#
# NGN TEMPORARY HACKS
# For each hack there must be a bug, and they must be removed at
# some point in time
# ===================

# Really ensure that myhostname is added
# https://bugzilla.redhat.com/show_bug.cgi?id=132994
sed -i.bak_ngn \
	-e '/^hosts:/ s/myhostname//' \
	-e '/^hosts:/ s/[[:blank:]]*$/ myhostname/' \
	/etc/nsswitch.conf

# Enable NM support on NGN
# Disable host-deploy NM check
# https://bugzilla.redhat.com/show_bug.cgi?id=1330144
mkdir -p %{_sysconfdir}/ovirt-host-deploy.conf.d
cat <<EOF > %{_sysconfdir}/ovirt-host-deploy.conf.d/90-ngn-keep-networkmanager.conf
[environment:init]
VDSM/disableNetworkManager=bool:False
EOF


# Hack out NM check in he-setup
# https://bugzilla.redhat.com/show_bug.cgi?id=1326798
sed -i -e "/def _check_NM/ s/$/\n        return/" \
	/usr/share/ovirt-hosted-engine-setup/plugins/ovirt-hosted-engine-setup/network/bridge.py

# =======================
# NGN TEMPORARY HACKS END
#

%postun -n ovirt-release-host-node
%systemd_postun cockpit.socket
%systemd_postun sshd.socket
%systemd_postun NetworkManager.service
# In case of uninstall the host-node pkg, return the previous os-release
if [ $1 = 0 ]; then
	rm -f %{_prefix}/share/cockpit/branding/*-ovirt-node
	rm -f /usr/lib/os-release /etc/os-release
	cp -pf /usr/lib/os.release.d/.host-node-previous-os-release /usr/lib/os-release
	ln -sf /usr/lib/os-release /etc/os-release
	rm -f /usr/lib/os.release.d/.host-node-previous-os-release
	firewall-offline-cmd --remove-service=cockpit >/dev/null 2>&1
	firewall-offline-cmd --remove-service=vdsm >/dev/null 2>&1
	firewall-offline-cmd --remove-service=libvirt >/dev/null 2>&1
	firewall-offline-cmd --remove-service=ssh >/dev/null 2>&1
	systemctl restart firewalld.service >/dev/null 2>&1
fi
# Restarting cockpit to reload the branding data
systemctl restart cockpit.service >/dev/null 2>&1

%files -n ovirt-node-ng-image-update-placeholder

%files -n ovirt-release-host-node
%ghost %attr(0644, root, root) %{_prefix}/lib/os.release.d/%{host_node_release_file}
%dir %{_prefix}/share/ovirt-release-host-node
%dir %{_prefix}/share/ovirt-release-host-node/branding
%{_presetdir}/98-ovirt-host-node.preset
%{_prefix}/share/ovirt-release-host-node/branding/logo.png
%{_prefix}/share/ovirt-release-host-node/branding/bg-login.png
%{_prefix}/share/ovirt-release-host-node/branding/favicon.ico
%{_prefix}/share/ovirt-release-host-node/branding/branding.css

%changelog
* Thu Oct 26 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1:3.6.7-3
- Fixed CentOS Virt SIG URL for 3.6 which moved to vault (supported only until CentOS 7.3.1611)

* Fri Sep 15 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1:3.6.7-2
- Fixed CentOS Virt SIG URL for 3.6 (supported only until CentOS 7.3.1611)
- added dist tag to release

* Wed Jun  1 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1:3.6.7-1
- 3.6.7 release

* Mon May 23 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.6-1
- 3.6.6 release

* Wed May 11 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.6-0.3
- node: Fix cockpit dependencies

* Tue May 03 2016 Fabian Deutsch <fdeutsch@redhat.com> - 3.6.6-0.2
- node: Fix ssh service

* Wed Apr 13 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 3.6.5-0.0.master
- Align package version ot the overall oVirt version

* Thu Mar 24 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 007-1
- Resolves: BZ#1294083

* Wed Mar 23 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 006-1
- GlusterFS signing key changed

* Thu Mar 17 2016 Fabian Deutsch <fdeutsch@redhat.com> - 005-1
- Rename ovirt-release-<branch>-host-node to ovirt-release-host-node

* Wed Mar 9 2016 Tolik Litovsky <tlitovsk@redhat.com> - 004-1
- Host and node support rpm backport from master

* Wed Dec 23 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 003-1
- Add CentOS Virt SIG oVirt 3.6 repo as dependency for EL7 including openvswitch
- Drop Fedora 21 support

* Wed Nov 11 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-2
- Allow ovirt-guest-agent sub packages to be installed from EPEL

* Tue Nov 10 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 002-1
- Updated Gluster repositories GPG key URL
- Added Fedora 23

* Wed Nov  4 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-2
- oVirt 3.6.0 GA release

* Thu Oct 29 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-1
- 001-1

* Wed Sep  2 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.5.beta
- Fixed post section for snapshot sub-package

* Thu Jul  9 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.4.beta
- Dropped Fedora 20
- Added nightly snapshot repositories

* Thu Jul  9 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.3.alpha
- Added pyxattr and userspace-rcu to EPEL 6 repository for Gluster 3.7.2

* Fri May 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.2.alpha
- Drop Gluster 3.7 Nightly repository since 3.7.0 GA is available
- Add VirtIO-Win Stable repository

* Tue May  5 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 001-0.1.alpha
- Initial packaging for oVirt 3.6.0 First Alpha release
