# Copyright (C) 2015 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# See: https://fedoraproject.org/wiki/Changes/UnversionedDocdirs
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

%global         package_version 1.0.0

Name:           ovirt-live-artwork
Version:        1.0.0
Release:        1%{?dist}
Summary:        oVirt Live Artworks
License:        ASL 2.0
URL:            http://www.ovirt.org
Source0:        http://resources.ovirt.org/pub/ovirt-3.6/src/%{name}/%{name}-%{package_version}.tar.gz
BuildArch:      noarch

%description
oVirt Live Artworks

%package        gnome
Summary:        oVirt Live default wallpaper for Gnome and Cinnamon
Requires:       %{name} = %{version}-%{release}

%description    gnome
This package contains Gnome/Cinnamon desktop wallpaper for the
oVirt Live default theme.

%package        mate
Summary:        oVirt Live default wallpaper for Mate
Requires:       %{name} = %{version}-%{release}

%description    mate
This package contains Mate desktop wallpaper for the oVirt Live
default theme.

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_pkgdocdir}"
        %{?conf}
make %{?_smp_mflags}

%install
%make_install

%files
%doc README.md
# See https://fedoraproject.org/wiki/Changes/Use_license_macro_in_RPMs_for_packages_in_Cloud_Image
%license COPYING NOTICE
%dir %{_datadir}/pixmaps/oVirtLive
%{_datadir}/pixmaps/oVirtLive/*
%dir %{_datadir}/backgrounds/oVirtLive
%dir %{_datadir}/backgrounds/oVirtLive/default
%{_datadir}/backgrounds/oVirtLive/default/normalish
%{_datadir}/backgrounds/oVirtLive/default/standard
%{_datadir}/backgrounds/oVirtLive/default/wide
%{_datadir}/backgrounds/oVirtLive/default/tv-wide
%{_datadir}/backgrounds/oVirtLive/default/oVirtLive.xml

%files gnome
%doc README.md
# See https://fedoraproject.org/wiki/Changes/Use_license_macro_in_RPMs_for_packages_in_Cloud_Image
%license COPYING NOTICE
%{_datadir}/gnome-background-properties/oVirtLive.xml

%files mate
%doc README.md
# See https://fedoraproject.org/wiki/Changes/Use_license_macro_in_RPMs_for_packages_in_Cloud_Image
%license COPYING NOTICE
%{_datadir}/mate-background-properties/oVirtLive.xml


%changelog
* Thu Oct  1 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-1
- 1.0.0

* Fri Jul 17 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.0.master
- Initial packaging
