package org.ovirt.engine.core.vdsbroker.irsbroker;

import org.ovirt.engine.core.common.FeatureSupported;
import org.ovirt.engine.core.common.asynctasks.AsyncTaskCreationInfo;
import org.ovirt.engine.core.common.asynctasks.AsyncTaskType;
import org.ovirt.engine.core.common.businessentities.StoragePool;
import org.ovirt.engine.core.common.vdscommands.CreateImageVDSCommandParameters;
import org.ovirt.engine.core.compat.Guid;
import org.ovirt.engine.core.dal.dbbroker.DbFacade;
import org.ovirt.engine.core.vdsbroker.storage.StorageDomainHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateImageVDSCommand<P extends CreateImageVDSCommandParameters> extends IrsCreateCommand<P> {

    private static final Logger log = LoggerFactory.getLogger(CreateImageVDSCommand.class);

    public CreateImageVDSCommand(P parameters) {
        super(parameters);
    }

    @Override
    protected void executeIrsBrokerCommand() {
        StorageDomainHelper.checkNumberOfLVsForBlockDomain(getParameters().getStorageDomainId());
        setReturnValue(Guid.Empty);

        log.info("-- executeIrsBrokerCommand: calling 'createVolume' with two new parameters: description and UUID");
        // NOTE: The 'uuidReturn' variable will contain the taskID and not the
        // created image id!
        if (isInitialImageSizeSupported() && getParameters().getImageInitialSizeInBytes() != 0) {
            uuidReturn = getIrsProxy().createVolume(
                    getParameters().getStorageDomainId().toString(),
                    getParameters().getStoragePoolId().toString(),
                    getParameters().getImageGroupId().toString(),
                    (Long.valueOf(getParameters().getImageSizeInBytes())).toString(),
                    getParameters().getVolumeFormat().getValue(),
                    getParameters().getImageType().getValue(),
                    2,
                    getParameters().getNewImageID().toString(),
                    getParameters().getNewImageDescription(), Guid.Empty.toString(),
                    Guid.Empty.toString(),
                    (Long.valueOf(getParameters().getImageInitialSizeInBytes())).toString());

        } else {
            uuidReturn = getIrsProxy().createVolume(
                    getParameters().getStorageDomainId().toString(),
                    getParameters().getStoragePoolId().toString(),
                    getParameters().getImageGroupId().toString(),
                    (Long.valueOf(getParameters().getImageSizeInBytes())).toString(),
                    getParameters().getVolumeFormat().getValue(),
                    getParameters().getImageType().getValue(),
                    2,
                    getParameters().getNewImageID().toString(),
                    getParameters().getNewImageDescription(), Guid.Empty.toString(),
                    Guid.Empty.toString());
        }

        proceedProxyReturnValue();

        Guid taskID = new Guid(uuidReturn.uuid);

        createdImageId = getParameters().getNewImageID().toString();
        setReturnValue(new Guid(createdImageId));

        getVDSReturnValue().setCreationInfo(
                new AsyncTaskCreationInfo(taskID, AsyncTaskType.createVolume, getParameters()
                        .getStoragePoolId()));
    }

    private boolean isInitialImageSizeSupported() {
        StoragePool storagePool = DbFacade.getInstance().getStoragePoolDao().get(
                getParameters().getStoragePoolId());
        return FeatureSupported.initialSizeSparseDiskSupported(storagePool.getCompatibilityVersion());
    }
}
