package org.ovirt.engine.core.bll.aaa;

import java.util.Arrays;
import java.util.Collection;

import org.ovirt.engine.api.extensions.aaa.Authz;
import org.ovirt.engine.core.aaa.DirectoryGroup;
import org.ovirt.engine.core.bll.QueriesCommandBase;
import org.ovirt.engine.core.common.queries.DirectoryIdQueryParameters;
import org.ovirt.engine.core.extensions.mgr.ExtensionProxy;
import org.ovirt.engine.core.utils.extensionsmgr.EngineExtensionsManager;

public class GetDirectoryGroupByIdQuery<P extends DirectoryIdQueryParameters> extends QueriesCommandBase<P> {

    public GetDirectoryGroupByIdQuery(P parameters) {
        super(parameters);
    }

    @Override
    protected void executeQueryCommand() {
        final String directoryName = getParameters().getDomain();
        final String id = getParameters().getId();
        final ExtensionProxy authz = EngineExtensionsManager.getInstance().getExtensionByName(directoryName);
        if (authz == null) {
            getQueryReturnValue().setSucceeded(false);
        } else {
            for (String namespace : getParameters().constainsNamespace() ? Arrays.asList(getParameters().getNamespace()) : authz.getContext().<Collection<String>> get(Authz.ContextKeys.AVAILABLE_NAMESPACES)) {
                final DirectoryGroup group = DirectoryUtils.findDirectoryGroupById(authz, namespace, id, false, false);
                if (group != null) {
                    getQueryReturnValue().setReturnValue(group);
                    break;
                }
            }
        }
    }

}
