// ============================================================================
//
// Copyright (c) 2006-2014, Talend Inc.
//
// This source code has been automatically generated by_Talend Open Studio for Data Integration
// / Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
// 
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package ovirt_engine_dwh.historyetl_3_6;

import routines.Mathematical;
import routines.DataOperation;
import routines.Relational;
import routines.TalendDate;
import routines.TalendDataGenerator;
import routines.RoutineHistoryETL;
import routines.Numeric;
import routines.TalendString;
import routines.StringHandling;
import routines.system.*;
import routines.system.api.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.math.BigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.util.Comparator;

//the import part of tLibraryLoad_1
//import java.util.List;

//the import part of tJava_4
//import java.util.List;

//the import part of tJava_1
//import java.util.List;

//the import part of tJavaFlex_2
//import java.util.List;

//the import part of tJavaFlex_1
//import java.util.List;

//the import part of tJavaRow_1
//import java.util.List;

//the import part of tJava_3
//import java.util.List;

@SuppressWarnings("unused")
/**
 * Job: HistoryETL Purpose: <br>
 * Description:  <br>
 * @author ydary@redhat.com
 * @version 5.6.1.20141207_1530
 * @status 
 */
public class HistoryETL implements TalendJob {

	public final Object obj = new Object();

	// for transmiting parameters purpose
	private Object valueObject = null;

	public Object getValueObject() {
		return this.valueObject;
	}

	public void setValueObject(Object valueObject) {
		this.valueObject = valueObject;
	}

	private Object[] multiThreadLockWrite = new Object[0];

	private final static String defaultCharset = java.nio.charset.Charset
			.defaultCharset().name();

	private final static String utf8Charset = "UTF-8";

	// create and load default properties
	private java.util.Properties defaultProps = new java.util.Properties();

	// create application properties with default
	public class ContextProperties extends java.util.Properties {

		private static final long serialVersionUID = 1L;

		public ContextProperties(java.util.Properties properties) {
			super(properties);
		}

		public ContextProperties() {
			super();
		}

		public void synchronizeContext() {

			if (dwhUuid != null) {

				this.setProperty("dwhUuid", dwhUuid.toString());

			}

			if (etlVersion != null) {

				this.setProperty("etlVersion", etlVersion.toString());

			}

			if (hoursToKeepDaily != null) {

				this.setProperty("hoursToKeepDaily",
						hoursToKeepDaily.toString());

			}

			if (hoursToKeepHourly != null) {

				this.setProperty("hoursToKeepHourly",
						hoursToKeepHourly.toString());

			}

			if (hoursToKeepSamples != null) {

				this.setProperty("hoursToKeepSamples",
						hoursToKeepSamples.toString());

			}

			if (lastErrorSent != null) {

				String pattern_lastErrorSent = "yyyy-MM-dd HH:mm:ss";
				String value_lastErrorSent = "yyyy-MM-dd HH:mm:ss.SSSSSS;2011-07-03 12:46:47.000000";
				String[] parts_lastErrorSent = value_lastErrorSent.split(";");
				if (parts_lastErrorSent.length > 1) {
					pattern_lastErrorSent = parts_lastErrorSent[0];
					this.setProperty(
							"lastErrorSent",
							pattern_lastErrorSent
									+ ";"
									+ FormatterUtils.format_Date(lastErrorSent,
											pattern_lastErrorSent));
				} else {
					this.setProperty("lastErrorSent", FormatterUtils
							.format_Date(lastErrorSent, pattern_lastErrorSent));
				}

			}

			if (ovirtEngineDbDriverClass != null) {

				this.setProperty("ovirtEngineDbDriverClass",
						ovirtEngineDbDriverClass.toString());

			}

			if (ovirtEngineDbJdbcConnection != null) {

				this.setProperty("ovirtEngineDbJdbcConnection",
						ovirtEngineDbJdbcConnection.toString());

			}

			if (ovirtEngineDbPassword != null) {

				this.setProperty("ovirtEngineDbPassword",
						ovirtEngineDbPassword.toString());

			}

			if (ovirtEngineDbUser != null) {

				this.setProperty("ovirtEngineDbUser",
						ovirtEngineDbUser.toString());

			}

			if (ovirtEngineHistoryDbDriverClass != null) {

				this.setProperty("ovirtEngineHistoryDbDriverClass",
						ovirtEngineHistoryDbDriverClass.toString());

			}

			if (ovirtEngineHistoryDbJdbcConnection != null) {

				this.setProperty("ovirtEngineHistoryDbJdbcConnection",
						ovirtEngineHistoryDbJdbcConnection.toString());

			}

			if (ovirtEngineHistoryDbPassword != null) {

				this.setProperty("ovirtEngineHistoryDbPassword",
						ovirtEngineHistoryDbPassword.toString());

			}

			if (ovirtEngineHistoryDbUser != null) {

				this.setProperty("ovirtEngineHistoryDbUser",
						ovirtEngineHistoryDbUser.toString());

			}

			if (runDeleteTime != null) {

				this.setProperty("runDeleteTime", runDeleteTime.toString());

			}

			if (runInterleave != null) {

				this.setProperty("runInterleave", runInterleave.toString());

			}

			if (timeBetweenErrorEvents != null) {

				this.setProperty("timeBetweenErrorEvents",
						timeBetweenErrorEvents.toString());

			}

		}

		public String dwhUuid;

		public String getDwhUuid() {
			return this.dwhUuid;
		}

		public String etlVersion;

		public String getEtlVersion() {
			return this.etlVersion;
		}

		public Integer hoursToKeepDaily;

		public Integer getHoursToKeepDaily() {
			return this.hoursToKeepDaily;
		}

		public Integer hoursToKeepHourly;

		public Integer getHoursToKeepHourly() {
			return this.hoursToKeepHourly;
		}

		public Integer hoursToKeepSamples;

		public Integer getHoursToKeepSamples() {
			return this.hoursToKeepSamples;
		}

		public java.util.Date lastErrorSent;

		public java.util.Date getLastErrorSent() {
			return this.lastErrorSent;
		}

		public String ovirtEngineDbDriverClass;

		public String getOvirtEngineDbDriverClass() {
			return this.ovirtEngineDbDriverClass;
		}

		public String ovirtEngineDbJdbcConnection;

		public String getOvirtEngineDbJdbcConnection() {
			return this.ovirtEngineDbJdbcConnection;
		}

		public java.lang.String ovirtEngineDbPassword;

		public java.lang.String getOvirtEngineDbPassword() {
			return this.ovirtEngineDbPassword;
		}

		public String ovirtEngineDbUser;

		public String getOvirtEngineDbUser() {
			return this.ovirtEngineDbUser;
		}

		public String ovirtEngineHistoryDbDriverClass;

		public String getOvirtEngineHistoryDbDriverClass() {
			return this.ovirtEngineHistoryDbDriverClass;
		}

		public String ovirtEngineHistoryDbJdbcConnection;

		public String getOvirtEngineHistoryDbJdbcConnection() {
			return this.ovirtEngineHistoryDbJdbcConnection;
		}

		public java.lang.String ovirtEngineHistoryDbPassword;

		public java.lang.String getOvirtEngineHistoryDbPassword() {
			return this.ovirtEngineHistoryDbPassword;
		}

		public String ovirtEngineHistoryDbUser;

		public String getOvirtEngineHistoryDbUser() {
			return this.ovirtEngineHistoryDbUser;
		}

		public Integer runDeleteTime;

		public Integer getRunDeleteTime() {
			return this.runDeleteTime;
		}

		public Integer runInterleave;

		public Integer getRunInterleave() {
			return this.runInterleave;
		}

		public Long timeBetweenErrorEvents;

		public Long getTimeBetweenErrorEvents() {
			return this.timeBetweenErrorEvents;
		}
	}

	private ContextProperties context = new ContextProperties();

	public ContextProperties getContext() {
		return this.context;
	}

	private final String jobVersion = "3.6";
	private final String jobName = "HistoryETL";
	private final String projectName = "OVIRT_ENGINE_DWH";
	public Integer errorCode = null;
	private String currentComponent = "";

	private final java.util.Map<String, Object> globalMap = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Object>());

	private final java.util.Map<String, Long> start_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Long> end_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Long>());
	private final java.util.Map<String, Boolean> ok_Hash = java.util.Collections
			.synchronizedMap(new java.util.HashMap<String, Boolean>());
	public final java.util.List<String[]> globalBuffer = java.util.Collections
			.synchronizedList(new java.util.ArrayList<String[]>());

	public boolean isExportedAsOSGI = false;

	// OSGi DataSource
	private final static String KEY_DB_DATASOURCES = "KEY_DB_DATASOURCES";

	public void setDataSources(
			java.util.Map<String, javax.sql.DataSource> dataSources) {
		java.util.Map<String, routines.system.TalendDataSource> talendDataSources = new java.util.HashMap<String, routines.system.TalendDataSource>();
		for (java.util.Map.Entry<String, javax.sql.DataSource> dataSourceEntry : dataSources
				.entrySet()) {
			talendDataSources.put(
					dataSourceEntry.getKey(),
					new routines.system.TalendDataSource(dataSourceEntry
							.getValue()));
		}
		globalMap.put(KEY_DB_DATASOURCES, talendDataSources);
	}

	LogCatcherUtils tLogCatcher_1 = new LogCatcherUtils();
	LogCatcherUtils talendLogs_LOGS = new LogCatcherUtils();

	private final java.io.ByteArrayOutputStream baos = new java.io.ByteArrayOutputStream();
	private final java.io.PrintStream errorMessagePS = new java.io.PrintStream(
			new java.io.BufferedOutputStream(baos));

	public String getExceptionStackTrace() {
		if ("failure".equals(this.getStatus())) {
			errorMessagePS.flush();
			return baos.toString();
		}
		return null;
	}

	private java.lang.Exception exception = null;

	public java.lang.Exception getException() {
		if ("failure".equals(this.getStatus())) {
			return this.exception;
		}
		return null;
	}

	private class TalendException extends java.lang.Exception {

		private static final long serialVersionUID = 1L;

		private java.util.Map<String, Object> globalMap = null;
		private java.lang.Exception e = null;
		private String currentComponent = null;
		private String virtualComponentName = null;

		public void setVirtualComponentName(String virtualComponentName) {
			this.virtualComponentName = virtualComponentName;
		}

		private TalendException(java.lang.Exception e, String errorComponent,
				final java.util.Map<String, Object> globalMap) {
			this.currentComponent = errorComponent;
			this.globalMap = globalMap;
			this.e = e;
		}

		public java.lang.Exception getException() {
			return this.e;
		}

		public String getCurrentComponent() {
			return this.currentComponent;
		}

		public String getExceptionCauseMessage(java.lang.Exception e) {
			Throwable cause = e;
			String message = null;
			int i = 10;
			while (null != cause && 0 < i--) {
				message = cause.getMessage();
				if (null == message) {
					cause = cause.getCause();
				} else {
					break;
				}
			}
			if (null == message) {
				message = e.getClass().getName();
			}
			return message;
		}

		@Override
		public void printStackTrace() {
			if (!(e instanceof TalendException || e instanceof TDieException)) {
				if (virtualComponentName != null
						&& currentComponent.indexOf(virtualComponentName + "_") == 0) {
					globalMap.put(virtualComponentName + "_ERROR_MESSAGE",
							getExceptionCauseMessage(e));
				}
				globalMap.put(currentComponent + "_ERROR_MESSAGE",
						getExceptionCauseMessage(e));
				System.err
						.println("Exception in component " + currentComponent);
			}
			if (!(e instanceof TDieException)) {
				if (e instanceof TalendException) {
					e.printStackTrace();
				} else {
					e.printStackTrace();
					e.printStackTrace(errorMessagePS);
					HistoryETL.this.exception = e;
				}
			}
			if (!(e instanceof TalendException)) {
				try {
					for (java.lang.reflect.Method m : this.getClass()
							.getEnclosingClass().getMethods()) {
						if (m.getName().compareTo(currentComponent + "_error") == 0) {
							m.invoke(HistoryETL.this, new Object[] { e,
									currentComponent, globalMap });
							break;
						}
					}

					if (!(e instanceof TDieException)) {
						tLogCatcher_1.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						talendLogs_LOGS.addMessage("Java Exception",
								currentComponent, 6, e.getClass().getName()
										+ ":" + e.getMessage(), 1);
						try {
							tLogCatcher_1Process(globalMap);
						} finally {
							talendLogs_LOGSProcess(globalMap);
						}
					}
				} catch (java.lang.SecurityException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalArgumentException e) {
					this.e.printStackTrace();
				} catch (java.lang.IllegalAccessException e) {
					this.e.printStackTrace();
				} catch (java.lang.reflect.InvocationTargetException e) {
					this.e.printStackTrace();
				} catch (TalendException e) {
					// do nothing
				}

			}
		}
	}

	public void tRunJob_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRunJob_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPostjob_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPostjob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCRollback_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCRollback_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCRollback_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCRollback_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCRollback_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCRollback_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCRollback_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCRollback_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCRollback_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCRollback_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRowGenerator_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tLogRow_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRowGenerator_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRowGenerator_8_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_8_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCClose_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCClose_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCClose_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCClose_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tPrejob_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tPrejob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tLibraryLoad_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLibraryLoad_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRowGenerator_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tLogRow_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tFileInputProperties_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tFileInputProperties_1_onSubJobError(exception, errorComponent,
				globalMap);
	}

	public void tContextLoad_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tFileInputProperties_1_onSubJobError(exception, errorComponent,
				globalMap);
	}

	public void tJDBCConnection_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRowGenerator_6_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_6_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRowGenerator_7_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRowGenerator_7_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_5_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJDBCConnection_5_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRunJob_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRunJob_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tLogCatcher_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLogCatcher_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tMap_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLogCatcher_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCOutput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLogCatcher_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJava_4_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJava_4_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tLoop_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLoop_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJava_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJava_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRunJob_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tRunJob_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tSetGlobalVar_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tSetGlobalVar_1_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tLoop_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLoop_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJavaFlex_2_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLoop_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCConnection_7_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLoop_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJavaFlex_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLoop_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJDBCInput_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLoop_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJavaRow_1_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tLoop_2_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tJava_3_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		tJava_3_onSubJobError(exception, errorComponent, globalMap);
	}

	public void talendLogs_LOGS_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		talendLogs_CONSOLE_error(exception, errorComponent, globalMap);

	}

	public void talendLogs_CONSOLE_error(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		end_Hash.put(errorComponent, System.currentTimeMillis());

		((java.util.Map) threadLocal.get()).put("status", "failure");

		talendLogs_LOGS_onSubJobError(exception, errorComponent, globalMap);
	}

	public void tRunJob_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPostjob_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCRollback_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCRollback_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCRollback_3_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCRollback_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCRollback_5_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRowGenerator_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRowGenerator_5_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRowGenerator_8_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCClose_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCClose_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tPrejob_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tLibraryLoad_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRowGenerator_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tFileInputProperties_1_onSubJobError(
			java.lang.Exception exception, String errorComponent,
			final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_6_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRowGenerator_6_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRowGenerator_7_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_3_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJDBCConnection_5_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRunJob_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tLogCatcher_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJava_4_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tLoop_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJava_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRunJob_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tSetGlobalVar_1_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tLoop_2_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tJava_3_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void talendLogs_LOGS_onSubJobError(java.lang.Exception exception,
			String errorComponent, final java.util.Map<String, Object> globalMap)
			throws TalendException {

		resumeUtil.addLog("SYSTEM_LOG", "NODE:" + errorComponent, "", Thread
				.currentThread().getId() + "", "FATAL", "",
				exception.getMessage(),
				ResumeUtil.getExceptionStackTrace(exception), "");

	}

	public void tRunJob_4Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRunJob_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tRunJob_4 begin ] start
				 */

				ok_Hash.put("tRunJob_4", false);
				start_Hash.put("tRunJob_4", System.currentTimeMillis());

				currentComponent = "tRunJob_4";

				int tos_count_tRunJob_4 = 0;

				/**
				 * [tRunJob_4 begin ] stop
				 */

				/**
				 * [tRunJob_4 main ] start
				 */

				currentComponent = "tRunJob_4";

				java.util.List<String> paraList_tRunJob_4 = new java.util.ArrayList<String>();

				paraList_tRunJob_4.add("--father_pid=" + pid);

				paraList_tRunJob_4.add("--root_pid=" + rootPid);

				paraList_tRunJob_4.add("--father_node=tRunJob_4");

				paraList_tRunJob_4.add("--context=Default");

				// for feature:10589

				paraList_tRunJob_4.add("--stat_port=" + portStats);

				if (resuming_logs_dir_path != null) {
					paraList_tRunJob_4.add("--resuming_logs_dir_path="
							+ resuming_logs_dir_path);
				}
				String childResumePath_tRunJob_4 = ResumeUtil
						.getChildJobCheckPointPath(resuming_checkpoint_path);
				String tRunJobName_tRunJob_4 = ResumeUtil
						.getRighttRunJob(resuming_checkpoint_path);
				if ("tRunJob_4".equals(tRunJobName_tRunJob_4)
						&& childResumePath_tRunJob_4 != null) {
					paraList_tRunJob_4
							.add("--resuming_checkpoint_path="
									+ ResumeUtil
											.getChildJobCheckPointPath(resuming_checkpoint_path));
				}
				paraList_tRunJob_4.add("--parent_part_launcher=JOB:" + jobName
						+ "/NODE:tRunJob_4");

				java.util.Map<String, Object> parentContextMap_tRunJob_4 = new java.util.HashMap<String, Object>();

				context.synchronizeContext();
				java.util.Enumeration<?> propertyNames_tRunJob_4 = context
						.propertyNames();
				while (propertyNames_tRunJob_4.hasMoreElements()) {
					String key_tRunJob_4 = (String) propertyNames_tRunJob_4
							.nextElement();
					Object value_tRunJob_4 = (Object) context
							.get(key_tRunJob_4);
					paraList_tRunJob_4.add("--context_param " + key_tRunJob_4
							+ "=" + value_tRunJob_4);
				}

				parentContextMap_tRunJob_4.put("dwhUuid", context.dwhUuid);

				parentContextMap_tRunJob_4
						.put("etlVersion", context.etlVersion);

				parentContextMap_tRunJob_4.put("hoursToKeepDaily",
						context.hoursToKeepDaily);

				parentContextMap_tRunJob_4.put("hoursToKeepHourly",
						context.hoursToKeepHourly);

				parentContextMap_tRunJob_4.put("hoursToKeepSamples",
						context.hoursToKeepSamples);

				parentContextMap_tRunJob_4.put("lastErrorSent",
						context.lastErrorSent);

				parentContextMap_tRunJob_4.put("ovirtEngineDbDriverClass",
						context.ovirtEngineDbDriverClass);

				parentContextMap_tRunJob_4.put("ovirtEngineDbJdbcConnection",
						context.ovirtEngineDbJdbcConnection);

				parentContextMap_tRunJob_4.put("ovirtEngineDbPassword",
						context.ovirtEngineDbPassword);

				parentContextMap_tRunJob_4.put("ovirtEngineDbUser",
						context.ovirtEngineDbUser);

				parentContextMap_tRunJob_4.put(
						"ovirtEngineHistoryDbDriverClass",
						context.ovirtEngineHistoryDbDriverClass);

				parentContextMap_tRunJob_4.put(
						"ovirtEngineHistoryDbJdbcConnection",
						context.ovirtEngineHistoryDbJdbcConnection);

				parentContextMap_tRunJob_4.put("ovirtEngineHistoryDbPassword",
						context.ovirtEngineHistoryDbPassword);

				parentContextMap_tRunJob_4.put("ovirtEngineHistoryDbUser",
						context.ovirtEngineHistoryDbUser);

				parentContextMap_tRunJob_4.put("runDeleteTime",
						context.runDeleteTime);

				parentContextMap_tRunJob_4.put("runInterleave",
						context.runInterleave);

				parentContextMap_tRunJob_4.put("timeBetweenErrorEvents",
						context.timeBetweenErrorEvents);

				Object obj_tRunJob_4 = null;

				ovirt_engine_dwh.parallelrun_3_6.ParallelRun childJob_tRunJob_4 = new ovirt_engine_dwh.parallelrun_3_6.ParallelRun();
				// pass DataSources
				java.util.Map<String, routines.system.TalendDataSource> talendDataSources_tRunJob_4 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
						.get(KEY_DB_DATASOURCES);
				if (null != talendDataSources_tRunJob_4) {
					java.util.Map<String, javax.sql.DataSource> dataSources_tRunJob_4 = new java.util.HashMap<String, javax.sql.DataSource>();
					for (java.util.Map.Entry<String, routines.system.TalendDataSource> talendDataSourceEntry_tRunJob_4 : talendDataSources_tRunJob_4
							.entrySet()) {
						dataSources_tRunJob_4.put(
								talendDataSourceEntry_tRunJob_4.getKey(),
								talendDataSourceEntry_tRunJob_4.getValue()
										.getRawDataSource());
					}
					childJob_tRunJob_4.setDataSources(dataSources_tRunJob_4);
				}

				childJob_tRunJob_4.parentContextMap = parentContextMap_tRunJob_4;

				String[][] childReturn_tRunJob_4 = childJob_tRunJob_4
						.runJob((String[]) paraList_tRunJob_4
								.toArray(new String[paraList_tRunJob_4.size()]));

				((java.util.Map) threadLocal.get()).put("errorCode",
						childJob_tRunJob_4.getErrorCode());

				if (childJob_tRunJob_4.getErrorCode() == null) {
					globalMap.put(
							"tRunJob_4_CHILD_RETURN_CODE",
							childJob_tRunJob_4.getStatus() != null
									&& ("failure").equals(childJob_tRunJob_4
											.getStatus()) ? 1 : 0);
				} else {
					globalMap.put("tRunJob_4_CHILD_RETURN_CODE",
							childJob_tRunJob_4.getErrorCode());
				}
				if (childJob_tRunJob_4.getExceptionStackTrace() != null) {
					globalMap.put("tRunJob_4_CHILD_EXCEPTION_STACKTRACE",
							childJob_tRunJob_4.getExceptionStackTrace());
				}

				if (childJob_tRunJob_4.getErrorCode() != null
						|| ("failure").equals(childJob_tRunJob_4.getStatus())) {
					throw new RuntimeException("Child job running failed");
				}

				tos_count_tRunJob_4++;

				/**
				 * [tRunJob_4 main ] stop
				 */

				/**
				 * [tRunJob_4 end ] start
				 */

				currentComponent = "tRunJob_4";

				ok_Hash.put("tRunJob_4", true);
				end_Hash.put("tRunJob_4", System.currentTimeMillis());

				/**
				 * [tRunJob_4 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRunJob_4 finally ] start
				 */

				currentComponent = "tRunJob_4";

				/**
				 * [tRunJob_4 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRunJob_4_SUBPROCESS_STATE", 1);
	}

	public void tPostjob_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tPostjob_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tPostjob_1 begin ] start
				 */

				ok_Hash.put("tPostjob_1", false);
				start_Hash.put("tPostjob_1", System.currentTimeMillis());

				currentComponent = "tPostjob_1";

				int tos_count_tPostjob_1 = 0;

				/**
				 * [tPostjob_1 begin ] stop
				 */

				/**
				 * [tPostjob_1 main ] start
				 */

				currentComponent = "tPostjob_1";

				tos_count_tPostjob_1++;

				/**
				 * [tPostjob_1 main ] stop
				 */

				/**
				 * [tPostjob_1 end ] start
				 */

				currentComponent = "tPostjob_1";

				ok_Hash.put("tPostjob_1", true);
				end_Hash.put("tPostjob_1", System.currentTimeMillis());

				tJDBCRollback_1Process(globalMap);

				/**
				 * [tPostjob_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tPostjob_1 finally ] start
				 */

				currentComponent = "tPostjob_1";

				/**
				 * [tPostjob_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tPostjob_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCRollback_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCRollback_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCRollback_1 begin ] start
				 */

				ok_Hash.put("tJDBCRollback_1", false);
				start_Hash.put("tJDBCRollback_1", System.currentTimeMillis());

				currentComponent = "tJDBCRollback_1";

				int tos_count_tJDBCRollback_1 = 0;

				/**
				 * [tJDBCRollback_1 begin ] stop
				 */

				/**
				 * [tJDBCRollback_1 main ] start
				 */

				currentComponent = "tJDBCRollback_1";

				java.sql.Connection conn_tJDBCRollback_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_2");
				if (conn_tJDBCRollback_1 != null
						&& !conn_tJDBCRollback_1.isClosed()) {

					try {

						conn_tJDBCRollback_1.rollback();

					} finally {

						conn_tJDBCRollback_1.close();

					}

				}

				tos_count_tJDBCRollback_1++;

				/**
				 * [tJDBCRollback_1 main ] stop
				 */

				/**
				 * [tJDBCRollback_1 end ] start
				 */

				currentComponent = "tJDBCRollback_1";

				ok_Hash.put("tJDBCRollback_1", true);
				end_Hash.put("tJDBCRollback_1", System.currentTimeMillis());

				/**
				 * [tJDBCRollback_1 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCRollback_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCRollback_2Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCRollback_1 finally ] start
				 */

				currentComponent = "tJDBCRollback_1";

				/**
				 * [tJDBCRollback_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCRollback_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCRollback_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCRollback_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCRollback_2 begin ] start
				 */

				ok_Hash.put("tJDBCRollback_2", false);
				start_Hash.put("tJDBCRollback_2", System.currentTimeMillis());

				currentComponent = "tJDBCRollback_2";

				int tos_count_tJDBCRollback_2 = 0;

				/**
				 * [tJDBCRollback_2 begin ] stop
				 */

				/**
				 * [tJDBCRollback_2 main ] start
				 */

				currentComponent = "tJDBCRollback_2";

				java.sql.Connection conn_tJDBCRollback_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_1");
				if (conn_tJDBCRollback_2 != null
						&& !conn_tJDBCRollback_2.isClosed()) {

					try {

						conn_tJDBCRollback_2.rollback();

					} finally {

						conn_tJDBCRollback_2.close();

					}

				}

				tos_count_tJDBCRollback_2++;

				/**
				 * [tJDBCRollback_2 main ] stop
				 */

				/**
				 * [tJDBCRollback_2 end ] start
				 */

				currentComponent = "tJDBCRollback_2";

				ok_Hash.put("tJDBCRollback_2", true);
				end_Hash.put("tJDBCRollback_2", System.currentTimeMillis());

				/**
				 * [tJDBCRollback_2 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCRollback_2:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCRollback_3Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCRollback_2 finally ] start
				 */

				currentComponent = "tJDBCRollback_2";

				/**
				 * [tJDBCRollback_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCRollback_2_SUBPROCESS_STATE", 1);
	}

	public void tJDBCRollback_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCRollback_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCRollback_3 begin ] start
				 */

				ok_Hash.put("tJDBCRollback_3", false);
				start_Hash.put("tJDBCRollback_3", System.currentTimeMillis());

				currentComponent = "tJDBCRollback_3";

				int tos_count_tJDBCRollback_3 = 0;

				/**
				 * [tJDBCRollback_3 begin ] stop
				 */

				/**
				 * [tJDBCRollback_3 main ] start
				 */

				currentComponent = "tJDBCRollback_3";

				java.sql.Connection conn_tJDBCRollback_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_3");
				if (conn_tJDBCRollback_3 != null
						&& !conn_tJDBCRollback_3.isClosed()) {

					try {

						conn_tJDBCRollback_3.rollback();

					} finally {

						conn_tJDBCRollback_3.close();

					}

				}

				tos_count_tJDBCRollback_3++;

				/**
				 * [tJDBCRollback_3 main ] stop
				 */

				/**
				 * [tJDBCRollback_3 end ] start
				 */

				currentComponent = "tJDBCRollback_3";

				ok_Hash.put("tJDBCRollback_3", true);
				end_Hash.put("tJDBCRollback_3", System.currentTimeMillis());

				/**
				 * [tJDBCRollback_3 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCRollback_3:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCRollback_4Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCRollback_3 finally ] start
				 */

				currentComponent = "tJDBCRollback_3";

				/**
				 * [tJDBCRollback_3 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCRollback_3_SUBPROCESS_STATE", 1);
	}

	public void tJDBCRollback_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCRollback_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCRollback_4 begin ] start
				 */

				ok_Hash.put("tJDBCRollback_4", false);
				start_Hash.put("tJDBCRollback_4", System.currentTimeMillis());

				currentComponent = "tJDBCRollback_4";

				int tos_count_tJDBCRollback_4 = 0;

				/**
				 * [tJDBCRollback_4 begin ] stop
				 */

				/**
				 * [tJDBCRollback_4 main ] start
				 */

				currentComponent = "tJDBCRollback_4";

				java.sql.Connection conn_tJDBCRollback_4 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_4");
				if (conn_tJDBCRollback_4 != null
						&& !conn_tJDBCRollback_4.isClosed()) {

					try {

						conn_tJDBCRollback_4.rollback();

					} finally {

						conn_tJDBCRollback_4.close();

					}

				}

				tos_count_tJDBCRollback_4++;

				/**
				 * [tJDBCRollback_4 main ] stop
				 */

				/**
				 * [tJDBCRollback_4 end ] start
				 */

				currentComponent = "tJDBCRollback_4";

				ok_Hash.put("tJDBCRollback_4", true);
				end_Hash.put("tJDBCRollback_4", System.currentTimeMillis());

				/**
				 * [tJDBCRollback_4 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCRollback_4:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCRollback_5Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCRollback_4 finally ] start
				 */

				currentComponent = "tJDBCRollback_4";

				/**
				 * [tJDBCRollback_4 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCRollback_4_SUBPROCESS_STATE", 1);
	}

	public void tJDBCRollback_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCRollback_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCRollback_5 begin ] start
				 */

				ok_Hash.put("tJDBCRollback_5", false);
				start_Hash.put("tJDBCRollback_5", System.currentTimeMillis());

				currentComponent = "tJDBCRollback_5";

				int tos_count_tJDBCRollback_5 = 0;

				/**
				 * [tJDBCRollback_5 begin ] stop
				 */

				/**
				 * [tJDBCRollback_5 main ] start
				 */

				currentComponent = "tJDBCRollback_5";

				java.sql.Connection conn_tJDBCRollback_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_5");
				if (conn_tJDBCRollback_5 != null
						&& !conn_tJDBCRollback_5.isClosed()) {

					try {

						conn_tJDBCRollback_5.rollback();

					} finally {

						conn_tJDBCRollback_5.close();

					}

				}

				tos_count_tJDBCRollback_5++;

				/**
				 * [tJDBCRollback_5 main ] stop
				 */

				/**
				 * [tJDBCRollback_5 end ] start
				 */

				currentComponent = "tJDBCRollback_5";

				ok_Hash.put("tJDBCRollback_5", true);
				end_Hash.put("tJDBCRollback_5", System.currentTimeMillis());

				/**
				 * [tJDBCRollback_5 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCRollback_5:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tRowGenerator_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCRollback_5 finally ] start
				 */

				currentComponent = "tJDBCRollback_5";

				/**
				 * [tJDBCRollback_5 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCRollback_5_SUBPROCESS_STATE", 1);
	}

	public static class row6Struct implements
			routines.system.IPersistableRow<row6Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public String time;

		public String getTime() {
			return this.time;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.time = readString(dis);

					this.message = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.time, dos);

				// String

				writeString(this.message, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("time=" + time);
			sb.append(",message=" + message);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row6Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tRowGenerator_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRowGenerator_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row6Struct row6 = new row6Struct();

				/**
				 * [tLogRow_1 begin ] start
				 */

				ok_Hash.put("tLogRow_1", false);
				start_Hash.put("tLogRow_1", System.currentTimeMillis());

				currentComponent = "tLogRow_1";

				int tos_count_tLogRow_1 = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_tLogRow_1 = "|";
				java.io.PrintStream consoleOut_tLogRow_1 = null;

				StringBuilder strBuffer_tLogRow_1 = null;
				int nb_line_tLogRow_1 = 0;
				// /////////////////////

				/**
				 * [tLogRow_1 begin ] stop
				 */

				/**
				 * [tRowGenerator_1 begin ] start
				 */

				ok_Hash.put("tRowGenerator_1", false);
				start_Hash.put("tRowGenerator_1", System.currentTimeMillis());

				currentComponent = "tRowGenerator_1";

				int tos_count_tRowGenerator_1 = 0;

				int nb_line_tRowGenerator_1 = 0;
				int nb_max_row_tRowGenerator_1 = 1;

				class tRowGenerator_1Randomizer {
					public String getRandomtime() {

						return TalendDate.getDate("CCYY-MM-DD hh:mm:ss");

					}

					public String getRandommessage() {

						return "ETL Service Stopped";

					}
				}
				tRowGenerator_1Randomizer randtRowGenerator_1 = new tRowGenerator_1Randomizer();

				for (int itRowGenerator_1 = 0; itRowGenerator_1 < nb_max_row_tRowGenerator_1; itRowGenerator_1++) {
					row6.time = randtRowGenerator_1.getRandomtime();
					row6.message = randtRowGenerator_1.getRandommessage();
					nb_line_tRowGenerator_1++;

					/**
					 * [tRowGenerator_1 begin ] stop
					 */

					/**
					 * [tRowGenerator_1 main ] start
					 */

					currentComponent = "tRowGenerator_1";

					tos_count_tRowGenerator_1++;

					/**
					 * [tRowGenerator_1 main ] stop
					 */

					/**
					 * [tLogRow_1 main ] start
					 */

					currentComponent = "tLogRow_1";

					// /////////////////////

					strBuffer_tLogRow_1 = new StringBuilder();

					if (row6.time != null) { //

						strBuffer_tLogRow_1.append(String.valueOf(row6.time));

					} //

					strBuffer_tLogRow_1.append("|");

					if (row6.message != null) { //

						strBuffer_tLogRow_1
								.append(String.valueOf(row6.message));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_tLogRow_1 = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_tLogRow_1 = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE", consoleOut_tLogRow_1);
					}

					consoleOut_tLogRow_1
							.println(strBuffer_tLogRow_1.toString());
					consoleOut_tLogRow_1.flush();
					nb_line_tLogRow_1++;
					// ////

					// ////

					// /////////////////////

					tos_count_tLogRow_1++;

					/**
					 * [tLogRow_1 main ] stop
					 */

					/**
					 * [tRowGenerator_1 end ] start
					 */

					currentComponent = "tRowGenerator_1";

				}
				globalMap.put("tRowGenerator_1_NB_LINE",
						nb_line_tRowGenerator_1);

				ok_Hash.put("tRowGenerator_1", true);
				end_Hash.put("tRowGenerator_1", System.currentTimeMillis());

				/**
				 * [tRowGenerator_1 end ] stop
				 */

				/**
				 * [tLogRow_1 end ] start
				 */

				currentComponent = "tLogRow_1";

				// ////
				// ////
				globalMap.put("tLogRow_1_NB_LINE", nb_line_tLogRow_1);

				// /////////////////////

				ok_Hash.put("tLogRow_1", true);
				end_Hash.put("tLogRow_1", System.currentTimeMillis());

				/**
				 * [tLogRow_1 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tRowGenerator_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tRowGenerator_5Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRowGenerator_1 finally ] start
				 */

				currentComponent = "tRowGenerator_1";

				/**
				 * [tRowGenerator_1 finally ] stop
				 */

				/**
				 * [tLogRow_1 finally ] start
				 */

				currentComponent = "tLogRow_1";

				/**
				 * [tLogRow_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRowGenerator_1_SUBPROCESS_STATE", 1);
	}

	public static class copyOfevent_outputStruct implements
			routines.system.IPersistableRow<copyOfevent_outputStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public java.util.Date log_time;

		public java.util.Date getLog_time() {
			return this.log_time;
		}

		public String log_type_name;

		public String getLog_type_name() {
			return this.log_type_name;
		}

		public int log_type;

		public int getLog_type() {
			return this.log_type;
		}

		public int severity;

		public int getSeverity() {
			return this.severity;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.log_time = readDate(dis);

					this.log_type_name = readString(dis);

					this.log_type = dis.readInt();

					this.severity = dis.readInt();

					this.message = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.log_time, dos);

				// String

				writeString(this.log_type_name, dos);

				// int

				dos.writeInt(this.log_type);

				// int

				dos.writeInt(this.severity);

				// String

				writeString(this.message, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("log_time=" + String.valueOf(log_time));
			sb.append(",log_type_name=" + log_type_name);
			sb.append(",log_type=" + String.valueOf(log_type));
			sb.append(",severity=" + String.valueOf(severity));
			sb.append(",message=" + message);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(copyOfevent_outputStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row2Struct implements
			routines.system.IPersistableRow<row2Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public java.util.Date time;

		public java.util.Date getTime() {
			return this.time;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.time = readDate(dis);

					this.message = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.time, dos);

				// String

				writeString(this.message, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("time=" + String.valueOf(time));
			sb.append(",message=" + message);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row2Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tRowGenerator_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRowGenerator_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row2Struct row2 = new row2Struct();
				copyOfevent_outputStruct copyOfevent_output = new copyOfevent_outputStruct();

				/**
				 * [tJDBCOutput_2 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_2", false);
				start_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_2";

				int tos_count_tJDBCOutput_2 = 0;

				int nb_line_tJDBCOutput_2 = 0;
				int nb_line_update_tJDBCOutput_2 = 0;
				int nb_line_inserted_tJDBCOutput_2 = 0;
				int nb_line_deleted_tJDBCOutput_2 = 0;
				int nb_line_rejected_tJDBCOutput_2 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_2 = 0;

				int deletedCount_tJDBCOutput_2 = 0;
				int updatedCount_tJDBCOutput_2 = 0;
				int insertedCount_tJDBCOutput_2 = 0;
				int rejectedCount_tJDBCOutput_2 = 0;

				boolean whetherReject_tJDBCOutput_2 = false;

				java.sql.Connection connection_tJDBCOutput_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_7");
				int batchSize_tJDBCOutput_2 = 10000;
				int batchSizeCounter_tJDBCOutput_2 = 0;

				String insert_tJDBCOutput_2 = "INSERT INTO "
						+ "audit_log"
						+ " (log_time,log_type_name,log_type,severity,message) VALUES (?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_2 = connection_tJDBCOutput_2
						.prepareStatement(insert_tJDBCOutput_2);

				/**
				 * [tJDBCOutput_2 begin ] stop
				 */

				/**
				 * [tMap_2 begin ] start
				 */

				ok_Hash.put("tMap_2", false);
				start_Hash.put("tMap_2", System.currentTimeMillis());

				currentComponent = "tMap_2";

				int tos_count_tMap_2 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_2__Struct {
				}
				Var__tMap_2__Struct Var__tMap_2 = new Var__tMap_2__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				copyOfevent_outputStruct copyOfevent_output_tmp = new copyOfevent_outputStruct();
				// ###############################

				/**
				 * [tMap_2 begin ] stop
				 */

				/**
				 * [tRowGenerator_5 begin ] start
				 */

				ok_Hash.put("tRowGenerator_5", false);
				start_Hash.put("tRowGenerator_5", System.currentTimeMillis());

				currentComponent = "tRowGenerator_5";

				int tos_count_tRowGenerator_5 = 0;

				int nb_line_tRowGenerator_5 = 0;
				int nb_max_row_tRowGenerator_5 = 1;

				class tRowGenerator_5Randomizer {
					public java.util.Date getRandomtime() {

						return TalendDate.getCurrentDate();

					}

					public String getRandommessage() {

						return "ETL Service Stopped";

					}
				}
				tRowGenerator_5Randomizer randtRowGenerator_5 = new tRowGenerator_5Randomizer();

				for (int itRowGenerator_5 = 0; itRowGenerator_5 < nb_max_row_tRowGenerator_5; itRowGenerator_5++) {
					row2.time = randtRowGenerator_5.getRandomtime();
					row2.message = randtRowGenerator_5.getRandommessage();
					nb_line_tRowGenerator_5++;

					/**
					 * [tRowGenerator_5 begin ] stop
					 */

					/**
					 * [tRowGenerator_5 main ] start
					 */

					currentComponent = "tRowGenerator_5";

					tos_count_tRowGenerator_5++;

					/**
					 * [tRowGenerator_5 main ] stop
					 */

					/**
					 * [tMap_2 main ] start
					 */

					currentComponent = "tMap_2";

					boolean hasCasePrimitiveKeyWithNull_tMap_2 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_2 = false;
					boolean mainRowRejected_tMap_2 = false;

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_2__Struct Var = Var__tMap_2;// ###############################
						// ###############################
						// # Output tables

						copyOfevent_output = null;

						// # Output table : 'copyOfevent_output'
						copyOfevent_output_tmp.log_time = row2.time;
						copyOfevent_output_tmp.log_type_name = "DWH_STOPPED";
						copyOfevent_output_tmp.log_type = 9701;
						copyOfevent_output_tmp.severity = 0;
						copyOfevent_output_tmp.message = row2.message;
						copyOfevent_output = copyOfevent_output_tmp;
						// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_2 = false;

					tos_count_tMap_2++;

					/**
					 * [tMap_2 main ] stop
					 */
					// Start of branch "copyOfevent_output"
					if (copyOfevent_output != null) {

						/**
						 * [tJDBCOutput_2 main ] start
						 */

						currentComponent = "tJDBCOutput_2";

						whetherReject_tJDBCOutput_2 = false;
						if (copyOfevent_output.log_time != null) {
							pstmt_tJDBCOutput_2.setTimestamp(
									1,
									new java.sql.Timestamp(
											copyOfevent_output.log_time
													.getTime()));
						} else {
							pstmt_tJDBCOutput_2.setNull(1, java.sql.Types.DATE);
						}

						if (copyOfevent_output.log_type_name == null) {
							pstmt_tJDBCOutput_2.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_2.setString(2,
									copyOfevent_output.log_type_name);
						}

						pstmt_tJDBCOutput_2.setInt(3,
								copyOfevent_output.log_type);

						pstmt_tJDBCOutput_2.setInt(4,
								copyOfevent_output.severity);

						if (copyOfevent_output.message == null) {
							pstmt_tJDBCOutput_2.setNull(5,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_2.setString(5,
									copyOfevent_output.message);
						}

						try {
							insertedCount_tJDBCOutput_2 = insertedCount_tJDBCOutput_2
									+ pstmt_tJDBCOutput_2.executeUpdate();
							nb_line_tJDBCOutput_2++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_2 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_2++;

						/**
						 * [tJDBCOutput_2 main ] stop
						 */

					} // End of branch "copyOfevent_output"

					/**
					 * [tRowGenerator_5 end ] start
					 */

					currentComponent = "tRowGenerator_5";

				}
				globalMap.put("tRowGenerator_5_NB_LINE",
						nb_line_tRowGenerator_5);

				ok_Hash.put("tRowGenerator_5", true);
				end_Hash.put("tRowGenerator_5", System.currentTimeMillis());

				/**
				 * [tRowGenerator_5 end ] stop
				 */

				/**
				 * [tMap_2 end ] start
				 */

				currentComponent = "tMap_2";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_2", true);
				end_Hash.put("tMap_2", System.currentTimeMillis());

				/**
				 * [tMap_2 end ] stop
				 */

				/**
				 * [tJDBCOutput_2 end ] start
				 */

				currentComponent = "tJDBCOutput_2";

				if (pstmt_tJDBCOutput_2 != null) {

					pstmt_tJDBCOutput_2.close();

				}

				nb_line_deleted_tJDBCOutput_2 = nb_line_deleted_tJDBCOutput_2
						+ deletedCount_tJDBCOutput_2;
				nb_line_update_tJDBCOutput_2 = nb_line_update_tJDBCOutput_2
						+ updatedCount_tJDBCOutput_2;
				nb_line_inserted_tJDBCOutput_2 = nb_line_inserted_tJDBCOutput_2
						+ insertedCount_tJDBCOutput_2;
				nb_line_rejected_tJDBCOutput_2 = nb_line_rejected_tJDBCOutput_2
						+ rejectedCount_tJDBCOutput_2;

				globalMap.put("tJDBCOutput_2_NB_LINE", nb_line_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_2);
				globalMap.put("tJDBCOutput_2_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_2);

				ok_Hash.put("tJDBCOutput_2", true);
				end_Hash.put("tJDBCOutput_2", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_2 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tRowGenerator_5:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tRowGenerator_8Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRowGenerator_5 finally ] start
				 */

				currentComponent = "tRowGenerator_5";

				/**
				 * [tRowGenerator_5 finally ] stop
				 */

				/**
				 * [tMap_2 finally ] start
				 */

				currentComponent = "tMap_2";

				/**
				 * [tMap_2 finally ] stop
				 */

				/**
				 * [tJDBCOutput_2 finally ] start
				 */

				currentComponent = "tJDBCOutput_2";

				/**
				 * [tJDBCOutput_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRowGenerator_5_SUBPROCESS_STATE", 1);
	}

	public static class row8Struct implements
			routines.system.IPersistableRow<row8Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public String var_name;

		public String getVar_name() {
			return this.var_name;
		}

		public String var_value;

		public String getVar_value() {
			return this.var_value;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.var_name == null) ? 0 : this.var_name
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row8Struct other = (row8Struct) obj;

			if (this.var_name == null) {
				if (other.var_name != null)
					return false;

			} else if (!this.var_name.equals(other.var_name))

				return false;

			return true;
		}

		public void copyDataTo(row8Struct other) {

			other.var_name = this.var_name;
			other.var_value = this.var_value;

		}

		public void copyKeysDataTo(row8Struct other) {

			other.var_name = this.var_name;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.var_name = readString(dis);

					this.var_value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.var_name, dos);

				// String

				writeString(this.var_value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("var_name=" + var_name);
			sb.append(",var_value=" + var_value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row8Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.var_name, other.var_name);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tRowGenerator_8Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRowGenerator_8_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row8Struct row8 = new row8Struct();

				/**
				 * [tJDBCOutput_6 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_6", false);
				start_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_6";

				int tos_count_tJDBCOutput_6 = 0;

				int updateKeyCount_tJDBCOutput_6 = 1;
				if (updateKeyCount_tJDBCOutput_6 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_6 = 0;
				int nb_line_update_tJDBCOutput_6 = 0;
				int nb_line_inserted_tJDBCOutput_6 = 0;
				int nb_line_deleted_tJDBCOutput_6 = 0;
				int nb_line_rejected_tJDBCOutput_6 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_6 = 0;

				int deletedCount_tJDBCOutput_6 = 0;
				int updatedCount_tJDBCOutput_6 = 0;
				int insertedCount_tJDBCOutput_6 = 0;
				int rejectedCount_tJDBCOutput_6 = 0;

				boolean whetherReject_tJDBCOutput_6 = false;

				java.sql.Connection connection_tJDBCOutput_6 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_7");
				int batchSize_tJDBCOutput_6 = 10000;
				int batchSizeCounter_tJDBCOutput_6 = 0;

				String update_tJDBCOutput_6 = "UPDATE "
						+ "dwh_history_timekeeping"
						+ " SET var_value = ? WHERE var_name = ?";
				java.sql.PreparedStatement pstmtUpdate_tJDBCOutput_6 = connection_tJDBCOutput_6
						.prepareStatement(update_tJDBCOutput_6);
				String insert_tJDBCOutput_6 = "INSERT INTO "
						+ "dwh_history_timekeeping"
						+ " (var_name,var_value) VALUES (?,?)";
				java.sql.PreparedStatement pstmtInsert_tJDBCOutput_6 = connection_tJDBCOutput_6
						.prepareStatement(insert_tJDBCOutput_6);

				/**
				 * [tJDBCOutput_6 begin ] stop
				 */

				/**
				 * [tRowGenerator_8 begin ] start
				 */

				ok_Hash.put("tRowGenerator_8", false);
				start_Hash.put("tRowGenerator_8", System.currentTimeMillis());

				currentComponent = "tRowGenerator_8";

				int tos_count_tRowGenerator_8 = 0;

				int nb_line_tRowGenerator_8 = 0;
				int nb_max_row_tRowGenerator_8 = 1;

				class tRowGenerator_8Randomizer {
					public String getRandomvar_name() {

						return "DwhCurrentlyRunning";

					}

					public String getRandomvar_value() {

						return "0";

					}
				}
				tRowGenerator_8Randomizer randtRowGenerator_8 = new tRowGenerator_8Randomizer();

				for (int itRowGenerator_8 = 0; itRowGenerator_8 < nb_max_row_tRowGenerator_8; itRowGenerator_8++) {
					row8.var_name = randtRowGenerator_8.getRandomvar_name();
					row8.var_value = randtRowGenerator_8.getRandomvar_value();
					nb_line_tRowGenerator_8++;

					/**
					 * [tRowGenerator_8 begin ] stop
					 */

					/**
					 * [tRowGenerator_8 main ] start
					 */

					currentComponent = "tRowGenerator_8";

					tos_count_tRowGenerator_8++;

					/**
					 * [tRowGenerator_8 main ] stop
					 */

					/**
					 * [tJDBCOutput_6 main ] start
					 */

					currentComponent = "tJDBCOutput_6";

					whetherReject_tJDBCOutput_6 = false;
					int updateFlag_tJDBCOutput_6 = 0;
					if (row8.var_value == null) {
						pstmtUpdate_tJDBCOutput_6.setNull(1,
								java.sql.Types.VARCHAR);
					} else {
						pstmtUpdate_tJDBCOutput_6.setString(1, row8.var_value);
					}

					if (row8.var_name == null) {
						pstmtUpdate_tJDBCOutput_6.setNull(2,
								java.sql.Types.VARCHAR);
					} else {
						pstmtUpdate_tJDBCOutput_6.setString(2, row8.var_name);
					}

					try {
						updateFlag_tJDBCOutput_6 = pstmtUpdate_tJDBCOutput_6
								.executeUpdate();
						updatedCount_tJDBCOutput_6 = updatedCount_tJDBCOutput_6
								+ updateFlag_tJDBCOutput_6;
						if (updateFlag_tJDBCOutput_6 == 0) {

							if (row8.var_name == null) {
								pstmtInsert_tJDBCOutput_6.setNull(1,
										java.sql.Types.VARCHAR);
							} else {
								pstmtInsert_tJDBCOutput_6.setString(1,
										row8.var_name);
							}

							if (row8.var_value == null) {
								pstmtInsert_tJDBCOutput_6.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmtInsert_tJDBCOutput_6.setString(2,
										row8.var_value);
							}

							insertedCount_tJDBCOutput_6 = insertedCount_tJDBCOutput_6
									+ pstmtInsert_tJDBCOutput_6.executeUpdate();
							nb_line_tJDBCOutput_6++;
						} else {
							nb_line_tJDBCOutput_6++;

						}
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_6 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_6++;

					/**
					 * [tJDBCOutput_6 main ] stop
					 */

					/**
					 * [tRowGenerator_8 end ] start
					 */

					currentComponent = "tRowGenerator_8";

				}
				globalMap.put("tRowGenerator_8_NB_LINE",
						nb_line_tRowGenerator_8);

				ok_Hash.put("tRowGenerator_8", true);
				end_Hash.put("tRowGenerator_8", System.currentTimeMillis());

				/**
				 * [tRowGenerator_8 end ] stop
				 */

				/**
				 * [tJDBCOutput_6 end ] start
				 */

				currentComponent = "tJDBCOutput_6";

				if (pstmtUpdate_tJDBCOutput_6 != null) {

					pstmtUpdate_tJDBCOutput_6.close();

				}
				if (pstmtInsert_tJDBCOutput_6 != null) {

					pstmtInsert_tJDBCOutput_6.close();

				}

				nb_line_deleted_tJDBCOutput_6 = nb_line_deleted_tJDBCOutput_6
						+ deletedCount_tJDBCOutput_6;
				nb_line_update_tJDBCOutput_6 = nb_line_update_tJDBCOutput_6
						+ updatedCount_tJDBCOutput_6;
				nb_line_inserted_tJDBCOutput_6 = nb_line_inserted_tJDBCOutput_6
						+ insertedCount_tJDBCOutput_6;
				nb_line_rejected_tJDBCOutput_6 = nb_line_rejected_tJDBCOutput_6
						+ rejectedCount_tJDBCOutput_6;

				globalMap.put("tJDBCOutput_6_NB_LINE", nb_line_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_6);
				globalMap.put("tJDBCOutput_6_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_6);

				ok_Hash.put("tJDBCOutput_6", true);
				end_Hash.put("tJDBCOutput_6", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_6 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tRowGenerator_8:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCClose_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRowGenerator_8 finally ] start
				 */

				currentComponent = "tRowGenerator_8";

				/**
				 * [tRowGenerator_8 finally ] stop
				 */

				/**
				 * [tJDBCOutput_6 finally ] start
				 */

				currentComponent = "tJDBCOutput_6";

				/**
				 * [tJDBCOutput_6 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRowGenerator_8_SUBPROCESS_STATE", 1);
	}

	public void tJDBCClose_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCClose_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCClose_1 begin ] start
				 */

				ok_Hash.put("tJDBCClose_1", false);
				start_Hash.put("tJDBCClose_1", System.currentTimeMillis());

				currentComponent = "tJDBCClose_1";

				int tos_count_tJDBCClose_1 = 0;

				/**
				 * [tJDBCClose_1 begin ] stop
				 */

				/**
				 * [tJDBCClose_1 main ] start
				 */

				currentComponent = "tJDBCClose_1";

				java.sql.Connection conn_tJDBCClose_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_6");

				if (conn_tJDBCClose_1 != null && !conn_tJDBCClose_1.isClosed()) {

					conn_tJDBCClose_1.close();

				}

				tos_count_tJDBCClose_1++;

				/**
				 * [tJDBCClose_1 main ] stop
				 */

				/**
				 * [tJDBCClose_1 end ] start
				 */

				currentComponent = "tJDBCClose_1";

				ok_Hash.put("tJDBCClose_1", true);
				end_Hash.put("tJDBCClose_1", System.currentTimeMillis());

				/**
				 * [tJDBCClose_1 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tJDBCClose_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCClose_2Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCClose_1 finally ] start
				 */

				currentComponent = "tJDBCClose_1";

				/**
				 * [tJDBCClose_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCClose_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCClose_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCClose_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCClose_2 begin ] start
				 */

				ok_Hash.put("tJDBCClose_2", false);
				start_Hash.put("tJDBCClose_2", System.currentTimeMillis());

				currentComponent = "tJDBCClose_2";

				int tos_count_tJDBCClose_2 = 0;

				/**
				 * [tJDBCClose_2 begin ] stop
				 */

				/**
				 * [tJDBCClose_2 main ] start
				 */

				currentComponent = "tJDBCClose_2";

				java.sql.Connection conn_tJDBCClose_2 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_7");

				if (conn_tJDBCClose_2 != null && !conn_tJDBCClose_2.isClosed()) {

					conn_tJDBCClose_2.close();

				}

				tos_count_tJDBCClose_2++;

				/**
				 * [tJDBCClose_2 main ] stop
				 */

				/**
				 * [tJDBCClose_2 end ] start
				 */

				currentComponent = "tJDBCClose_2";

				ok_Hash.put("tJDBCClose_2", true);
				end_Hash.put("tJDBCClose_2", System.currentTimeMillis());

				/**
				 * [tJDBCClose_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCClose_2 finally ] start
				 */

				currentComponent = "tJDBCClose_2";

				/**
				 * [tJDBCClose_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCClose_2_SUBPROCESS_STATE", 1);
	}

	public void tPrejob_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tPrejob_1 begin ] start
				 */

				ok_Hash.put("tPrejob_1", false);
				start_Hash.put("tPrejob_1", System.currentTimeMillis());

				currentComponent = "tPrejob_1";

				int tos_count_tPrejob_1 = 0;

				/**
				 * [tPrejob_1 begin ] stop
				 */

				/**
				 * [tPrejob_1 main ] start
				 */

				currentComponent = "tPrejob_1";

				tos_count_tPrejob_1++;

				/**
				 * [tPrejob_1 main ] stop
				 */

				/**
				 * [tPrejob_1 end ] start
				 */

				currentComponent = "tPrejob_1";

				ok_Hash.put("tPrejob_1", true);
				end_Hash.put("tPrejob_1", System.currentTimeMillis());

				tLibraryLoad_1Process(globalMap);

				/**
				 * [tPrejob_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tPrejob_1 finally ] start
				 */

				currentComponent = "tPrejob_1";

				/**
				 * [tPrejob_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tPrejob_1_SUBPROCESS_STATE", 1);
	}

	public void tLibraryLoad_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tLibraryLoad_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tLibraryLoad_1 begin ] start
				 */

				ok_Hash.put("tLibraryLoad_1", false);
				start_Hash.put("tLibraryLoad_1", System.currentTimeMillis());

				currentComponent = "tLibraryLoad_1";

				int tos_count_tLibraryLoad_1 = 0;

				/**
				 * [tLibraryLoad_1 begin ] stop
				 */

				/**
				 * [tLibraryLoad_1 main ] start
				 */

				currentComponent = "tLibraryLoad_1";

				tos_count_tLibraryLoad_1++;

				/**
				 * [tLibraryLoad_1 main ] stop
				 */

				/**
				 * [tLibraryLoad_1 end ] start
				 */

				currentComponent = "tLibraryLoad_1";

				ok_Hash.put("tLibraryLoad_1", true);
				end_Hash.put("tLibraryLoad_1", System.currentTimeMillis());

				/**
				 * [tLibraryLoad_1 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tLibraryLoad_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tRowGenerator_2Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tLibraryLoad_1 finally ] start
				 */

				currentComponent = "tLibraryLoad_1";

				/**
				 * [tLibraryLoad_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tLibraryLoad_1_SUBPROCESS_STATE", 1);
	}

	public static class row3Struct implements
			routines.system.IPersistableRow<row3Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public String time;

		public String getTime() {
			return this.time;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.time = readString(dis);

					this.message = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.time, dos);

				// String

				writeString(this.message, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("time=" + time);
			sb.append(",message=" + message);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row3Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tRowGenerator_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRowGenerator_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row3Struct row3 = new row3Struct();

				/**
				 * [tLogRow_2 begin ] start
				 */

				ok_Hash.put("tLogRow_2", false);
				start_Hash.put("tLogRow_2", System.currentTimeMillis());

				currentComponent = "tLogRow_2";

				int tos_count_tLogRow_2 = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_tLogRow_2 = "|";
				java.io.PrintStream consoleOut_tLogRow_2 = null;

				StringBuilder strBuffer_tLogRow_2 = null;
				int nb_line_tLogRow_2 = 0;
				// /////////////////////

				/**
				 * [tLogRow_2 begin ] stop
				 */

				/**
				 * [tRowGenerator_2 begin ] start
				 */

				ok_Hash.put("tRowGenerator_2", false);
				start_Hash.put("tRowGenerator_2", System.currentTimeMillis());

				currentComponent = "tRowGenerator_2";

				int tos_count_tRowGenerator_2 = 0;

				int nb_line_tRowGenerator_2 = 0;
				int nb_max_row_tRowGenerator_2 = 1;

				class tRowGenerator_2Randomizer {
					public String getRandomtime() {

						return TalendDate.getDate("CCYY-MM-DD hh:mm:ss");

					}

					public String getRandommessage() {

						return "ETL Service Started";

					}
				}
				tRowGenerator_2Randomizer randtRowGenerator_2 = new tRowGenerator_2Randomizer();

				for (int itRowGenerator_2 = 0; itRowGenerator_2 < nb_max_row_tRowGenerator_2; itRowGenerator_2++) {
					row3.time = randtRowGenerator_2.getRandomtime();
					row3.message = randtRowGenerator_2.getRandommessage();
					nb_line_tRowGenerator_2++;

					/**
					 * [tRowGenerator_2 begin ] stop
					 */

					/**
					 * [tRowGenerator_2 main ] start
					 */

					currentComponent = "tRowGenerator_2";

					tos_count_tRowGenerator_2++;

					/**
					 * [tRowGenerator_2 main ] stop
					 */

					/**
					 * [tLogRow_2 main ] start
					 */

					currentComponent = "tLogRow_2";

					// /////////////////////

					strBuffer_tLogRow_2 = new StringBuilder();

					if (row3.time != null) { //

						strBuffer_tLogRow_2.append(String.valueOf(row3.time));

					} //

					strBuffer_tLogRow_2.append("|");

					if (row3.message != null) { //

						strBuffer_tLogRow_2
								.append(String.valueOf(row3.message));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_tLogRow_2 = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_tLogRow_2 = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE", consoleOut_tLogRow_2);
					}

					consoleOut_tLogRow_2
							.println(strBuffer_tLogRow_2.toString());
					consoleOut_tLogRow_2.flush();
					nb_line_tLogRow_2++;
					// ////

					// ////

					// /////////////////////

					tos_count_tLogRow_2++;

					/**
					 * [tLogRow_2 main ] stop
					 */

					/**
					 * [tRowGenerator_2 end ] start
					 */

					currentComponent = "tRowGenerator_2";

				}
				globalMap.put("tRowGenerator_2_NB_LINE",
						nb_line_tRowGenerator_2);

				ok_Hash.put("tRowGenerator_2", true);
				end_Hash.put("tRowGenerator_2", System.currentTimeMillis());

				/**
				 * [tRowGenerator_2 end ] stop
				 */

				/**
				 * [tLogRow_2 end ] start
				 */

				currentComponent = "tLogRow_2";

				// ////
				// ////
				globalMap.put("tLogRow_2_NB_LINE", nb_line_tLogRow_2);

				// /////////////////////

				ok_Hash.put("tLogRow_2", true);
				end_Hash.put("tLogRow_2", System.currentTimeMillis());

				/**
				 * [tLogRow_2 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tRowGenerator_2:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tFileInputProperties_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRowGenerator_2 finally ] start
				 */

				currentComponent = "tRowGenerator_2";

				/**
				 * [tRowGenerator_2 finally ] stop
				 */

				/**
				 * [tLogRow_2 finally ] start
				 */

				currentComponent = "tLogRow_2";

				/**
				 * [tLogRow_2 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRowGenerator_2_SUBPROCESS_STATE", 1);
	}

	public static class row1Struct implements
			routines.system.IPersistableRow<row1Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public String key;

		public String getKey() {
			return this.key;
		}

		public String value;

		public String getValue() {
			return this.value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.key = readString(dis);

					this.value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.key, dos);

				// String

				writeString(this.value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("key=" + key);
			sb.append(",value=" + value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row1Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tFileInputProperties_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tFileInputProperties_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row1Struct row1 = new row1Struct();

				/**
				 * [tContextLoad_1 begin ] start
				 */

				ok_Hash.put("tContextLoad_1", false);
				start_Hash.put("tContextLoad_1", System.currentTimeMillis());

				currentComponent = "tContextLoad_1";

				int tos_count_tContextLoad_1 = 0;

				java.util.List<String> assignList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> newPropertyList_tContextLoad_1 = new java.util.ArrayList<String>();
				java.util.List<String> noAssignList_tContextLoad_1 = new java.util.ArrayList<String>();
				int nb_line_tContextLoad_1 = 0;

				/**
				 * [tContextLoad_1 begin ] stop
				 */

				/**
				 * [tFileInputProperties_1 begin ] start
				 */

				ok_Hash.put("tFileInputProperties_1", false);
				start_Hash.put("tFileInputProperties_1",
						System.currentTimeMillis());

				currentComponent = "tFileInputProperties_1";

				int tos_count_tFileInputProperties_1 = 0;

				java.io.File file_tFileInputProperties_1 = new java.io.File(
						System.getProperty("org.ovirt.engine.dwh.settings"));
				java.util.Properties properties_tFileInputProperties_1 = new java.util.Properties();
				java.io.FileInputStream fis_tFileInputProperties_1 = new java.io.FileInputStream(
						file_tFileInputProperties_1);
				try {
					properties_tFileInputProperties_1
							.load(fis_tFileInputProperties_1);
					java.util.Enumeration enumeration_tFileInputProperties_1 = properties_tFileInputProperties_1
							.propertyNames();
					while (enumeration_tFileInputProperties_1.hasMoreElements()) {
						row1.key = (String) enumeration_tFileInputProperties_1
								.nextElement();
						row1.value = (String) properties_tFileInputProperties_1
								.getProperty(row1.key);

						/**
						 * [tFileInputProperties_1 begin ] stop
						 */

						/**
						 * [tFileInputProperties_1 main ] start
						 */

						currentComponent = "tFileInputProperties_1";

						tos_count_tFileInputProperties_1++;

						/**
						 * [tFileInputProperties_1 main ] stop
						 */

						/**
						 * [tContextLoad_1 main ] start
						 */

						currentComponent = "tContextLoad_1";

						// ////////////////////////
						String tmp_key_tContextLoad_1 = null;

						String key_tContextLoad_1 = null;
						if (row1.key != null) {
							tmp_key_tContextLoad_1 = row1.key.trim();
							if ((tmp_key_tContextLoad_1.startsWith("#") || tmp_key_tContextLoad_1
									.startsWith("!"))) {
								tmp_key_tContextLoad_1 = null;
							} else {
								row1.key = tmp_key_tContextLoad_1;
							}
						}
						if (row1.key != null) {

							key_tContextLoad_1 =

							row1.key;

						}

						String value_tContextLoad_1 = null;
						if (row1.value != null) {

							value_tContextLoad_1 =

							row1.value;

						}

						if (tmp_key_tContextLoad_1 != null) {
							try {
								if (key_tContextLoad_1 != null
										&& "dwhUuid".equals(key_tContextLoad_1)) {
									context.dwhUuid = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "etlVersion"
												.equals(key_tContextLoad_1)) {
									context.etlVersion = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "hoursToKeepDaily"
												.equals(key_tContextLoad_1)) {

									context.hoursToKeepDaily = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "hoursToKeepHourly"
												.equals(key_tContextLoad_1)) {

									context.hoursToKeepHourly = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "hoursToKeepSamples"
												.equals(key_tContextLoad_1)) {

									context.hoursToKeepSamples = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "lastErrorSent"
												.equals(key_tContextLoad_1)) {
									String context_lastErrorSent_value = context
											.getProperty("lastErrorSent");
									if (context_lastErrorSent_value == null)
										context_lastErrorSent_value = "";
									int context_lastErrorSent_pos = context_lastErrorSent_value
											.indexOf(";");
									String context_lastErrorSent_pattern = "yyyy-MM-dd HH:mm:ss";
									if (context_lastErrorSent_pos > -1) {
										context_lastErrorSent_pattern = context_lastErrorSent_value
												.substring(0,
														context_lastErrorSent_pos);
									}
									context.lastErrorSent = (java.util.Date) (new java.text.SimpleDateFormat(
											context_lastErrorSent_pattern)
											.parse(value_tContextLoad_1));

								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbDriverClass"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbDriverClass = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbJdbcConnection"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbJdbcConnection = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbPassword"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbPassword = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "ovirtEngineHistoryDbUser"
												.equals(key_tContextLoad_1)) {
									context.ovirtEngineHistoryDbUser = value_tContextLoad_1;
								}

								if (key_tContextLoad_1 != null
										&& "runDeleteTime"
												.equals(key_tContextLoad_1)) {

									context.runDeleteTime = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "runInterleave"
												.equals(key_tContextLoad_1)) {

									context.runInterleave = Integer
											.parseInt(value_tContextLoad_1);

								}

								if (key_tContextLoad_1 != null
										&& "timeBetweenErrorEvents"
												.equals(key_tContextLoad_1)) {

									context.timeBetweenErrorEvents = Long
											.parseLong(value_tContextLoad_1);

								}

								if (context.getProperty(key_tContextLoad_1) != null) {
									assignList_tContextLoad_1
											.add(key_tContextLoad_1);
								} else {
									newPropertyList_tContextLoad_1
											.add(key_tContextLoad_1);
								}
								context.setProperty(key_tContextLoad_1,
										value_tContextLoad_1);
							} catch (java.lang.Exception e) {

								System.err
										.println("Setting a value for the key \""
												+ key_tContextLoad_1
												+ "\" has failed. Error message: "
												+ e.getMessage());
							}
							nb_line_tContextLoad_1++;
						}
						// ////////////////////////

						tos_count_tContextLoad_1++;

						/**
						 * [tContextLoad_1 main ] stop
						 */

						/**
						 * [tFileInputProperties_1 end ] start
						 */

						currentComponent = "tFileInputProperties_1";

						tos_count_tFileInputProperties_1++;
					}
				} finally {
					if (fis_tFileInputProperties_1 != null) {
						fis_tFileInputProperties_1.close();
					}
				}
				globalMap.put("tFileInputProperties_1_NB_LINE",
						tos_count_tFileInputProperties_1);

				ok_Hash.put("tFileInputProperties_1", true);
				end_Hash.put("tFileInputProperties_1",
						System.currentTimeMillis());

				/**
				 * [tFileInputProperties_1 end ] stop
				 */

				/**
				 * [tContextLoad_1 end ] start
				 */

				currentComponent = "tContextLoad_1";

				java.util.Enumeration<?> enu_tContextLoad_1 = context
						.propertyNames();
				while (enu_tContextLoad_1.hasMoreElements()) {
					String key_tContextLoad_1 = (String) enu_tContextLoad_1
							.nextElement();
					if (!assignList_tContextLoad_1.contains(key_tContextLoad_1)
							&& !newPropertyList_tContextLoad_1
									.contains(key_tContextLoad_1)) {
						noAssignList_tContextLoad_1.add(key_tContextLoad_1);
					}
				}

				String newPropertyStr_tContextLoad_1 = newPropertyList_tContextLoad_1
						.toString();
				String newProperty_tContextLoad_1 = newPropertyStr_tContextLoad_1
						.substring(1,
								newPropertyStr_tContextLoad_1.length() - 1);

				String noAssignStr_tContextLoad_1 = noAssignList_tContextLoad_1
						.toString();
				String noAssign_tContextLoad_1 = noAssignStr_tContextLoad_1
						.substring(1, noAssignStr_tContextLoad_1.length() - 1);

				globalMap.put("tContextLoad_1_KEY_NOT_INCONTEXT",
						newProperty_tContextLoad_1);
				globalMap.put("tContextLoad_1_KEY_NOT_LOADED",
						noAssign_tContextLoad_1);

				globalMap.put("tContextLoad_1_NB_LINE", nb_line_tContextLoad_1);

				List<String> parametersToEncrypt_tContextLoad_1 = new java.util.ArrayList<String>();

				parametersToEncrypt_tContextLoad_1.add("ovirtEngineDbPassword");

				parametersToEncrypt_tContextLoad_1
						.add("ovirtEngineHistoryDbPassword");

				resumeUtil.addLog("NODE", "NODE:tContextLoad_1", "", Thread
						.currentThread().getId() + "", "", "", "", "",
						resumeUtil.convertToJsonText(context,
								parametersToEncrypt_tContextLoad_1));

				ok_Hash.put("tContextLoad_1", true);
				end_Hash.put("tContextLoad_1", System.currentTimeMillis());

				/**
				 * [tContextLoad_1 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tFileInputProperties_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCConnection_6Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tFileInputProperties_1 finally ] start
				 */

				currentComponent = "tFileInputProperties_1";

				/**
				 * [tFileInputProperties_1 finally ] stop
				 */

				/**
				 * [tContextLoad_1 finally ] start
				 */

				currentComponent = "tContextLoad_1";

				/**
				 * [tContextLoad_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tFileInputProperties_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_6Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_6_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_6 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_6", false);
				start_Hash.put("tJDBCConnection_6", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_6";

				int tos_count_tJDBCConnection_6 = 0;

				String url_tJDBCConnection_6 = context.ovirtEngineDbJdbcConnection;

				String dbUser_tJDBCConnection_6 = context.ovirtEngineDbUser;

				final String decryptedPassword_tJDBCConnection_6 = context.ovirtEngineDbPassword;
				String dbPwd_tJDBCConnection_6 = decryptedPassword_tJDBCConnection_6;

				java.sql.Connection conn_tJDBCConnection_6 = null;

				String sharedConnectionName_tJDBCConnection_6 = "engine-events";
				conn_tJDBCConnection_6 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_6, dbUser_tJDBCConnection_6,
						dbPwd_tJDBCConnection_6,
						sharedConnectionName_tJDBCConnection_6);
				if (null != conn_tJDBCConnection_6) {

					conn_tJDBCConnection_6.setAutoCommit(true);
				}

				globalMap.put("conn_tJDBCConnection_6", conn_tJDBCConnection_6);
				globalMap.put("url_tJDBCConnection_6", url_tJDBCConnection_6);
				// globalMap.put("user_tJDBCConnection_6",
				// dbUser_tJDBCConnection_6);
				// globalMap.put("pass_tJDBCConnection_6",
				// dbPwd_tJDBCConnection_6);

				/**
				 * [tJDBCConnection_6 begin ] stop
				 */

				/**
				 * [tJDBCConnection_6 main ] start
				 */

				currentComponent = "tJDBCConnection_6";

				tos_count_tJDBCConnection_6++;

				/**
				 * [tJDBCConnection_6 main ] stop
				 */

				/**
				 * [tJDBCConnection_6 end ] start
				 */

				currentComponent = "tJDBCConnection_6";

				ok_Hash.put("tJDBCConnection_6", true);
				end_Hash.put("tJDBCConnection_6", System.currentTimeMillis());

				tJDBCConnection_2Process(globalMap);

				/**
				 * [tJDBCConnection_6 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_6 finally ] start
				 */

				currentComponent = "tJDBCConnection_6";

				/**
				 * [tJDBCConnection_6 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_6_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_2Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_2 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_2", false);
				start_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_2";

				int tos_count_tJDBCConnection_2 = 0;

				String url_tJDBCConnection_2 = context.ovirtEngineDbJdbcConnection;

				String dbUser_tJDBCConnection_2 = context.ovirtEngineDbUser;

				final String decryptedPassword_tJDBCConnection_2 = context.ovirtEngineDbPassword;
				String dbPwd_tJDBCConnection_2 = decryptedPassword_tJDBCConnection_2;

				java.sql.Connection conn_tJDBCConnection_2 = null;

				String sharedConnectionName_tJDBCConnection_2 = "engine";
				conn_tJDBCConnection_2 = SharedDBConnection.getDBConnection(
						context.ovirtEngineDbDriverClass,
						url_tJDBCConnection_2, dbUser_tJDBCConnection_2,
						dbPwd_tJDBCConnection_2,
						sharedConnectionName_tJDBCConnection_2);
				if (null != conn_tJDBCConnection_2) {

					conn_tJDBCConnection_2.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_2", conn_tJDBCConnection_2);
				globalMap.put("url_tJDBCConnection_2", url_tJDBCConnection_2);
				// globalMap.put("user_tJDBCConnection_2",
				// dbUser_tJDBCConnection_2);
				// globalMap.put("pass_tJDBCConnection_2",
				// dbPwd_tJDBCConnection_2);

				/**
				 * [tJDBCConnection_2 begin ] stop
				 */

				/**
				 * [tJDBCConnection_2 main ] start
				 */

				currentComponent = "tJDBCConnection_2";

				tos_count_tJDBCConnection_2++;

				/**
				 * [tJDBCConnection_2 main ] stop
				 */

				/**
				 * [tJDBCConnection_2 end ] start
				 */

				currentComponent = "tJDBCConnection_2";

				ok_Hash.put("tJDBCConnection_2", true);
				end_Hash.put("tJDBCConnection_2", System.currentTimeMillis());

				tRowGenerator_6Process(globalMap);

				/**
				 * [tJDBCConnection_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_2 finally ] start
				 */

				currentComponent = "tJDBCConnection_2";

				/**
				 * [tJDBCConnection_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_2_SUBPROCESS_STATE", 1);
	}

	public static class copyOfevent_output_0Struct implements
			routines.system.IPersistableRow<copyOfevent_output_0Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public java.util.Date log_time;

		public java.util.Date getLog_time() {
			return this.log_time;
		}

		public String log_type_name;

		public String getLog_type_name() {
			return this.log_type_name;
		}

		public int log_type;

		public int getLog_type() {
			return this.log_type;
		}

		public int severity;

		public int getSeverity() {
			return this.severity;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.log_time = readDate(dis);

					this.log_type_name = readString(dis);

					this.log_type = dis.readInt();

					this.severity = dis.readInt();

					this.message = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.log_time, dos);

				// String

				writeString(this.log_type_name, dos);

				// int

				dos.writeInt(this.log_type);

				// int

				dos.writeInt(this.severity);

				// String

				writeString(this.message, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("log_time=" + String.valueOf(log_time));
			sb.append(",log_type_name=" + log_type_name);
			sb.append(",log_type=" + String.valueOf(log_type));
			sb.append(",severity=" + String.valueOf(severity));
			sb.append(",message=" + message);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(copyOfevent_output_0Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row7Struct implements
			routines.system.IPersistableRow<row7Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public java.util.Date time;

		public java.util.Date getTime() {
			return this.time;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.time = readDate(dis);

					this.message = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.time, dos);

				// String

				writeString(this.message, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("time=" + String.valueOf(time));
			sb.append(",message=" + message);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row7Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tRowGenerator_6Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRowGenerator_6_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row7Struct row7 = new row7Struct();
				copyOfevent_output_0Struct copyOfevent_output_0 = new copyOfevent_output_0Struct();

				/**
				 * [tJDBCOutput_3 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_3", false);
				start_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_3";

				int tos_count_tJDBCOutput_3 = 0;

				int nb_line_tJDBCOutput_3 = 0;
				int nb_line_update_tJDBCOutput_3 = 0;
				int nb_line_inserted_tJDBCOutput_3 = 0;
				int nb_line_deleted_tJDBCOutput_3 = 0;
				int nb_line_rejected_tJDBCOutput_3 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_3 = 0;

				int deletedCount_tJDBCOutput_3 = 0;
				int updatedCount_tJDBCOutput_3 = 0;
				int insertedCount_tJDBCOutput_3 = 0;
				int rejectedCount_tJDBCOutput_3 = 0;

				boolean whetherReject_tJDBCOutput_3 = false;

				java.sql.Connection connection_tJDBCOutput_3 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_6");
				int batchSize_tJDBCOutput_3 = 10000;
				int batchSizeCounter_tJDBCOutput_3 = 0;

				String insert_tJDBCOutput_3 = "INSERT INTO "
						+ "audit_log"
						+ " (log_time,log_type_name,log_type,severity,message) VALUES (?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_3 = connection_tJDBCOutput_3
						.prepareStatement(insert_tJDBCOutput_3);

				/**
				 * [tJDBCOutput_3 begin ] stop
				 */

				/**
				 * [tMap_3 begin ] start
				 */

				ok_Hash.put("tMap_3", false);
				start_Hash.put("tMap_3", System.currentTimeMillis());

				currentComponent = "tMap_3";

				int tos_count_tMap_3 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_3__Struct {
				}
				Var__tMap_3__Struct Var__tMap_3 = new Var__tMap_3__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				copyOfevent_output_0Struct copyOfevent_output_0_tmp = new copyOfevent_output_0Struct();
				// ###############################

				/**
				 * [tMap_3 begin ] stop
				 */

				/**
				 * [tRowGenerator_6 begin ] start
				 */

				ok_Hash.put("tRowGenerator_6", false);
				start_Hash.put("tRowGenerator_6", System.currentTimeMillis());

				currentComponent = "tRowGenerator_6";

				int tos_count_tRowGenerator_6 = 0;

				int nb_line_tRowGenerator_6 = 0;
				int nb_max_row_tRowGenerator_6 = 1;

				class tRowGenerator_6Randomizer {
					public java.util.Date getRandomtime() {

						return TalendDate.getCurrentDate();

					}

					public String getRandommessage() {

						return "ETL Service Started";

					}
				}
				tRowGenerator_6Randomizer randtRowGenerator_6 = new tRowGenerator_6Randomizer();

				for (int itRowGenerator_6 = 0; itRowGenerator_6 < nb_max_row_tRowGenerator_6; itRowGenerator_6++) {
					row7.time = randtRowGenerator_6.getRandomtime();
					row7.message = randtRowGenerator_6.getRandommessage();
					nb_line_tRowGenerator_6++;

					/**
					 * [tRowGenerator_6 begin ] stop
					 */

					/**
					 * [tRowGenerator_6 main ] start
					 */

					currentComponent = "tRowGenerator_6";

					tos_count_tRowGenerator_6++;

					/**
					 * [tRowGenerator_6 main ] stop
					 */

					/**
					 * [tMap_3 main ] start
					 */

					currentComponent = "tMap_3";

					boolean hasCasePrimitiveKeyWithNull_tMap_3 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_3 = false;
					boolean mainRowRejected_tMap_3 = false;

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_3__Struct Var = Var__tMap_3;// ###############################
						// ###############################
						// # Output tables

						copyOfevent_output_0 = null;

						// # Output table : 'copyOfevent_output_0'
						copyOfevent_output_0_tmp.log_time = row7.time;
						copyOfevent_output_0_tmp.log_type_name = "DWH_STARTED";
						copyOfevent_output_0_tmp.log_type = 9700;
						copyOfevent_output_0_tmp.severity = 0;
						copyOfevent_output_0_tmp.message = row7.message;
						copyOfevent_output_0 = copyOfevent_output_0_tmp;
						// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_3 = false;

					tos_count_tMap_3++;

					/**
					 * [tMap_3 main ] stop
					 */
					// Start of branch "copyOfevent_output_0"
					if (copyOfevent_output_0 != null) {

						/**
						 * [tJDBCOutput_3 main ] start
						 */

						currentComponent = "tJDBCOutput_3";

						whetherReject_tJDBCOutput_3 = false;
						if (copyOfevent_output_0.log_time != null) {
							pstmt_tJDBCOutput_3.setTimestamp(
									1,
									new java.sql.Timestamp(
											copyOfevent_output_0.log_time
													.getTime()));
						} else {
							pstmt_tJDBCOutput_3.setNull(1, java.sql.Types.DATE);
						}

						if (copyOfevent_output_0.log_type_name == null) {
							pstmt_tJDBCOutput_3.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_3.setString(2,
									copyOfevent_output_0.log_type_name);
						}

						pstmt_tJDBCOutput_3.setInt(3,
								copyOfevent_output_0.log_type);

						pstmt_tJDBCOutput_3.setInt(4,
								copyOfevent_output_0.severity);

						if (copyOfevent_output_0.message == null) {
							pstmt_tJDBCOutput_3.setNull(5,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_3.setString(5,
									copyOfevent_output_0.message);
						}

						try {
							insertedCount_tJDBCOutput_3 = insertedCount_tJDBCOutput_3
									+ pstmt_tJDBCOutput_3.executeUpdate();
							nb_line_tJDBCOutput_3++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_3 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_3++;

						/**
						 * [tJDBCOutput_3 main ] stop
						 */

					} // End of branch "copyOfevent_output_0"

					/**
					 * [tRowGenerator_6 end ] start
					 */

					currentComponent = "tRowGenerator_6";

				}
				globalMap.put("tRowGenerator_6_NB_LINE",
						nb_line_tRowGenerator_6);

				ok_Hash.put("tRowGenerator_6", true);
				end_Hash.put("tRowGenerator_6", System.currentTimeMillis());

				/**
				 * [tRowGenerator_6 end ] stop
				 */

				/**
				 * [tMap_3 end ] start
				 */

				currentComponent = "tMap_3";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_3", true);
				end_Hash.put("tMap_3", System.currentTimeMillis());

				/**
				 * [tMap_3 end ] stop
				 */

				/**
				 * [tJDBCOutput_3 end ] start
				 */

				currentComponent = "tJDBCOutput_3";

				if (pstmt_tJDBCOutput_3 != null) {

					pstmt_tJDBCOutput_3.close();

				}

				nb_line_deleted_tJDBCOutput_3 = nb_line_deleted_tJDBCOutput_3
						+ deletedCount_tJDBCOutput_3;
				nb_line_update_tJDBCOutput_3 = nb_line_update_tJDBCOutput_3
						+ updatedCount_tJDBCOutput_3;
				nb_line_inserted_tJDBCOutput_3 = nb_line_inserted_tJDBCOutput_3
						+ insertedCount_tJDBCOutput_3;
				nb_line_rejected_tJDBCOutput_3 = nb_line_rejected_tJDBCOutput_3
						+ rejectedCount_tJDBCOutput_3;

				globalMap.put("tJDBCOutput_3_NB_LINE", nb_line_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_3);
				globalMap.put("tJDBCOutput_3_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_3);

				ok_Hash.put("tJDBCOutput_3", true);
				end_Hash.put("tJDBCOutput_3", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_3 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tRowGenerator_6:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tRowGenerator_7Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRowGenerator_6 finally ] start
				 */

				currentComponent = "tRowGenerator_6";

				/**
				 * [tRowGenerator_6 finally ] stop
				 */

				/**
				 * [tMap_3 finally ] start
				 */

				currentComponent = "tMap_3";

				/**
				 * [tMap_3 finally ] stop
				 */

				/**
				 * [tJDBCOutput_3 finally ] start
				 */

				currentComponent = "tJDBCOutput_3";

				/**
				 * [tJDBCOutput_3 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRowGenerator_6_SUBPROCESS_STATE", 1);
	}

	public static class row4Struct implements
			routines.system.IPersistableRow<row4Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		protected static final int DEFAULT_HASHCODE = 1;
		protected static final int PRIME = 31;
		protected int hashCode = DEFAULT_HASHCODE;
		public boolean hashCodeDirty = true;

		public String loopKey;

		public String var_name;

		public String getVar_name() {
			return this.var_name;
		}

		public String var_value;

		public String getVar_value() {
			return this.var_value;
		}

		@Override
		public int hashCode() {
			if (this.hashCodeDirty) {
				final int prime = PRIME;
				int result = DEFAULT_HASHCODE;

				result = prime
						* result
						+ ((this.var_name == null) ? 0 : this.var_name
								.hashCode());

				this.hashCode = result;
				this.hashCodeDirty = false;
			}
			return this.hashCode;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			final row4Struct other = (row4Struct) obj;

			if (this.var_name == null) {
				if (other.var_name != null)
					return false;

			} else if (!this.var_name.equals(other.var_name))

				return false;

			return true;
		}

		public void copyDataTo(row4Struct other) {

			other.var_name = this.var_name;
			other.var_value = this.var_value;

		}

		public void copyKeysDataTo(row4Struct other) {

			other.var_name = this.var_name;

		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.var_name = readString(dis);

					this.var_value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.var_name, dos);

				// String

				writeString(this.var_value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("var_name=" + var_name);
			sb.append(",var_value=" + var_value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row4Struct other) {

			int returnValue = -1;

			returnValue = checkNullsAndCompare(this.var_name, other.var_name);
			if (returnValue != 0) {
				return returnValue;
			}

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tRowGenerator_7Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRowGenerator_7_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row4Struct row4 = new row4Struct();

				/**
				 * [tJDBCOutput_5 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_5", false);
				start_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_5";

				int tos_count_tJDBCOutput_5 = 0;

				int updateKeyCount_tJDBCOutput_5 = 1;
				if (updateKeyCount_tJDBCOutput_5 < 1) {
					throw new RuntimeException(
							"For update, Schema must have a key");
				}

				int nb_line_tJDBCOutput_5 = 0;
				int nb_line_update_tJDBCOutput_5 = 0;
				int nb_line_inserted_tJDBCOutput_5 = 0;
				int nb_line_deleted_tJDBCOutput_5 = 0;
				int nb_line_rejected_tJDBCOutput_5 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_5 = 0;

				int deletedCount_tJDBCOutput_5 = 0;
				int updatedCount_tJDBCOutput_5 = 0;
				int insertedCount_tJDBCOutput_5 = 0;
				int rejectedCount_tJDBCOutput_5 = 0;

				boolean whetherReject_tJDBCOutput_5 = false;

				java.sql.Connection connection_tJDBCOutput_5 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_6");
				int batchSize_tJDBCOutput_5 = 10000;
				int batchSizeCounter_tJDBCOutput_5 = 0;

				String update_tJDBCOutput_5 = "UPDATE "
						+ "dwh_history_timekeeping"
						+ " SET var_value = ? WHERE var_name = ?";
				java.sql.PreparedStatement pstmtUpdate_tJDBCOutput_5 = connection_tJDBCOutput_5
						.prepareStatement(update_tJDBCOutput_5);
				String insert_tJDBCOutput_5 = "INSERT INTO "
						+ "dwh_history_timekeeping"
						+ " (var_name,var_value) VALUES (?,?)";
				java.sql.PreparedStatement pstmtInsert_tJDBCOutput_5 = connection_tJDBCOutput_5
						.prepareStatement(insert_tJDBCOutput_5);

				/**
				 * [tJDBCOutput_5 begin ] stop
				 */

				/**
				 * [tRowGenerator_7 begin ] start
				 */

				ok_Hash.put("tRowGenerator_7", false);
				start_Hash.put("tRowGenerator_7", System.currentTimeMillis());

				currentComponent = "tRowGenerator_7";

				int tos_count_tRowGenerator_7 = 0;

				int nb_line_tRowGenerator_7 = 0;
				int nb_max_row_tRowGenerator_7 = 1;

				class tRowGenerator_7Randomizer {
					public String getRandomvar_name() {

						return "DwhCurrentlyRunning";

					}

					public String getRandomvar_value() {

						return "1";

					}
				}
				tRowGenerator_7Randomizer randtRowGenerator_7 = new tRowGenerator_7Randomizer();

				for (int itRowGenerator_7 = 0; itRowGenerator_7 < nb_max_row_tRowGenerator_7; itRowGenerator_7++) {
					row4.var_name = randtRowGenerator_7.getRandomvar_name();
					row4.var_value = randtRowGenerator_7.getRandomvar_value();
					nb_line_tRowGenerator_7++;

					/**
					 * [tRowGenerator_7 begin ] stop
					 */

					/**
					 * [tRowGenerator_7 main ] start
					 */

					currentComponent = "tRowGenerator_7";

					tos_count_tRowGenerator_7++;

					/**
					 * [tRowGenerator_7 main ] stop
					 */

					/**
					 * [tJDBCOutput_5 main ] start
					 */

					currentComponent = "tJDBCOutput_5";

					whetherReject_tJDBCOutput_5 = false;
					int updateFlag_tJDBCOutput_5 = 0;
					if (row4.var_value == null) {
						pstmtUpdate_tJDBCOutput_5.setNull(1,
								java.sql.Types.VARCHAR);
					} else {
						pstmtUpdate_tJDBCOutput_5.setString(1, row4.var_value);
					}

					if (row4.var_name == null) {
						pstmtUpdate_tJDBCOutput_5.setNull(2,
								java.sql.Types.VARCHAR);
					} else {
						pstmtUpdate_tJDBCOutput_5.setString(2, row4.var_name);
					}

					try {
						updateFlag_tJDBCOutput_5 = pstmtUpdate_tJDBCOutput_5
								.executeUpdate();
						updatedCount_tJDBCOutput_5 = updatedCount_tJDBCOutput_5
								+ updateFlag_tJDBCOutput_5;
						if (updateFlag_tJDBCOutput_5 == 0) {

							if (row4.var_name == null) {
								pstmtInsert_tJDBCOutput_5.setNull(1,
										java.sql.Types.VARCHAR);
							} else {
								pstmtInsert_tJDBCOutput_5.setString(1,
										row4.var_name);
							}

							if (row4.var_value == null) {
								pstmtInsert_tJDBCOutput_5.setNull(2,
										java.sql.Types.VARCHAR);
							} else {
								pstmtInsert_tJDBCOutput_5.setString(2,
										row4.var_value);
							}

							insertedCount_tJDBCOutput_5 = insertedCount_tJDBCOutput_5
									+ pstmtInsert_tJDBCOutput_5.executeUpdate();
							nb_line_tJDBCOutput_5++;
						} else {
							nb_line_tJDBCOutput_5++;

						}
					} catch (java.lang.Exception e) {
						whetherReject_tJDBCOutput_5 = true;
						throw (e);
					}

					tos_count_tJDBCOutput_5++;

					/**
					 * [tJDBCOutput_5 main ] stop
					 */

					/**
					 * [tRowGenerator_7 end ] start
					 */

					currentComponent = "tRowGenerator_7";

				}
				globalMap.put("tRowGenerator_7_NB_LINE",
						nb_line_tRowGenerator_7);

				ok_Hash.put("tRowGenerator_7", true);
				end_Hash.put("tRowGenerator_7", System.currentTimeMillis());

				/**
				 * [tRowGenerator_7 end ] stop
				 */

				/**
				 * [tJDBCOutput_5 end ] start
				 */

				currentComponent = "tJDBCOutput_5";

				if (pstmtUpdate_tJDBCOutput_5 != null) {

					pstmtUpdate_tJDBCOutput_5.close();

				}
				if (pstmtInsert_tJDBCOutput_5 != null) {

					pstmtInsert_tJDBCOutput_5.close();

				}

				nb_line_deleted_tJDBCOutput_5 = nb_line_deleted_tJDBCOutput_5
						+ deletedCount_tJDBCOutput_5;
				nb_line_update_tJDBCOutput_5 = nb_line_update_tJDBCOutput_5
						+ updatedCount_tJDBCOutput_5;
				nb_line_inserted_tJDBCOutput_5 = nb_line_inserted_tJDBCOutput_5
						+ insertedCount_tJDBCOutput_5;
				nb_line_rejected_tJDBCOutput_5 = nb_line_rejected_tJDBCOutput_5
						+ rejectedCount_tJDBCOutput_5;

				globalMap.put("tJDBCOutput_5_NB_LINE", nb_line_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_5);
				globalMap.put("tJDBCOutput_5_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_5);

				ok_Hash.put("tJDBCOutput_5", true);
				end_Hash.put("tJDBCOutput_5", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_5 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tRowGenerator_7:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJDBCConnection_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRowGenerator_7 finally ] start
				 */

				currentComponent = "tRowGenerator_7";

				/**
				 * [tRowGenerator_7 finally ] stop
				 */

				/**
				 * [tJDBCOutput_5 finally ] start
				 */

				currentComponent = "tJDBCOutput_5";

				/**
				 * [tJDBCOutput_5 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRowGenerator_7_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_1 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_1", false);
				start_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_1";

				int tos_count_tJDBCConnection_1 = 0;

				String url_tJDBCConnection_1 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_1 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_1 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_1 = decryptedPassword_tJDBCConnection_1;

				java.sql.Connection conn_tJDBCConnection_1 = null;

				String sharedConnectionName_tJDBCConnection_1 = "sample_ovirt_engine_history";
				conn_tJDBCConnection_1 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_1, dbUser_tJDBCConnection_1,
						dbPwd_tJDBCConnection_1,
						sharedConnectionName_tJDBCConnection_1);
				if (null != conn_tJDBCConnection_1) {

					conn_tJDBCConnection_1.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_1", conn_tJDBCConnection_1);
				globalMap.put("url_tJDBCConnection_1", url_tJDBCConnection_1);
				// globalMap.put("user_tJDBCConnection_1",
				// dbUser_tJDBCConnection_1);
				// globalMap.put("pass_tJDBCConnection_1",
				// dbPwd_tJDBCConnection_1);

				/**
				 * [tJDBCConnection_1 begin ] stop
				 */

				/**
				 * [tJDBCConnection_1 main ] start
				 */

				currentComponent = "tJDBCConnection_1";

				tos_count_tJDBCConnection_1++;

				/**
				 * [tJDBCConnection_1 main ] stop
				 */

				/**
				 * [tJDBCConnection_1 end ] start
				 */

				currentComponent = "tJDBCConnection_1";

				ok_Hash.put("tJDBCConnection_1", true);
				end_Hash.put("tJDBCConnection_1", System.currentTimeMillis());

				tJDBCConnection_3Process(globalMap);

				/**
				 * [tJDBCConnection_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_1 finally ] start
				 */

				currentComponent = "tJDBCConnection_1";

				/**
				 * [tJDBCConnection_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_1_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_3Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_3 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_3", false);
				start_Hash.put("tJDBCConnection_3", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_3";

				int tos_count_tJDBCConnection_3 = 0;

				String url_tJDBCConnection_3 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_3 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_3 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_3 = decryptedPassword_tJDBCConnection_3;

				java.sql.Connection conn_tJDBCConnection_3 = null;

				String sharedConnectionName_tJDBCConnection_3 = "hourly_ovirt_engine_history";
				conn_tJDBCConnection_3 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_3, dbUser_tJDBCConnection_3,
						dbPwd_tJDBCConnection_3,
						sharedConnectionName_tJDBCConnection_3);
				if (null != conn_tJDBCConnection_3) {

					conn_tJDBCConnection_3.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_3", conn_tJDBCConnection_3);
				globalMap.put("url_tJDBCConnection_3", url_tJDBCConnection_3);
				// globalMap.put("user_tJDBCConnection_3",
				// dbUser_tJDBCConnection_3);
				// globalMap.put("pass_tJDBCConnection_3",
				// dbPwd_tJDBCConnection_3);

				/**
				 * [tJDBCConnection_3 begin ] stop
				 */

				/**
				 * [tJDBCConnection_3 main ] start
				 */

				currentComponent = "tJDBCConnection_3";

				tos_count_tJDBCConnection_3++;

				/**
				 * [tJDBCConnection_3 main ] stop
				 */

				/**
				 * [tJDBCConnection_3 end ] start
				 */

				currentComponent = "tJDBCConnection_3";

				ok_Hash.put("tJDBCConnection_3", true);
				end_Hash.put("tJDBCConnection_3", System.currentTimeMillis());

				tJDBCConnection_4Process(globalMap);

				/**
				 * [tJDBCConnection_3 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_3 finally ] start
				 */

				currentComponent = "tJDBCConnection_3";

				/**
				 * [tJDBCConnection_3 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_3_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_4Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_4 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_4", false);
				start_Hash.put("tJDBCConnection_4", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_4";

				int tos_count_tJDBCConnection_4 = 0;

				String url_tJDBCConnection_4 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_4 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_4 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_4 = decryptedPassword_tJDBCConnection_4;

				java.sql.Connection conn_tJDBCConnection_4 = null;

				String sharedConnectionName_tJDBCConnection_4 = "daily_ovirt_engine_history";
				conn_tJDBCConnection_4 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_4, dbUser_tJDBCConnection_4,
						dbPwd_tJDBCConnection_4,
						sharedConnectionName_tJDBCConnection_4);
				if (null != conn_tJDBCConnection_4) {

					conn_tJDBCConnection_4.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_4", conn_tJDBCConnection_4);
				globalMap.put("url_tJDBCConnection_4", url_tJDBCConnection_4);
				// globalMap.put("user_tJDBCConnection_4",
				// dbUser_tJDBCConnection_4);
				// globalMap.put("pass_tJDBCConnection_4",
				// dbPwd_tJDBCConnection_4);

				/**
				 * [tJDBCConnection_4 begin ] stop
				 */

				/**
				 * [tJDBCConnection_4 main ] start
				 */

				currentComponent = "tJDBCConnection_4";

				tos_count_tJDBCConnection_4++;

				/**
				 * [tJDBCConnection_4 main ] stop
				 */

				/**
				 * [tJDBCConnection_4 end ] start
				 */

				currentComponent = "tJDBCConnection_4";

				ok_Hash.put("tJDBCConnection_4", true);
				end_Hash.put("tJDBCConnection_4", System.currentTimeMillis());

				tJDBCConnection_5Process(globalMap);

				/**
				 * [tJDBCConnection_4 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_4 finally ] start
				 */

				currentComponent = "tJDBCConnection_4";

				/**
				 * [tJDBCConnection_4 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_4_SUBPROCESS_STATE", 1);
	}

	public void tJDBCConnection_5Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJDBCConnection_5_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJDBCConnection_5 begin ] start
				 */

				ok_Hash.put("tJDBCConnection_5", false);
				start_Hash.put("tJDBCConnection_5", System.currentTimeMillis());

				currentComponent = "tJDBCConnection_5";

				int tos_count_tJDBCConnection_5 = 0;

				String url_tJDBCConnection_5 = context.ovirtEngineHistoryDbJdbcConnection;

				String dbUser_tJDBCConnection_5 = context.ovirtEngineHistoryDbUser;

				final String decryptedPassword_tJDBCConnection_5 = context.ovirtEngineHistoryDbPassword;
				String dbPwd_tJDBCConnection_5 = decryptedPassword_tJDBCConnection_5;

				java.sql.Connection conn_tJDBCConnection_5 = null;

				String sharedConnectionName_tJDBCConnection_5 = "delete_ovirt_engine_history";
				conn_tJDBCConnection_5 = SharedDBConnection.getDBConnection(
						context.ovirtEngineHistoryDbDriverClass,
						url_tJDBCConnection_5, dbUser_tJDBCConnection_5,
						dbPwd_tJDBCConnection_5,
						sharedConnectionName_tJDBCConnection_5);
				if (null != conn_tJDBCConnection_5) {

					conn_tJDBCConnection_5.setAutoCommit(false);
				}

				globalMap.put("conn_tJDBCConnection_5", conn_tJDBCConnection_5);
				globalMap.put("url_tJDBCConnection_5", url_tJDBCConnection_5);
				// globalMap.put("user_tJDBCConnection_5",
				// dbUser_tJDBCConnection_5);
				// globalMap.put("pass_tJDBCConnection_5",
				// dbPwd_tJDBCConnection_5);

				/**
				 * [tJDBCConnection_5 begin ] stop
				 */

				/**
				 * [tJDBCConnection_5 main ] start
				 */

				currentComponent = "tJDBCConnection_5";

				tos_count_tJDBCConnection_5++;

				/**
				 * [tJDBCConnection_5 main ] stop
				 */

				/**
				 * [tJDBCConnection_5 end ] start
				 */

				currentComponent = "tJDBCConnection_5";

				ok_Hash.put("tJDBCConnection_5", true);
				end_Hash.put("tJDBCConnection_5", System.currentTimeMillis());

				/**
				 * [tJDBCConnection_5 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJDBCConnection_5 finally ] start
				 */

				currentComponent = "tJDBCConnection_5";

				/**
				 * [tJDBCConnection_5 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJDBCConnection_5_SUBPROCESS_STATE", 1);
	}

	public void tRunJob_2Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRunJob_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tRunJob_2 begin ] start
				 */

				ok_Hash.put("tRunJob_2", false);
				start_Hash.put("tRunJob_2", System.currentTimeMillis());

				currentComponent = "tRunJob_2";

				int tos_count_tRunJob_2 = 0;

				/**
				 * [tRunJob_2 begin ] stop
				 */

				/**
				 * [tRunJob_2 main ] start
				 */

				currentComponent = "tRunJob_2";

				java.util.List<String> paraList_tRunJob_2 = new java.util.ArrayList<String>();

				paraList_tRunJob_2.add("--father_pid=" + pid);

				paraList_tRunJob_2.add("--root_pid=" + rootPid);

				paraList_tRunJob_2.add("--father_node=tRunJob_2");

				paraList_tRunJob_2.add("--context=Default");

				// for feature:10589

				paraList_tRunJob_2.add("--stat_port=" + portStats);

				if (resuming_logs_dir_path != null) {
					paraList_tRunJob_2.add("--resuming_logs_dir_path="
							+ resuming_logs_dir_path);
				}
				String childResumePath_tRunJob_2 = ResumeUtil
						.getChildJobCheckPointPath(resuming_checkpoint_path);
				String tRunJobName_tRunJob_2 = ResumeUtil
						.getRighttRunJob(resuming_checkpoint_path);
				if ("tRunJob_2".equals(tRunJobName_tRunJob_2)
						&& childResumePath_tRunJob_2 != null) {
					paraList_tRunJob_2
							.add("--resuming_checkpoint_path="
									+ ResumeUtil
											.getChildJobCheckPointPath(resuming_checkpoint_path));
				}
				paraList_tRunJob_2.add("--parent_part_launcher=JOB:" + jobName
						+ "/NODE:tRunJob_2");

				java.util.Map<String, Object> parentContextMap_tRunJob_2 = new java.util.HashMap<String, Object>();

				context.synchronizeContext();
				java.util.Enumeration<?> propertyNames_tRunJob_2 = context
						.propertyNames();
				while (propertyNames_tRunJob_2.hasMoreElements()) {
					String key_tRunJob_2 = (String) propertyNames_tRunJob_2
							.nextElement();
					Object value_tRunJob_2 = (Object) context
							.get(key_tRunJob_2);
					paraList_tRunJob_2.add("--context_param " + key_tRunJob_2
							+ "=" + value_tRunJob_2);
				}

				parentContextMap_tRunJob_2.put("dwhUuid", context.dwhUuid);

				parentContextMap_tRunJob_2
						.put("etlVersion", context.etlVersion);

				parentContextMap_tRunJob_2.put("hoursToKeepDaily",
						context.hoursToKeepDaily);

				parentContextMap_tRunJob_2.put("hoursToKeepHourly",
						context.hoursToKeepHourly);

				parentContextMap_tRunJob_2.put("hoursToKeepSamples",
						context.hoursToKeepSamples);

				parentContextMap_tRunJob_2.put("lastErrorSent",
						context.lastErrorSent);

				parentContextMap_tRunJob_2.put("ovirtEngineDbDriverClass",
						context.ovirtEngineDbDriverClass);

				parentContextMap_tRunJob_2.put("ovirtEngineDbJdbcConnection",
						context.ovirtEngineDbJdbcConnection);

				parentContextMap_tRunJob_2.put("ovirtEngineDbPassword",
						context.ovirtEngineDbPassword);

				parentContextMap_tRunJob_2.put("ovirtEngineDbUser",
						context.ovirtEngineDbUser);

				parentContextMap_tRunJob_2.put(
						"ovirtEngineHistoryDbDriverClass",
						context.ovirtEngineHistoryDbDriverClass);

				parentContextMap_tRunJob_2.put(
						"ovirtEngineHistoryDbJdbcConnection",
						context.ovirtEngineHistoryDbJdbcConnection);

				parentContextMap_tRunJob_2.put("ovirtEngineHistoryDbPassword",
						context.ovirtEngineHistoryDbPassword);

				parentContextMap_tRunJob_2.put("ovirtEngineHistoryDbUser",
						context.ovirtEngineHistoryDbUser);

				parentContextMap_tRunJob_2.put("runDeleteTime",
						context.runDeleteTime);

				parentContextMap_tRunJob_2.put("runInterleave",
						context.runInterleave);

				parentContextMap_tRunJob_2.put("timeBetweenErrorEvents",
						context.timeBetweenErrorEvents);

				Object obj_tRunJob_2 = null;

				ovirt_engine_dwh.minimalversioncheck_3_6.MinimalVersionCheck childJob_tRunJob_2 = new ovirt_engine_dwh.minimalversioncheck_3_6.MinimalVersionCheck();
				// pass DataSources
				java.util.Map<String, routines.system.TalendDataSource> talendDataSources_tRunJob_2 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
						.get(KEY_DB_DATASOURCES);
				if (null != talendDataSources_tRunJob_2) {
					java.util.Map<String, javax.sql.DataSource> dataSources_tRunJob_2 = new java.util.HashMap<String, javax.sql.DataSource>();
					for (java.util.Map.Entry<String, routines.system.TalendDataSource> talendDataSourceEntry_tRunJob_2 : talendDataSources_tRunJob_2
							.entrySet()) {
						dataSources_tRunJob_2.put(
								talendDataSourceEntry_tRunJob_2.getKey(),
								talendDataSourceEntry_tRunJob_2.getValue()
										.getRawDataSource());
					}
					childJob_tRunJob_2.setDataSources(dataSources_tRunJob_2);
				}

				childJob_tRunJob_2.parentContextMap = parentContextMap_tRunJob_2;

				String[][] childReturn_tRunJob_2 = childJob_tRunJob_2
						.runJob((String[]) paraList_tRunJob_2
								.toArray(new String[paraList_tRunJob_2.size()]));

				((java.util.Map) threadLocal.get()).put("errorCode",
						childJob_tRunJob_2.getErrorCode());

				if (childJob_tRunJob_2.getErrorCode() == null) {
					globalMap.put(
							"tRunJob_2_CHILD_RETURN_CODE",
							childJob_tRunJob_2.getStatus() != null
									&& ("failure").equals(childJob_tRunJob_2
											.getStatus()) ? 1 : 0);
				} else {
					globalMap.put("tRunJob_2_CHILD_RETURN_CODE",
							childJob_tRunJob_2.getErrorCode());
				}
				if (childJob_tRunJob_2.getExceptionStackTrace() != null) {
					globalMap.put("tRunJob_2_CHILD_EXCEPTION_STACKTRACE",
							childJob_tRunJob_2.getExceptionStackTrace());
				}

				if (childJob_tRunJob_2.getErrorCode() != null
						|| ("failure").equals(childJob_tRunJob_2.getStatus())) {
					throw new RuntimeException("Child job running failed");
				}

				tos_count_tRunJob_2++;

				/**
				 * [tRunJob_2 main ] stop
				 */

				/**
				 * [tRunJob_2 end ] start
				 */

				currentComponent = "tRunJob_2";

				ok_Hash.put("tRunJob_2", true);
				end_Hash.put("tRunJob_2", System.currentTimeMillis());

				/**
				 * [tRunJob_2 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRunJob_2 finally ] start
				 */

				currentComponent = "tRunJob_2";

				/**
				 * [tRunJob_2 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRunJob_2_SUBPROCESS_STATE", 1);
	}

	public static class event_outputStruct implements
			routines.system.IPersistableRow<event_outputStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public java.util.Date log_time;

		public java.util.Date getLog_time() {
			return this.log_time;
		}

		public String log_type_name;

		public String getLog_type_name() {
			return this.log_type_name;
		}

		public int log_type;

		public int getLog_type() {
			return this.log_type;
		}

		public int severity;

		public int getSeverity() {
			return this.severity;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.log_time = readDate(dis);

					this.log_type_name = readString(dis);

					this.log_type = dis.readInt();

					this.severity = dis.readInt();

					this.message = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.log_time, dos);

				// String

				writeString(this.log_type_name, dos);

				// int

				dos.writeInt(this.log_type);

				// int

				dos.writeInt(this.severity);

				// String

				writeString(this.message, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("log_time=" + String.valueOf(log_time));
			sb.append(",log_type_name=" + log_type_name);
			sb.append(",log_type=" + String.valueOf(log_type));
			sb.append(",severity=" + String.valueOf(severity));
			sb.append(",message=" + message);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(event_outputStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public static class row5Struct implements
			routines.system.IPersistableRow<row5Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row5Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tLogCatcher_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tLogCatcher_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row5Struct row5 = new row5Struct();
				event_outputStruct event_output = new event_outputStruct();

				/**
				 * [tJDBCOutput_1 begin ] start
				 */

				ok_Hash.put("tJDBCOutput_1", false);
				start_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				currentComponent = "tJDBCOutput_1";

				int tos_count_tJDBCOutput_1 = 0;

				int nb_line_tJDBCOutput_1 = 0;
				int nb_line_update_tJDBCOutput_1 = 0;
				int nb_line_inserted_tJDBCOutput_1 = 0;
				int nb_line_deleted_tJDBCOutput_1 = 0;
				int nb_line_rejected_tJDBCOutput_1 = 0;

				int tmp_batchUpdateCount_tJDBCOutput_1 = 0;

				int deletedCount_tJDBCOutput_1 = 0;
				int updatedCount_tJDBCOutput_1 = 0;
				int insertedCount_tJDBCOutput_1 = 0;
				int rejectedCount_tJDBCOutput_1 = 0;

				boolean whetherReject_tJDBCOutput_1 = false;

				java.sql.Connection connection_tJDBCOutput_1 = (java.sql.Connection) globalMap
						.get("conn_tJDBCConnection_7");
				int batchSize_tJDBCOutput_1 = 10000;
				int batchSizeCounter_tJDBCOutput_1 = 0;

				String insert_tJDBCOutput_1 = "INSERT INTO "
						+ "audit_log"
						+ " (log_time,log_type_name,log_type,severity,message) VALUES (?,?,?,?,?)";
				java.sql.PreparedStatement pstmt_tJDBCOutput_1 = connection_tJDBCOutput_1
						.prepareStatement(insert_tJDBCOutput_1);

				/**
				 * [tJDBCOutput_1 begin ] stop
				 */

				/**
				 * [tMap_1 begin ] start
				 */

				ok_Hash.put("tMap_1", false);
				start_Hash.put("tMap_1", System.currentTimeMillis());

				currentComponent = "tMap_1";

				int tos_count_tMap_1 = 0;

				// ###############################
				// # Lookup's keys initialization
				// ###############################

				// ###############################
				// # Vars initialization
				class Var__tMap_1__Struct {
				}
				Var__tMap_1__Struct Var__tMap_1 = new Var__tMap_1__Struct();
				// ###############################

				// ###############################
				// # Outputs initialization
				event_outputStruct event_output_tmp = new event_outputStruct();
				// ###############################

				/**
				 * [tMap_1 begin ] stop
				 */

				/**
				 * [tLogCatcher_1 begin ] start
				 */

				ok_Hash.put("tLogCatcher_1", false);
				start_Hash.put("tLogCatcher_1", System.currentTimeMillis());

				currentComponent = "tLogCatcher_1";

				int tos_count_tLogCatcher_1 = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : tLogCatcher_1
						.getMessages()) {
					row5.type = lcm.getType();
					row5.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row5.priority = lcm.getPriority();
					row5.message = lcm.getMessage();
					row5.code = lcm.getCode();

					row5.moment = java.util.Calendar.getInstance().getTime();

					row5.pid = pid;
					row5.root_pid = rootPid;
					row5.father_pid = fatherPid;

					row5.project = projectName;
					row5.job = jobName;
					row5.context = contextStr;

					/**
					 * [tLogCatcher_1 begin ] stop
					 */

					/**
					 * [tLogCatcher_1 main ] start
					 */

					currentComponent = "tLogCatcher_1";

					tos_count_tLogCatcher_1++;

					/**
					 * [tLogCatcher_1 main ] stop
					 */

					/**
					 * [tMap_1 main ] start
					 */

					currentComponent = "tMap_1";

					boolean hasCasePrimitiveKeyWithNull_tMap_1 = false;

					// ###############################
					// # Input tables (lookups)
					boolean rejectedInnerJoin_tMap_1 = false;
					boolean mainRowRejected_tMap_1 = false;

					// ###############################
					{ // start of Var scope

						// ###############################
						// # Vars tables

						Var__tMap_1__Struct Var = Var__tMap_1;// ###############################
						// ###############################
						// # Output tables

						event_output = null;

						// # Output table : 'event_output'
						event_output_tmp.log_time = row5.moment;
						event_output_tmp.log_type_name = "DWH_ERROR";
						event_output_tmp.log_type = 9704;
						event_output_tmp.severity = 2;
						event_output_tmp.message = "ETL service start has encountered an error. Please consult the service log for more details.";
						event_output = event_output_tmp;
						// ###############################

					} // end of Var scope

					rejectedInnerJoin_tMap_1 = false;

					tos_count_tMap_1++;

					/**
					 * [tMap_1 main ] stop
					 */
					// Start of branch "event_output"
					if (event_output != null) {

						/**
						 * [tJDBCOutput_1 main ] start
						 */

						currentComponent = "tJDBCOutput_1";

						whetherReject_tJDBCOutput_1 = false;
						if (event_output.log_time != null) {
							pstmt_tJDBCOutput_1.setTimestamp(1,
									new java.sql.Timestamp(
											event_output.log_time.getTime()));
						} else {
							pstmt_tJDBCOutput_1.setNull(1, java.sql.Types.DATE);
						}

						if (event_output.log_type_name == null) {
							pstmt_tJDBCOutput_1.setNull(2,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_1.setString(2,
									event_output.log_type_name);
						}

						pstmt_tJDBCOutput_1.setInt(3, event_output.log_type);

						pstmt_tJDBCOutput_1.setInt(4, event_output.severity);

						if (event_output.message == null) {
							pstmt_tJDBCOutput_1.setNull(5,
									java.sql.Types.VARCHAR);
						} else {
							pstmt_tJDBCOutput_1.setString(5,
									event_output.message);
						}

						try {
							insertedCount_tJDBCOutput_1 = insertedCount_tJDBCOutput_1
									+ pstmt_tJDBCOutput_1.executeUpdate();
							nb_line_tJDBCOutput_1++;
						} catch (java.lang.Exception e) {
							whetherReject_tJDBCOutput_1 = true;
							throw (e);
						}

						tos_count_tJDBCOutput_1++;

						/**
						 * [tJDBCOutput_1 main ] stop
						 */

					} // End of branch "event_output"

					/**
					 * [tLogCatcher_1 end ] start
					 */

					currentComponent = "tLogCatcher_1";

				}

				ok_Hash.put("tLogCatcher_1", true);
				end_Hash.put("tLogCatcher_1", System.currentTimeMillis());

				/**
				 * [tLogCatcher_1 end ] stop
				 */

				/**
				 * [tMap_1 end ] start
				 */

				currentComponent = "tMap_1";

				// ###############################
				// # Lookup hashes releasing
				// ###############################

				ok_Hash.put("tMap_1", true);
				end_Hash.put("tMap_1", System.currentTimeMillis());

				/**
				 * [tMap_1 end ] stop
				 */

				/**
				 * [tJDBCOutput_1 end ] start
				 */

				currentComponent = "tJDBCOutput_1";

				if (pstmt_tJDBCOutput_1 != null) {

					pstmt_tJDBCOutput_1.close();

				}

				nb_line_deleted_tJDBCOutput_1 = nb_line_deleted_tJDBCOutput_1
						+ deletedCount_tJDBCOutput_1;
				nb_line_update_tJDBCOutput_1 = nb_line_update_tJDBCOutput_1
						+ updatedCount_tJDBCOutput_1;
				nb_line_inserted_tJDBCOutput_1 = nb_line_inserted_tJDBCOutput_1
						+ insertedCount_tJDBCOutput_1;
				nb_line_rejected_tJDBCOutput_1 = nb_line_rejected_tJDBCOutput_1
						+ rejectedCount_tJDBCOutput_1;

				globalMap.put("tJDBCOutput_1_NB_LINE", nb_line_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_UPDATED",
						nb_line_update_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_INSERTED",
						nb_line_inserted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_DELETED",
						nb_line_deleted_tJDBCOutput_1);
				globalMap.put("tJDBCOutput_1_NB_LINE_REJECTED",
						nb_line_rejected_tJDBCOutput_1);

				ok_Hash.put("tJDBCOutput_1", true);
				end_Hash.put("tJDBCOutput_1", System.currentTimeMillis());

				/**
				 * [tJDBCOutput_1 end ] stop
				 */

			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tLogCatcher_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tJava_4Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tLogCatcher_1 finally ] start
				 */

				currentComponent = "tLogCatcher_1";

				/**
				 * [tLogCatcher_1 finally ] stop
				 */

				/**
				 * [tMap_1 finally ] start
				 */

				currentComponent = "tMap_1";

				/**
				 * [tMap_1 finally ] stop
				 */

				/**
				 * [tJDBCOutput_1 finally ] start
				 */

				currentComponent = "tJDBCOutput_1";

				/**
				 * [tJDBCOutput_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tLogCatcher_1_SUBPROCESS_STATE", 1);
	}

	public void tJava_4Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJava_4_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJava_4 begin ] start
				 */

				ok_Hash.put("tJava_4", false);
				start_Hash.put("tJava_4", System.currentTimeMillis());

				currentComponent = "tJava_4";

				int tos_count_tJava_4 = 0;

				while (runningThreadCount.getCount() > 0) {
					runningThreadCount.add(-1);
				}

				/**
				 * [tJava_4 begin ] stop
				 */

				/**
				 * [tJava_4 main ] start
				 */

				currentComponent = "tJava_4";

				tos_count_tJava_4++;

				/**
				 * [tJava_4 main ] stop
				 */

				/**
				 * [tJava_4 end ] start
				 */

				currentComponent = "tJava_4";

				ok_Hash.put("tJava_4", true);
				end_Hash.put("tJava_4", System.currentTimeMillis());

				/**
				 * [tJava_4 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJava_4 finally ] start
				 */

				currentComponent = "tJava_4";

				/**
				 * [tJava_4 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJava_4_SUBPROCESS_STATE", 1);
	}

	public void tLoop_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tLoop_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tLoop_1 begin ] start
				 */

				ok_Hash.put("tLoop_1", false);
				start_Hash.put("tLoop_1", System.currentTimeMillis());

				currentComponent = "tLoop_1";

				int tos_count_tLoop_1 = 0;

				int current_iteration_tLoop_1 = 0;

				;

				while (!org.ovirt.engine.dwh.etltermination.Termination
						.getInstance().shouldTerminate()) {

					current_iteration_tLoop_1++;
					globalMap.put("tLoop_1_CURRENT_ITERATION",
							current_iteration_tLoop_1);

					/**
					 * [tLoop_1 begin ] stop
					 */

					/**
					 * [tLoop_1 main ] start
					 */

					currentComponent = "tLoop_1";

					tos_count_tLoop_1++;

					/**
					 * [tLoop_1 main ] stop
					 */

					/**
					 * [tLoop_1 end ] start
					 */

					currentComponent = "tLoop_1";

					Thread.sleep(4000);
					;

				}

				ok_Hash.put("tLoop_1", true);
				end_Hash.put("tLoop_1", System.currentTimeMillis());

				/**
				 * [tLoop_1 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tLoop_1:OnSubjobOk", "", Thread
								.currentThread().getId() + "", "", "", "", "",
						"");
			}

			tJava_1Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tLoop_1 finally ] start
				 */

				currentComponent = "tLoop_1";

				/**
				 * [tLoop_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tLoop_1_SUBPROCESS_STATE", 1);
	}

	public void tJava_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJava_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJava_1 begin ] start
				 */

				ok_Hash.put("tJava_1", false);
				start_Hash.put("tJava_1", System.currentTimeMillis());

				currentComponent = "tJava_1";

				int tos_count_tJava_1 = 0;

				while (runningThreadCount.getCount() > 0) {
					runningThreadCount.add(-1);
				}

				/**
				 * [tJava_1 begin ] stop
				 */

				/**
				 * [tJava_1 main ] start
				 */

				currentComponent = "tJava_1";

				tos_count_tJava_1++;

				/**
				 * [tJava_1 main ] stop
				 */

				/**
				 * [tJava_1 end ] start
				 */

				currentComponent = "tJava_1";

				ok_Hash.put("tJava_1", true);
				end_Hash.put("tJava_1", System.currentTimeMillis());

				/**
				 * [tJava_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJava_1 finally ] start
				 */

				currentComponent = "tJava_1";

				/**
				 * [tJava_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJava_1_SUBPROCESS_STATE", 1);
	}

	public void tRunJob_1Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tRunJob_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tRunJob_1 begin ] start
				 */

				ok_Hash.put("tRunJob_1", false);
				start_Hash.put("tRunJob_1", System.currentTimeMillis());

				currentComponent = "tRunJob_1";

				int tos_count_tRunJob_1 = 0;

				/**
				 * [tRunJob_1 begin ] stop
				 */

				/**
				 * [tRunJob_1 main ] start
				 */

				currentComponent = "tRunJob_1";

				java.util.List<String> paraList_tRunJob_1 = new java.util.ArrayList<String>();

				paraList_tRunJob_1.add("--father_pid=" + pid);

				paraList_tRunJob_1.add("--root_pid=" + rootPid);

				paraList_tRunJob_1.add("--father_node=tRunJob_1");

				paraList_tRunJob_1.add("--context=Default");

				// for feature:10589

				paraList_tRunJob_1.add("--stat_port=" + portStats);

				if (resuming_logs_dir_path != null) {
					paraList_tRunJob_1.add("--resuming_logs_dir_path="
							+ resuming_logs_dir_path);
				}
				String childResumePath_tRunJob_1 = ResumeUtil
						.getChildJobCheckPointPath(resuming_checkpoint_path);
				String tRunJobName_tRunJob_1 = ResumeUtil
						.getRighttRunJob(resuming_checkpoint_path);
				if ("tRunJob_1".equals(tRunJobName_tRunJob_1)
						&& childResumePath_tRunJob_1 != null) {
					paraList_tRunJob_1
							.add("--resuming_checkpoint_path="
									+ ResumeUtil
											.getChildJobCheckPointPath(resuming_checkpoint_path));
				}
				paraList_tRunJob_1.add("--parent_part_launcher=JOB:" + jobName
						+ "/NODE:tRunJob_1");

				java.util.Map<String, Object> parentContextMap_tRunJob_1 = new java.util.HashMap<String, Object>();

				context.synchronizeContext();
				java.util.Enumeration<?> propertyNames_tRunJob_1 = context
						.propertyNames();
				while (propertyNames_tRunJob_1.hasMoreElements()) {
					String key_tRunJob_1 = (String) propertyNames_tRunJob_1
							.nextElement();
					Object value_tRunJob_1 = (Object) context
							.get(key_tRunJob_1);
					paraList_tRunJob_1.add("--context_param " + key_tRunJob_1
							+ "=" + value_tRunJob_1);
				}

				parentContextMap_tRunJob_1.put("dwhUuid", context.dwhUuid);

				parentContextMap_tRunJob_1
						.put("etlVersion", context.etlVersion);

				parentContextMap_tRunJob_1.put("hoursToKeepDaily",
						context.hoursToKeepDaily);

				parentContextMap_tRunJob_1.put("hoursToKeepHourly",
						context.hoursToKeepHourly);

				parentContextMap_tRunJob_1.put("hoursToKeepSamples",
						context.hoursToKeepSamples);

				parentContextMap_tRunJob_1.put("lastErrorSent",
						context.lastErrorSent);

				parentContextMap_tRunJob_1.put("ovirtEngineDbDriverClass",
						context.ovirtEngineDbDriverClass);

				parentContextMap_tRunJob_1.put("ovirtEngineDbJdbcConnection",
						context.ovirtEngineDbJdbcConnection);

				parentContextMap_tRunJob_1.put("ovirtEngineDbPassword",
						context.ovirtEngineDbPassword);

				parentContextMap_tRunJob_1.put("ovirtEngineDbUser",
						context.ovirtEngineDbUser);

				parentContextMap_tRunJob_1.put(
						"ovirtEngineHistoryDbDriverClass",
						context.ovirtEngineHistoryDbDriverClass);

				parentContextMap_tRunJob_1.put(
						"ovirtEngineHistoryDbJdbcConnection",
						context.ovirtEngineHistoryDbJdbcConnection);

				parentContextMap_tRunJob_1.put("ovirtEngineHistoryDbPassword",
						context.ovirtEngineHistoryDbPassword);

				parentContextMap_tRunJob_1.put("ovirtEngineHistoryDbUser",
						context.ovirtEngineHistoryDbUser);

				parentContextMap_tRunJob_1.put("runDeleteTime",
						context.runDeleteTime);

				parentContextMap_tRunJob_1.put("runInterleave",
						context.runInterleave);

				parentContextMap_tRunJob_1.put("timeBetweenErrorEvents",
						context.timeBetweenErrorEvents);

				Object obj_tRunJob_1 = null;

				ovirt_engine_dwh.validateinstallation_3_6.ValidateInstallation childJob_tRunJob_1 = new ovirt_engine_dwh.validateinstallation_3_6.ValidateInstallation();
				// pass DataSources
				java.util.Map<String, routines.system.TalendDataSource> talendDataSources_tRunJob_1 = (java.util.Map<String, routines.system.TalendDataSource>) globalMap
						.get(KEY_DB_DATASOURCES);
				if (null != talendDataSources_tRunJob_1) {
					java.util.Map<String, javax.sql.DataSource> dataSources_tRunJob_1 = new java.util.HashMap<String, javax.sql.DataSource>();
					for (java.util.Map.Entry<String, routines.system.TalendDataSource> talendDataSourceEntry_tRunJob_1 : talendDataSources_tRunJob_1
							.entrySet()) {
						dataSources_tRunJob_1.put(
								talendDataSourceEntry_tRunJob_1.getKey(),
								talendDataSourceEntry_tRunJob_1.getValue()
										.getRawDataSource());
					}
					childJob_tRunJob_1.setDataSources(dataSources_tRunJob_1);
				}

				childJob_tRunJob_1.parentContextMap = parentContextMap_tRunJob_1;

				String[][] childReturn_tRunJob_1 = childJob_tRunJob_1
						.runJob((String[]) paraList_tRunJob_1
								.toArray(new String[paraList_tRunJob_1.size()]));

				((java.util.Map) threadLocal.get()).put("errorCode",
						childJob_tRunJob_1.getErrorCode());

				if (childJob_tRunJob_1.getErrorCode() == null) {
					globalMap.put(
							"tRunJob_1_CHILD_RETURN_CODE",
							childJob_tRunJob_1.getStatus() != null
									&& ("failure").equals(childJob_tRunJob_1
											.getStatus()) ? 1 : 0);
				} else {
					globalMap.put("tRunJob_1_CHILD_RETURN_CODE",
							childJob_tRunJob_1.getErrorCode());
				}
				if (childJob_tRunJob_1.getExceptionStackTrace() != null) {
					globalMap.put("tRunJob_1_CHILD_EXCEPTION_STACKTRACE",
							childJob_tRunJob_1.getExceptionStackTrace());
				}

				if (childJob_tRunJob_1.getErrorCode() != null
						|| ("failure").equals(childJob_tRunJob_1.getStatus())) {
					throw new RuntimeException("Child job running failed");
				}

				tos_count_tRunJob_1++;

				/**
				 * [tRunJob_1 main ] stop
				 */

				/**
				 * [tRunJob_1 end ] start
				 */

				currentComponent = "tRunJob_1";

				ok_Hash.put("tRunJob_1", true);
				end_Hash.put("tRunJob_1", System.currentTimeMillis());

				/**
				 * [tRunJob_1 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tRunJob_1 finally ] start
				 */

				currentComponent = "tRunJob_1";

				/**
				 * [tRunJob_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tRunJob_1_SUBPROCESS_STATE", 1);
	}

	public void tSetGlobalVar_1Process(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tSetGlobalVar_1_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tSetGlobalVar_1 begin ] start
				 */

				ok_Hash.put("tSetGlobalVar_1", false);
				start_Hash.put("tSetGlobalVar_1", System.currentTimeMillis());

				currentComponent = "tSetGlobalVar_1";

				int tos_count_tSetGlobalVar_1 = 0;

				/**
				 * [tSetGlobalVar_1 begin ] stop
				 */

				/**
				 * [tSetGlobalVar_1 main ] start
				 */

				currentComponent = "tSetGlobalVar_1";

				globalMap.put("timesDisconnectDwhFailed", "0");

				tos_count_tSetGlobalVar_1++;

				/**
				 * [tSetGlobalVar_1 main ] stop
				 */

				/**
				 * [tSetGlobalVar_1 end ] start
				 */

				currentComponent = "tSetGlobalVar_1";

				ok_Hash.put("tSetGlobalVar_1", true);
				end_Hash.put("tSetGlobalVar_1", System.currentTimeMillis());

				/**
				 * [tSetGlobalVar_1 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil
						.addLog("CHECKPOINT",
								"CONNECTION:SUBJOB_OK:tSetGlobalVar_1:OnSubjobOk",
								"", Thread.currentThread().getId() + "", "",
								"", "", "", "");
			}

			tLoop_2Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tSetGlobalVar_1 finally ] start
				 */

				currentComponent = "tSetGlobalVar_1";

				/**
				 * [tSetGlobalVar_1 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tSetGlobalVar_1_SUBPROCESS_STATE", 1);
	}

	public static class row9Struct implements
			routines.system.IPersistableRow<row9Struct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public String option_value;

		public String getOption_value() {
			return this.option_value;
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.option_value = readString(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// String

				writeString(this.option_value, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("option_value=" + option_value);
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row9Struct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void tLoop_2Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tLoop_2_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row9Struct row9 = new row9Struct();

				/**
				 * [tLoop_2 begin ] start
				 */

				int NB_ITERATE_tJavaFlex_1 = 0; // for statistics

				int NB_ITERATE_tJavaFlex_2 = 0; // for statistics

				ok_Hash.put("tLoop_2", false);
				start_Hash.put("tLoop_2", System.currentTimeMillis());

				currentComponent = "tLoop_2";

				int tos_count_tLoop_2 = 0;

				int current_iteration_tLoop_2 = 0;

				boolean i = false;

				while (!i) {

					current_iteration_tLoop_2++;
					globalMap.put("tLoop_2_CURRENT_ITERATION",
							current_iteration_tLoop_2);

					/**
					 * [tLoop_2 begin ] stop
					 */

					/**
					 * [tLoop_2 main ] start
					 */

					currentComponent = "tLoop_2";

					tos_count_tLoop_2++;

					/**
					 * [tLoop_2 main ] stop
					 */
					NB_ITERATE_tJavaFlex_2++;

					/**
					 * [tJavaFlex_2 begin ] start
					 */

					int NB_ITERATE_tJDBCConnection_7 = 0; // for statistics

					ok_Hash.put("tJavaFlex_2", false);
					start_Hash.put("tJavaFlex_2", System.currentTimeMillis());

					currentComponent = "tJavaFlex_2";

					int tos_count_tJavaFlex_2 = 0;

					// start part of your Java code
					try {

						/**
						 * [tJavaFlex_2 begin ] stop
						 */

						/**
						 * [tJavaFlex_2 main ] start
						 */

						currentComponent = "tJavaFlex_2";

						// here is the main part of the component,
						// a piece of code executed in the row
						// loop

						tos_count_tJavaFlex_2++;

						/**
						 * [tJavaFlex_2 main ] stop
						 */
						NB_ITERATE_tJDBCConnection_7++;

						/**
						 * [tJDBCConnection_7 begin ] start
						 */

						ok_Hash.put("tJDBCConnection_7", false);
						start_Hash.put("tJDBCConnection_7",
								System.currentTimeMillis());

						currentComponent = "tJDBCConnection_7";

						int tos_count_tJDBCConnection_7 = 0;

						String url_tJDBCConnection_7 = context.ovirtEngineDbJdbcConnection;

						String dbUser_tJDBCConnection_7 = context.ovirtEngineDbUser;

						final String decryptedPassword_tJDBCConnection_7 = context.ovirtEngineDbPassword;
						String dbPwd_tJDBCConnection_7 = decryptedPassword_tJDBCConnection_7;

						java.sql.Connection conn_tJDBCConnection_7 = null;

						String sharedConnectionName_tJDBCConnection_7 = "engine-events";
						conn_tJDBCConnection_7 = SharedDBConnection
								.getDBConnection(
										context.ovirtEngineDbDriverClass,
										url_tJDBCConnection_7,
										dbUser_tJDBCConnection_7,
										dbPwd_tJDBCConnection_7,
										sharedConnectionName_tJDBCConnection_7);
						if (null != conn_tJDBCConnection_7) {

							conn_tJDBCConnection_7.setAutoCommit(true);
						}

						globalMap.put("conn_tJDBCConnection_7",
								conn_tJDBCConnection_7);
						globalMap.put("url_tJDBCConnection_7",
								url_tJDBCConnection_7);
						// globalMap.put("user_tJDBCConnection_7",
						// dbUser_tJDBCConnection_7);
						// globalMap.put("pass_tJDBCConnection_7",
						// dbPwd_tJDBCConnection_7);

						/**
						 * [tJDBCConnection_7 begin ] stop
						 */

						/**
						 * [tJDBCConnection_7 main ] start
						 */

						currentComponent = "tJDBCConnection_7";

						tos_count_tJDBCConnection_7++;

						/**
						 * [tJDBCConnection_7 main ] stop
						 */

						/**
						 * [tJDBCConnection_7 end ] start
						 */

						currentComponent = "tJDBCConnection_7";

						ok_Hash.put("tJDBCConnection_7", true);
						end_Hash.put("tJDBCConnection_7",
								System.currentTimeMillis());

						/**
						 * [tJDBCConnection_7 end ] stop
						 */

						/**
						 * [tJavaFlex_2 end ] start
						 */

						currentComponent = "tJavaFlex_2";

						// end of the component, outside/closing the loop
					} catch (Exception e) {
						// this will only happen in db
						// connection error and loop should recover
						int TimesDisconnectDwhFailed = Integer
								.parseInt(((String) globalMap
										.get("timesDisconnectDwhFailed")));
						if ((TimesDisconnectDwhFailed % 10) == 0) {
							globalMap.put("timesDisconnectDwhFailed", Integer
									.valueOf(TimesDisconnectDwhFailed + 1)
									.toString());
							System.out.println(TalendDate
									.getDate("CCYY-MM-DD hh:mm:ss")
									+ " |Exception in component tJavaFlex_6: "
									+ e.toString() + " has been caught");
						} else {
							globalMap.put("timesDisconnectDwhFailed", Integer
									.valueOf(TimesDisconnectDwhFailed + 1)
									.toString());
						}
					}

					ok_Hash.put("tJavaFlex_2", true);
					end_Hash.put("tJavaFlex_2", System.currentTimeMillis());

					/**
					 * [tJavaFlex_2 end ] stop
					 */

					NB_ITERATE_tJavaFlex_1++;

					/**
					 * [tJavaFlex_1 begin ] start
					 */

					int NB_ITERATE_tJDBCInput_1 = 0; // for statistics

					ok_Hash.put("tJavaFlex_1", false);
					start_Hash.put("tJavaFlex_1", System.currentTimeMillis());

					currentComponent = "tJavaFlex_1";

					int tos_count_tJavaFlex_1 = 0;

					// start part of your Java code
					try {

						/**
						 * [tJavaFlex_1 begin ] stop
						 */

						/**
						 * [tJavaFlex_1 main ] start
						 */

						currentComponent = "tJavaFlex_1";

						// here is the main part of the component,
						// a piece of code executed in the row
						// loop

						tos_count_tJavaFlex_1++;

						/**
						 * [tJavaFlex_1 main ] stop
						 */
						NB_ITERATE_tJDBCInput_1++;

						/**
						 * [tJavaRow_1 begin ] start
						 */

						ok_Hash.put("tJavaRow_1", false);
						start_Hash
								.put("tJavaRow_1", System.currentTimeMillis());

						currentComponent = "tJavaRow_1";

						int tos_count_tJavaRow_1 = 0;

						int nb_line_tJavaRow_1 = 0;

						/**
						 * [tJavaRow_1 begin ] stop
						 */

						/**
						 * [tJDBCInput_1 begin ] start
						 */

						ok_Hash.put("tJDBCInput_1", false);
						start_Hash.put("tJDBCInput_1",
								System.currentTimeMillis());

						currentComponent = "tJDBCInput_1";

						int tos_count_tJDBCInput_1 = 0;

						int nb_line_tJDBCInput_1 = 0;
						java.sql.Connection conn_tJDBCInput_1 = null;
						conn_tJDBCInput_1 = (java.sql.Connection) globalMap
								.get("conn_tJDBCConnection_7");

						java.sql.Statement stmt_tJDBCInput_1 = conn_tJDBCInput_1
								.createStatement();

						String dbquery_tJDBCInput_1 = "SELECT option_value FROM vdc_options WHERE option_name = 'DisconnectDwh'";

						globalMap.put("tJDBCInput_1_QUERY",
								dbquery_tJDBCInput_1);
						java.sql.ResultSet rs_tJDBCInput_1 = null;
						try {
							rs_tJDBCInput_1 = stmt_tJDBCInput_1
									.executeQuery(dbquery_tJDBCInput_1);
							java.sql.ResultSetMetaData rsmd_tJDBCInput_1 = rs_tJDBCInput_1
									.getMetaData();
							int colQtyInRs_tJDBCInput_1 = rsmd_tJDBCInput_1
									.getColumnCount();

							String tmpContent_tJDBCInput_1 = null;

							while (rs_tJDBCInput_1.next()) {
								nb_line_tJDBCInput_1++;

								if (colQtyInRs_tJDBCInput_1 < 1) {
									row9.option_value = null;
								} else {

									tmpContent_tJDBCInput_1 = rs_tJDBCInput_1
											.getString(1);
									if (tmpContent_tJDBCInput_1 != null) {
										row9.option_value = tmpContent_tJDBCInput_1;
									} else {
										row9.option_value = null;
									}
								}

								/**
								 * [tJDBCInput_1 begin ] stop
								 */

								/**
								 * [tJDBCInput_1 main ] start
								 */

								currentComponent = "tJDBCInput_1";

								tos_count_tJDBCInput_1++;

								/**
								 * [tJDBCInput_1 main ] stop
								 */

								/**
								 * [tJavaRow_1 main ] start
								 */

								currentComponent = "tJavaRow_1";

								i = "1".equals(row9.option_value);
								if (i) {
									System.out
											.println("ETL Service will now stop because a flag was raised to disconnect DWH on Engine DB");
								}
								if (((String) globalMap
										.get("timesDisconnectDwhFailed")) != "0") {
									globalMap.put("timesDisconnectDwhFailed",
											"0");
								}
								nb_line_tJavaRow_1++;

								tos_count_tJavaRow_1++;

								/**
								 * [tJavaRow_1 main ] stop
								 */

								/**
								 * [tJDBCInput_1 end ] start
								 */

								currentComponent = "tJDBCInput_1";

							}
						} finally {
							if (rs_tJDBCInput_1 != null) {
								rs_tJDBCInput_1.close();
							}
							stmt_tJDBCInput_1.close();

						}
						globalMap.put("tJDBCInput_1_NB_LINE",
								nb_line_tJDBCInput_1);

						ok_Hash.put("tJDBCInput_1", true);
						end_Hash.put("tJDBCInput_1", System.currentTimeMillis());

						/**
						 * [tJDBCInput_1 end ] stop
						 */

						/**
						 * [tJavaRow_1 end ] start
						 */

						currentComponent = "tJavaRow_1";

						globalMap.put("tJavaRow_1_NB_LINE", nb_line_tJavaRow_1);

						ok_Hash.put("tJavaRow_1", true);
						end_Hash.put("tJavaRow_1", System.currentTimeMillis());

						/**
						 * [tJavaRow_1 end ] stop
						 */

						/**
						 * [tJavaFlex_1 end ] start
						 */

						currentComponent = "tJavaFlex_1";

						// end of the component, outside/closing the loop
					} catch (Exception e) {
						// this will only happen in db
						// connection error and loop should recover
					}

					ok_Hash.put("tJavaFlex_1", true);
					end_Hash.put("tJavaFlex_1", System.currentTimeMillis());

					/**
					 * [tJavaFlex_1 end ] stop
					 */

					/**
					 * [tLoop_2 end ] start
					 */

					currentComponent = "tLoop_2";

					Thread.sleep(4000);
					;

				}

				ok_Hash.put("tLoop_2", true);
				end_Hash.put("tLoop_2", System.currentTimeMillis());

				/**
				 * [tLoop_2 end ] stop
				 */
			}// end the resume

			if (resumeEntryMethodName == null || globalResumeTicket) {
				resumeUtil.addLog("CHECKPOINT",
						"CONNECTION:SUBJOB_OK:tLoop_2:OnSubjobOk", "", Thread
								.currentThread().getId() + "", "", "", "", "",
						"");
			}

			tJava_3Process(globalMap);

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tLoop_2 finally ] start
				 */

				currentComponent = "tLoop_2";

				/**
				 * [tLoop_2 finally ] stop
				 */

				/**
				 * [tJavaFlex_2 finally ] start
				 */

				currentComponent = "tJavaFlex_2";

				/**
				 * [tJavaFlex_2 finally ] stop
				 */

				/**
				 * [tJDBCConnection_7 finally ] start
				 */

				currentComponent = "tJDBCConnection_7";

				/**
				 * [tJDBCConnection_7 finally ] stop
				 */

				/**
				 * [tJavaFlex_1 finally ] start
				 */

				currentComponent = "tJavaFlex_1";

				/**
				 * [tJavaFlex_1 finally ] stop
				 */

				/**
				 * [tJDBCInput_1 finally ] start
				 */

				currentComponent = "tJDBCInput_1";

				/**
				 * [tJDBCInput_1 finally ] stop
				 */

				/**
				 * [tJavaRow_1 finally ] start
				 */

				currentComponent = "tJavaRow_1";

				/**
				 * [tJavaRow_1 finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tLoop_2_SUBPROCESS_STATE", 1);
	}

	public void tJava_3Process(final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("tJava_3_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				/**
				 * [tJava_3 begin ] start
				 */

				ok_Hash.put("tJava_3", false);
				start_Hash.put("tJava_3", System.currentTimeMillis());

				currentComponent = "tJava_3";

				int tos_count_tJava_3 = 0;

				while (runningThreadCount.getCount() > 0) {
					runningThreadCount.add(-1);
				}

				/**
				 * [tJava_3 begin ] stop
				 */

				/**
				 * [tJava_3 main ] start
				 */

				currentComponent = "tJava_3";

				tos_count_tJava_3++;

				/**
				 * [tJava_3 main ] stop
				 */

				/**
				 * [tJava_3 end ] start
				 */

				currentComponent = "tJava_3";

				ok_Hash.put("tJava_3", true);
				end_Hash.put("tJava_3", System.currentTimeMillis());

				/**
				 * [tJava_3 end ] stop
				 */
			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [tJava_3 finally ] start
				 */

				currentComponent = "tJava_3";

				/**
				 * [tJava_3 finally ] stop
				 */
			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("tJava_3_SUBPROCESS_STATE", 1);
	}

	public static class row_talendLogs_LOGSStruct implements
			routines.system.IPersistableRow<row_talendLogs_LOGSStruct> {
		final static byte[] commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];
		static byte[] commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[0];

		public java.util.Date moment;

		public java.util.Date getMoment() {
			return this.moment;
		}

		public String pid;

		public String getPid() {
			return this.pid;
		}

		public String root_pid;

		public String getRoot_pid() {
			return this.root_pid;
		}

		public String father_pid;

		public String getFather_pid() {
			return this.father_pid;
		}

		public String project;

		public String getProject() {
			return this.project;
		}

		public String job;

		public String getJob() {
			return this.job;
		}

		public String context;

		public String getContext() {
			return this.context;
		}

		public Integer priority;

		public Integer getPriority() {
			return this.priority;
		}

		public String type;

		public String getType() {
			return this.type;
		}

		public String origin;

		public String getOrigin() {
			return this.origin;
		}

		public String message;

		public String getMessage() {
			return this.message;
		}

		public Integer code;

		public Integer getCode() {
			return this.code;
		}

		private java.util.Date readDate(ObjectInputStream dis)
				throws IOException {
			java.util.Date dateReturn = null;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				dateReturn = null;
			} else {
				dateReturn = new Date(dis.readLong());
			}
			return dateReturn;
		}

		private void writeDate(java.util.Date date1, ObjectOutputStream dos)
				throws IOException {
			if (date1 == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeLong(date1.getTime());
			}
		}

		private String readString(ObjectInputStream dis) throws IOException {
			String strReturn = null;
			int length = 0;
			length = dis.readInt();
			if (length == -1) {
				strReturn = null;
			} else {
				if (length > commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length) {
					if (length < 1024
							&& commonByteArray_OVIRT_ENGINE_DWH_HistoryETL.length == 0) {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[1024];
					} else {
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL = new byte[2 * length];
					}
				}
				dis.readFully(commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0,
						length);
				strReturn = new String(
						commonByteArray_OVIRT_ENGINE_DWH_HistoryETL, 0, length,
						utf8Charset);
			}
			return strReturn;
		}

		private void writeString(String str, ObjectOutputStream dos)
				throws IOException {
			if (str == null) {
				dos.writeInt(-1);
			} else {
				byte[] byteArray = str.getBytes(utf8Charset);
				dos.writeInt(byteArray.length);
				dos.write(byteArray);
			}
		}

		private Integer readInteger(ObjectInputStream dis) throws IOException {
			Integer intReturn;
			int length = 0;
			length = dis.readByte();
			if (length == -1) {
				intReturn = null;
			} else {
				intReturn = dis.readInt();
			}
			return intReturn;
		}

		private void writeInteger(Integer intNum, ObjectOutputStream dos)
				throws IOException {
			if (intNum == null) {
				dos.writeByte(-1);
			} else {
				dos.writeByte(0);
				dos.writeInt(intNum);
			}
		}

		public void readData(ObjectInputStream dis) {

			synchronized (commonByteArrayLock_OVIRT_ENGINE_DWH_HistoryETL) {

				try {

					int length = 0;

					this.moment = readDate(dis);

					this.pid = readString(dis);

					this.root_pid = readString(dis);

					this.father_pid = readString(dis);

					this.project = readString(dis);

					this.job = readString(dis);

					this.context = readString(dis);

					this.priority = readInteger(dis);

					this.type = readString(dis);

					this.origin = readString(dis);

					this.message = readString(dis);

					this.code = readInteger(dis);

				} catch (IOException e) {
					throw new RuntimeException(e);

				}

			}

		}

		public void writeData(ObjectOutputStream dos) {
			try {

				// java.util.Date

				writeDate(this.moment, dos);

				// String

				writeString(this.pid, dos);

				// String

				writeString(this.root_pid, dos);

				// String

				writeString(this.father_pid, dos);

				// String

				writeString(this.project, dos);

				// String

				writeString(this.job, dos);

				// String

				writeString(this.context, dos);

				// Integer

				writeInteger(this.priority, dos);

				// String

				writeString(this.type, dos);

				// String

				writeString(this.origin, dos);

				// String

				writeString(this.message, dos);

				// Integer

				writeInteger(this.code, dos);

			} catch (IOException e) {
				throw new RuntimeException(e);
			}

		}

		public String toString() {

			StringBuilder sb = new StringBuilder();
			sb.append(super.toString());
			sb.append("[");
			sb.append("moment=" + String.valueOf(moment));
			sb.append(",pid=" + pid);
			sb.append(",root_pid=" + root_pid);
			sb.append(",father_pid=" + father_pid);
			sb.append(",project=" + project);
			sb.append(",job=" + job);
			sb.append(",context=" + context);
			sb.append(",priority=" + String.valueOf(priority));
			sb.append(",type=" + type);
			sb.append(",origin=" + origin);
			sb.append(",message=" + message);
			sb.append(",code=" + String.valueOf(code));
			sb.append("]");

			return sb.toString();
		}

		/**
		 * Compare keys
		 */
		public int compareTo(row_talendLogs_LOGSStruct other) {

			int returnValue = -1;

			return returnValue;
		}

		private int checkNullsAndCompare(Object object1, Object object2) {
			int returnValue = 0;
			if (object1 instanceof Comparable && object2 instanceof Comparable) {
				returnValue = ((Comparable) object1).compareTo(object2);
			} else if (object1 != null && object2 != null) {
				returnValue = compareStrings(object1.toString(),
						object2.toString());
			} else if (object1 == null && object2 != null) {
				returnValue = 1;
			} else if (object1 != null && object2 == null) {
				returnValue = -1;
			} else {
				returnValue = 0;
			}

			return returnValue;
		}

		private int compareStrings(String string1, String string2) {
			return string1.compareTo(string2);
		}

	}

	public void talendLogs_LOGSProcess(
			final java.util.Map<String, Object> globalMap)
			throws TalendException {
		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 0);

		final boolean execStat = this.execStat;
		String currentVirtualComponent = null;

		String iterateId = "";

		String currentComponent = "";
		java.util.Map<String, Object> resourceMap = new java.util.HashMap<String, Object>();

		try {

			String currentMethodName = new java.lang.Exception()
					.getStackTrace()[0].getMethodName();
			boolean resumeIt = currentMethodName.equals(resumeEntryMethodName);
			if (resumeEntryMethodName == null || resumeIt || globalResumeTicket) {// start
																					// the
																					// resume
				globalResumeTicket = true;

				row_talendLogs_LOGSStruct row_talendLogs_LOGS = new row_talendLogs_LOGSStruct();

				/**
				 * [talendLogs_CONSOLE begin ] start
				 */

				ok_Hash.put("talendLogs_CONSOLE", false);
				start_Hash
						.put("talendLogs_CONSOLE", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				int tos_count_talendLogs_CONSOLE = 0;

				// /////////////////////

				final String OUTPUT_FIELD_SEPARATOR_talendLogs_CONSOLE = "|";
				java.io.PrintStream consoleOut_talendLogs_CONSOLE = null;

				StringBuilder strBuffer_talendLogs_CONSOLE = null;
				int nb_line_talendLogs_CONSOLE = 0;
				// /////////////////////

				/**
				 * [talendLogs_CONSOLE begin ] stop
				 */

				/**
				 * [talendLogs_LOGS begin ] start
				 */

				ok_Hash.put("talendLogs_LOGS", false);
				start_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				int tos_count_talendLogs_LOGS = 0;

				for (LogCatcherUtils.LogCatcherMessage lcm : talendLogs_LOGS
						.getMessages()) {
					row_talendLogs_LOGS.type = lcm.getType();
					row_talendLogs_LOGS.origin = (lcm.getOrigin() == null
							|| lcm.getOrigin().length() < 1 ? null : lcm
							.getOrigin());
					row_talendLogs_LOGS.priority = lcm.getPriority();
					row_talendLogs_LOGS.message = lcm.getMessage();
					row_talendLogs_LOGS.code = lcm.getCode();

					row_talendLogs_LOGS.moment = java.util.Calendar
							.getInstance().getTime();

					row_talendLogs_LOGS.pid = pid;
					row_talendLogs_LOGS.root_pid = rootPid;
					row_talendLogs_LOGS.father_pid = fatherPid;

					row_talendLogs_LOGS.project = projectName;
					row_talendLogs_LOGS.job = jobName;
					row_talendLogs_LOGS.context = contextStr;

					/**
					 * [talendLogs_LOGS begin ] stop
					 */

					/**
					 * [talendLogs_LOGS main ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

					tos_count_talendLogs_LOGS++;

					/**
					 * [talendLogs_LOGS main ] stop
					 */

					/**
					 * [talendLogs_CONSOLE main ] start
					 */

					currentVirtualComponent = "talendLogs_CONSOLE";

					currentComponent = "talendLogs_CONSOLE";

					// /////////////////////

					strBuffer_talendLogs_CONSOLE = new StringBuilder();

					if (row_talendLogs_LOGS.moment != null) { //

						strBuffer_talendLogs_CONSOLE.append(FormatterUtils
								.format_Date(row_talendLogs_LOGS.moment,
										"yyyy-MM-dd HH:mm:ss"));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.root_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.root_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.father_pid != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.father_pid));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.project != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.project));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.job != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.job));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.context != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.context));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.priority != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.priority));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.type != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.type));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.origin != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.origin));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.message != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.message));

					} //

					strBuffer_talendLogs_CONSOLE.append("|");

					if (row_talendLogs_LOGS.code != null) { //

						strBuffer_talendLogs_CONSOLE.append(String
								.valueOf(row_talendLogs_LOGS.code));

					} //

					if (globalMap.get("tLogRow_CONSOLE") != null) {
						consoleOut_talendLogs_CONSOLE = (java.io.PrintStream) globalMap
								.get("tLogRow_CONSOLE");
					} else {
						consoleOut_talendLogs_CONSOLE = new java.io.PrintStream(
								new java.io.BufferedOutputStream(System.out));
						globalMap.put("tLogRow_CONSOLE",
								consoleOut_talendLogs_CONSOLE);
					}

					consoleOut_talendLogs_CONSOLE
							.println(strBuffer_talendLogs_CONSOLE.toString());
					consoleOut_talendLogs_CONSOLE.flush();
					nb_line_talendLogs_CONSOLE++;
					// ////

					// ////

					// /////////////////////

					tos_count_talendLogs_CONSOLE++;

					/**
					 * [talendLogs_CONSOLE main ] stop
					 */

					/**
					 * [talendLogs_LOGS end ] start
					 */

					currentVirtualComponent = "talendLogs_LOGS";

					currentComponent = "talendLogs_LOGS";

				}

				ok_Hash.put("talendLogs_LOGS", true);
				end_Hash.put("talendLogs_LOGS", System.currentTimeMillis());

				/**
				 * [talendLogs_LOGS end ] stop
				 */

				/**
				 * [talendLogs_CONSOLE end ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				// ////
				// ////
				globalMap.put("talendLogs_CONSOLE_NB_LINE",
						nb_line_talendLogs_CONSOLE);

				// /////////////////////

				ok_Hash.put("talendLogs_CONSOLE", true);
				end_Hash.put("talendLogs_CONSOLE", System.currentTimeMillis());

				/**
				 * [talendLogs_CONSOLE end ] stop
				 */

			}// end the resume

		} catch (java.lang.Exception e) {

			TalendException te = new TalendException(e, currentComponent,
					globalMap);

			te.setVirtualComponentName(currentVirtualComponent);

			throw te;
		} catch (java.lang.Error error) {

			throw error;
		} finally {

			try {

				/**
				 * [talendLogs_LOGS finally ] start
				 */

				currentVirtualComponent = "talendLogs_LOGS";

				currentComponent = "talendLogs_LOGS";

				/**
				 * [talendLogs_LOGS finally ] stop
				 */

				/**
				 * [talendLogs_CONSOLE finally ] start
				 */

				currentVirtualComponent = "talendLogs_CONSOLE";

				currentComponent = "talendLogs_CONSOLE";

				/**
				 * [talendLogs_CONSOLE finally ] stop
				 */

			} catch (java.lang.Exception e) {
				// ignore
			} catch (java.lang.Error error) {
				// ignore
			}
			resourceMap = null;
		}

		globalMap.put("talendLogs_LOGS_SUBPROCESS_STATE", 1);
	}

	public String resuming_logs_dir_path = null;
	public String resuming_checkpoint_path = null;
	public String parent_part_launcher = null;
	private String resumeEntryMethodName = null;
	private boolean globalResumeTicket = false;

	public boolean watch = false;
	// portStats is null, it means don't execute the statistics
	public Integer portStats = null;
	public int portTraces = 4334;
	public String clientHost;
	public String defaultClientHost = "localhost";
	public String contextStr = "Default";
	public boolean isDefaultContext = true;
	public String pid = "0";
	public String rootPid = null;
	public String fatherPid = null;
	public String fatherNode = null;
	public long startTime = 0;
	public boolean isChildJob = false;
	public String log4jLevel = "";

	private boolean execStat = true;

	private ThreadLocal<java.util.Map<String, String>> threadLocal = new ThreadLocal<java.util.Map<String, String>>() {
		protected java.util.Map<String, String> initialValue() {
			java.util.Map<String, String> threadRunResultMap = new java.util.HashMap<String, String>();
			threadRunResultMap.put("errorCode", null);
			threadRunResultMap.put("status", "");
			return threadRunResultMap;
		};
	};

	private SyncInt runningThreadCount = new SyncInt();

	private class SyncInt {
		private int count = 0;

		public synchronized void add(int i) {
			count += i;
		}

		public synchronized int getCount() {
			return count;
		}
	}

	private java.util.Properties context_param = new java.util.Properties();
	public java.util.Map<String, Object> parentContextMap = new java.util.HashMap<String, Object>();

	public String status = "";

	public static void main(String[] args) {
		final HistoryETL HistoryETLClass = new HistoryETL();

		int exitCode = HistoryETLClass.runJobInTOS(args);

		System.exit(exitCode);
	}

	public String[][] runJob(String[] args) {

		int exitCode = runJobInTOS(args);
		String[][] bufferValue = new String[][] { { Integer.toString(exitCode) } };

		return bufferValue;
	}

	public boolean hastBufferOutputComponent() {
		boolean hastBufferOutput = false;

		return hastBufferOutput;
	}

	public int runJobInTOS(String[] args) {
		// reset status
		status = "";

		String lastStr = "";
		for (String arg : args) {
			if (arg.equalsIgnoreCase("--context_param")) {
				lastStr = arg;
			} else if (lastStr.equals("")) {
				evalParam(arg);
			} else {
				evalParam(lastStr + " " + arg);
				lastStr = "";
			}
		}

		if (clientHost == null) {
			clientHost = defaultClientHost;
		}

		if (pid == null || "0".equals(pid)) {
			pid = TalendString.getAsciiRandomString(6);
		}

		if (rootPid == null) {
			rootPid = pid;
		}
		if (fatherPid == null) {
			fatherPid = pid;
		} else {
			isChildJob = true;
		}

		try {
			// call job/subjob with an existing context, like:
			// --context=production. if without this parameter, there will use
			// the default context instead.
			java.io.InputStream inContext = HistoryETL.class.getClassLoader()
					.getResourceAsStream(
							"ovirt_engine_dwh/historyetl_3_6/contexts/"
									+ contextStr + ".properties");
			if (isDefaultContext && inContext == null) {

			} else {
				if (inContext != null) {
					// defaultProps is in order to keep the original context
					// value
					defaultProps.load(inContext);
					inContext.close();
					context = new ContextProperties(defaultProps);
				} else {
					// print info and job continue to run, for case:
					// context_param is not empty.
					System.err.println("Could not find the context "
							+ contextStr);
				}
			}

			if (!context_param.isEmpty()) {
				context.putAll(context_param);
			}
			context.dwhUuid = (String) context.getProperty("dwhUuid");
			context.etlVersion = (String) context.getProperty("etlVersion");
			try {
				context.hoursToKeepDaily = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepDaily"));
			} catch (NumberFormatException e) {
				context.hoursToKeepDaily = null;
			}
			try {
				context.hoursToKeepHourly = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepHourly"));
			} catch (NumberFormatException e) {
				context.hoursToKeepHourly = null;
			}
			try {
				context.hoursToKeepSamples = routines.system.ParserUtils
						.parseTo_Integer(context
								.getProperty("hoursToKeepSamples"));
			} catch (NumberFormatException e) {
				context.hoursToKeepSamples = null;
			}
			try {
				String context_lastErrorSent_value = context
						.getProperty("lastErrorSent");
				if (context_lastErrorSent_value == null) {
					context_lastErrorSent_value = "";
				}
				int context_lastErrorSent_pos = context_lastErrorSent_value
						.indexOf(";");
				String context_lastErrorSent_pattern = "yyyy-MM-dd HH:mm:ss";
				if (context_lastErrorSent_pos > -1) {
					context_lastErrorSent_pattern = context_lastErrorSent_value
							.substring(0, context_lastErrorSent_pos);
					context_lastErrorSent_value = context_lastErrorSent_value
							.substring(context_lastErrorSent_pos + 1);
				}

				context.lastErrorSent = (java.util.Date) (new java.text.SimpleDateFormat(
						context_lastErrorSent_pattern)
						.parse(context_lastErrorSent_value));

			} catch (ParseException e) {
				context.lastErrorSent = null;
			}
			context.ovirtEngineDbDriverClass = (String) context
					.getProperty("ovirtEngineDbDriverClass");
			context.ovirtEngineDbJdbcConnection = (String) context
					.getProperty("ovirtEngineDbJdbcConnection");
			String pwd_ovirtEngineDbPassword_value = context
					.getProperty("ovirtEngineDbPassword");
			context.ovirtEngineDbPassword = null;
			if (pwd_ovirtEngineDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineDbPassword")) {// no
																			// need
																			// to
																			// decrypt
																			// if
																			// it
																			// come
																			// from
																			// program
																			// argument
																			// or
																			// parent
																			// job
																			// runtime
					context.ovirtEngineDbPassword = pwd_ovirtEngineDbPassword_value;
				} else if (!pwd_ovirtEngineDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineDbPassword_value);
						context.put("ovirtEngineDbPassword",
								context.ovirtEngineDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineDbUser = (String) context
					.getProperty("ovirtEngineDbUser");
			context.ovirtEngineHistoryDbDriverClass = (String) context
					.getProperty("ovirtEngineHistoryDbDriverClass");
			context.ovirtEngineHistoryDbJdbcConnection = (String) context
					.getProperty("ovirtEngineHistoryDbJdbcConnection");
			String pwd_ovirtEngineHistoryDbPassword_value = context
					.getProperty("ovirtEngineHistoryDbPassword");
			context.ovirtEngineHistoryDbPassword = null;
			if (pwd_ovirtEngineHistoryDbPassword_value != null) {
				if (context_param.containsKey("ovirtEngineHistoryDbPassword")) {// no
																				// need
																				// to
																				// decrypt
																				// if
																				// it
																				// come
																				// from
																				// program
																				// argument
																				// or
																				// parent
																				// job
																				// runtime
					context.ovirtEngineHistoryDbPassword = pwd_ovirtEngineHistoryDbPassword_value;
				} else if (!pwd_ovirtEngineHistoryDbPassword_value.isEmpty()) {
					try {
						context.ovirtEngineHistoryDbPassword = routines.system.PasswordEncryptUtil
								.decryptPassword(pwd_ovirtEngineHistoryDbPassword_value);
						context.put("ovirtEngineHistoryDbPassword",
								context.ovirtEngineHistoryDbPassword);
					} catch (java.lang.RuntimeException e) {
						// do nothing
					}
				}
			}
			context.ovirtEngineHistoryDbUser = (String) context
					.getProperty("ovirtEngineHistoryDbUser");
			try {
				context.runDeleteTime = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("runDeleteTime"));
			} catch (NumberFormatException e) {
				context.runDeleteTime = null;
			}
			try {
				context.runInterleave = routines.system.ParserUtils
						.parseTo_Integer(context.getProperty("runInterleave"));
			} catch (NumberFormatException e) {
				context.runInterleave = null;
			}
			try {
				context.timeBetweenErrorEvents = routines.system.ParserUtils
						.parseTo_Long(context
								.getProperty("timeBetweenErrorEvents"));
			} catch (NumberFormatException e) {
				context.timeBetweenErrorEvents = null;
			}
		} catch (java.io.IOException ie) {
			System.err.println("Could not load context " + contextStr);
			ie.printStackTrace();
		}

		// get context value from parent directly
		if (parentContextMap != null && !parentContextMap.isEmpty()) {
			if (parentContextMap.containsKey("dwhUuid")) {
				context.dwhUuid = (String) parentContextMap.get("dwhUuid");
			}
			if (parentContextMap.containsKey("etlVersion")) {
				context.etlVersion = (String) parentContextMap
						.get("etlVersion");
			}
			if (parentContextMap.containsKey("hoursToKeepDaily")) {
				context.hoursToKeepDaily = (Integer) parentContextMap
						.get("hoursToKeepDaily");
			}
			if (parentContextMap.containsKey("hoursToKeepHourly")) {
				context.hoursToKeepHourly = (Integer) parentContextMap
						.get("hoursToKeepHourly");
			}
			if (parentContextMap.containsKey("hoursToKeepSamples")) {
				context.hoursToKeepSamples = (Integer) parentContextMap
						.get("hoursToKeepSamples");
			}
			if (parentContextMap.containsKey("lastErrorSent")) {
				context.lastErrorSent = (java.util.Date) parentContextMap
						.get("lastErrorSent");
			}
			if (parentContextMap.containsKey("ovirtEngineDbDriverClass")) {
				context.ovirtEngineDbDriverClass = (String) parentContextMap
						.get("ovirtEngineDbDriverClass");
			}
			if (parentContextMap.containsKey("ovirtEngineDbJdbcConnection")) {
				context.ovirtEngineDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineDbPassword")) {
				context.ovirtEngineDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineDbUser")) {
				context.ovirtEngineDbUser = (String) parentContextMap
						.get("ovirtEngineDbUser");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbDriverClass")) {
				context.ovirtEngineHistoryDbDriverClass = (String) parentContextMap
						.get("ovirtEngineHistoryDbDriverClass");
			}
			if (parentContextMap
					.containsKey("ovirtEngineHistoryDbJdbcConnection")) {
				context.ovirtEngineHistoryDbJdbcConnection = (String) parentContextMap
						.get("ovirtEngineHistoryDbJdbcConnection");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbPassword")) {
				context.ovirtEngineHistoryDbPassword = (java.lang.String) parentContextMap
						.get("ovirtEngineHistoryDbPassword");
			}
			if (parentContextMap.containsKey("ovirtEngineHistoryDbUser")) {
				context.ovirtEngineHistoryDbUser = (String) parentContextMap
						.get("ovirtEngineHistoryDbUser");
			}
			if (parentContextMap.containsKey("runDeleteTime")) {
				context.runDeleteTime = (Integer) parentContextMap
						.get("runDeleteTime");
			}
			if (parentContextMap.containsKey("runInterleave")) {
				context.runInterleave = (Integer) parentContextMap
						.get("runInterleave");
			}
			if (parentContextMap.containsKey("timeBetweenErrorEvents")) {
				context.timeBetweenErrorEvents = (Long) parentContextMap
						.get("timeBetweenErrorEvents");
			}
		}

		// Resume: init the resumeUtil
		resumeEntryMethodName = ResumeUtil
				.getResumeEntryMethodName(resuming_checkpoint_path);
		resumeUtil = new ResumeUtil(resuming_logs_dir_path, isChildJob, rootPid);
		resumeUtil.initCommonInfo(pid, rootPid, fatherPid, projectName,
				jobName, contextStr, jobVersion);

		List<String> parametersToEncrypt = new java.util.ArrayList<String>();
		parametersToEncrypt.add("ovirtEngineDbPassword");
		parametersToEncrypt.add("ovirtEngineHistoryDbPassword");
		// Resume: jobStart
		resumeUtil.addLog("JOB_STARTED", "JOB:" + jobName,
				parent_part_launcher, Thread.currentThread().getId() + "", "",
				"", "", "",
				resumeUtil.convertToJsonText(context, parametersToEncrypt));

		java.util.concurrent.ConcurrentHashMap<Object, Object> concurrentHashMap = new java.util.concurrent.ConcurrentHashMap<Object, Object>();
		globalMap.put("concurrentHashMap", concurrentHashMap);

		long startUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		long endUsedMemory = 0;
		long end = 0;

		startTime = System.currentTimeMillis();

		this.globalResumeTicket = true;// to run tPreJob

		try {
			errorCode = null;
			tPrejob_1Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tPrejob_1) {
			globalMap.put("tPrejob_1_SUBPROCESS_STATE", -1);

			e_tPrejob_1.printStackTrace();

		}

		this.globalResumeTicket = false;// to run others jobs

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tRunJob_4Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tRunJob_4) {
					globalMap.put("tRunJob_4_SUBPROCESS_STATE", -1);

					e_tRunJob_4.printStackTrace();

				} catch (Error e_tRunJob_4) {
					globalMap.put("tRunJob_4_SUBPROCESS_STATE", -1);

					e_tRunJob_4.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tRunJob_2Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tRunJob_2) {
					globalMap.put("tRunJob_2_SUBPROCESS_STATE", -1);

					e_tRunJob_2.printStackTrace();

				} catch (Error e_tRunJob_2) {
					globalMap.put("tRunJob_2_SUBPROCESS_STATE", -1);

					e_tRunJob_2.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tLoop_1Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tLoop_1) {
					globalMap.put("tLoop_1_SUBPROCESS_STATE", -1);

					e_tLoop_1.printStackTrace();

				} catch (Error e_tLoop_1) {
					globalMap.put("tLoop_1_SUBPROCESS_STATE", -1);

					e_tLoop_1.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tRunJob_1Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tRunJob_1) {
					globalMap.put("tRunJob_1_SUBPROCESS_STATE", -1);

					e_tRunJob_1.printStackTrace();

				} catch (Error e_tRunJob_1) {
					globalMap.put("tRunJob_1_SUBPROCESS_STATE", -1);

					e_tRunJob_1.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		runningThreadCount.add(1);
		new Thread() {
			public void run() {
				java.util.Map threadRunResultMap = new java.util.HashMap();
				threadRunResultMap.put("errorCode", null);
				threadRunResultMap.put("status", "");
				threadLocal.set(threadRunResultMap);

				try {
					((java.util.Map) threadLocal.get()).put("errorCode", null);
					tSetGlobalVar_1Process(globalMap);
					if (!"failure".equals(((java.util.Map) threadLocal.get())
							.get("status"))) {
						((java.util.Map) threadLocal.get())
								.put("status", "end");
					}
				} catch (TalendException e_tSetGlobalVar_1) {
					globalMap.put("tSetGlobalVar_1_SUBPROCESS_STATE", -1);

					e_tSetGlobalVar_1.printStackTrace();

				} catch (Error e_tSetGlobalVar_1) {
					globalMap.put("tSetGlobalVar_1_SUBPROCESS_STATE", -1);

					e_tSetGlobalVar_1.printStackTrace();

				} finally {
					Integer localErrorCode = (Integer) (((java.util.Map) threadLocal
							.get()).get("errorCode"));
					String localStatus = (String) (((java.util.Map) threadLocal
							.get()).get("status"));
					if (localErrorCode != null) {
						if (errorCode == null
								|| localErrorCode.compareTo(errorCode) > 0) {
							errorCode = localErrorCode;
						}
					}
					if (!status.equals("failure")) {
						status = localStatus;
					}

					runningThreadCount.add(-1);
				}
			}
		}.start();

		while (runningThreadCount.getCount() > 0) {
			try {
				Thread.sleep(10);
			} catch (java.lang.Exception e) {
				e.printStackTrace();
			}
		}

		this.globalResumeTicket = true;// to run tPostJob

		try {
			errorCode = null;
			tPostjob_1Process(globalMap);
			if (!"failure".equals(status)) {
				status = "end";
			}
		} catch (TalendException e_tPostjob_1) {
			globalMap.put("tPostjob_1_SUBPROCESS_STATE", -1);

			e_tPostjob_1.printStackTrace();

		}

		end = System.currentTimeMillis();

		if (watch) {
			System.out.println((end - startTime) + " milliseconds");
		}

		endUsedMemory = Runtime.getRuntime().totalMemory()
				- Runtime.getRuntime().freeMemory();
		if (false) {
			System.out.println((endUsedMemory - startUsedMemory)
					+ " bytes memory increase when running : HistoryETL");
		}

		int returnCode = 0;
		if (errorCode == null) {
			returnCode = status != null && status.equals("failure") ? 1 : 0;
		} else {
			returnCode = errorCode.intValue();
		}
		resumeUtil.addLog("JOB_ENDED", "JOB:" + jobName, parent_part_launcher,
				Thread.currentThread().getId() + "", "", "" + returnCode, "",
				"", "");

		return returnCode;

	}

	// only for OSGi env
	public void destroy() {
		closeSqlDbConnections();
	}

	private void closeSqlDbConnections() {
		try {
			Object obj_conn;
			obj_conn = globalMap.remove("conn_tJDBCConnection_6");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_2");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_1");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_3");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_4");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_5");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
			obj_conn = globalMap.remove("conn_tJDBCConnection_7");
			if (null != obj_conn) {
				((java.sql.Connection) obj_conn).close();
			}
		} catch (java.lang.Exception e) {
		}
	}

	private java.util.Map<String, Object> getSharedConnections4REST() {
		java.util.Map<String, Object> connections = new java.util.HashMap<String, Object>();
		connections.put("conn_tJDBCConnection_6",
				globalMap.get("conn_tJDBCConnection_6"));
		connections.put("conn_tJDBCConnection_2",
				globalMap.get("conn_tJDBCConnection_2"));
		connections.put("conn_tJDBCConnection_1",
				globalMap.get("conn_tJDBCConnection_1"));
		connections.put("conn_tJDBCConnection_3",
				globalMap.get("conn_tJDBCConnection_3"));
		connections.put("conn_tJDBCConnection_4",
				globalMap.get("conn_tJDBCConnection_4"));
		connections.put("conn_tJDBCConnection_5",
				globalMap.get("conn_tJDBCConnection_5"));
		connections.put("conn_tJDBCConnection_7",
				globalMap.get("conn_tJDBCConnection_7"));
		return connections;
	}

	private void evalParam(String arg) {
		if (arg.startsWith("--resuming_logs_dir_path")) {
			resuming_logs_dir_path = arg.substring(25);
		} else if (arg.startsWith("--resuming_checkpoint_path")) {
			resuming_checkpoint_path = arg.substring(27);
		} else if (arg.startsWith("--parent_part_launcher")) {
			parent_part_launcher = arg.substring(23);
		} else if (arg.startsWith("--watch")) {
			watch = true;
		} else if (arg.startsWith("--stat_port=")) {
			String portStatsStr = arg.substring(12);
			if (portStatsStr != null && !portStatsStr.equals("null")) {
				portStats = Integer.parseInt(portStatsStr);
			}
		} else if (arg.startsWith("--trace_port=")) {
			portTraces = Integer.parseInt(arg.substring(13));
		} else if (arg.startsWith("--client_host=")) {
			clientHost = arg.substring(14);
		} else if (arg.startsWith("--context=")) {
			contextStr = arg.substring(10);
			isDefaultContext = false;
		} else if (arg.startsWith("--father_pid=")) {
			fatherPid = arg.substring(13);
		} else if (arg.startsWith("--root_pid=")) {
			rootPid = arg.substring(11);
		} else if (arg.startsWith("--father_node=")) {
			fatherNode = arg.substring(14);
		} else if (arg.startsWith("--pid=")) {
			pid = arg.substring(6);
		} else if (arg.startsWith("--context_param")) {
			String keyValue = arg.substring(16);
			int index = -1;
			if (keyValue != null && (index = keyValue.indexOf('=')) > -1) {
				if (fatherPid == null) {
					context_param.put(keyValue.substring(0, index),
							replaceEscapeChars(keyValue.substring(index + 1)));
				} else { // the subjob won't escape the especial chars
					context_param.put(keyValue.substring(0, index),
							keyValue.substring(index + 1));
				}
			}
		} else if (arg.startsWith("--log4jLevel=")) {
			log4jLevel = arg.substring(13);
		}

	}

	private final String[][] escapeChars = { { "\\\\", "\\" }, { "\\n", "\n" },
			{ "\\'", "\'" }, { "\\r", "\r" }, { "\\f", "\f" }, { "\\b", "\b" },
			{ "\\t", "\t" } };

	private String replaceEscapeChars(String keyValue) {

		if (keyValue == null || ("").equals(keyValue.trim())) {
			return keyValue;
		}

		StringBuilder result = new StringBuilder();
		int currIndex = 0;
		while (currIndex < keyValue.length()) {
			int index = -1;
			// judege if the left string includes escape chars
			for (String[] strArray : escapeChars) {
				index = keyValue.indexOf(strArray[0], currIndex);
				if (index >= 0) {

					result.append(keyValue.substring(currIndex,
							index + strArray[0].length()).replace(strArray[0],
							strArray[1]));
					currIndex = index + strArray[0].length();
					break;
				}
			}
			// if the left string doesn't include escape chars, append the left
			// into the result
			if (index < 0) {
				result.append(keyValue.substring(currIndex));
				currIndex = currIndex + keyValue.length();
			}
		}

		return result.toString();
	}

	public Integer getErrorCode() {
		return errorCode;
	}

	public String getStatus() {
		return status;
	}

	ResumeUtil resumeUtil = null;
}
/************************************************************************************************
 * 291722 characters generated by Talend Open Studio for Data Integration on the
 * December 3, 2015 4:23:01 PM IST
 ************************************************************************************************/
