%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())")}
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}
%{!?with_check: %global with_check 0}

%global		package_version 0.4.5_master
%global		package_name mom

Name:		%{package_name}
Version:	0.4.5
Release:	0.0.master%{?release_suffix}%{?dist}
Summary:	Dynamically manage system resources on virtualization hosts

Group:		Applications/System
License:	GPLv2
URL:		http://www.ovirt.org
Source:		 %{package_name}-%{package_version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch
BuildRequires:	python-devel
BuildRequires:	python-nose

# MOM makes use of libvirt by way of the python bindings to monitor and
# interact with virtual machines.
%if 0%{?fedora} >= 18 || 0%{?rhel} >= 7
Requires:	libvirt-daemon-driver-qemu
%else
Requires:	libvirt
%endif
Requires:	libvirt-python
Requires:	procps

Requires(post):		chkconfig
Requires(postun):	initscripts
Requires(preun):	chkconfig
Requires(preun):	initscripts

%description
MOM is a policy-driven tool that can be used to manage overcommitment on KVM
hosts. Using libvirt, MOM keeps track of active virtual machines on a host. At
a regular collection interval, data is gathered about the host and guests. Data
can come from multiple sources (eg. the /proc interface, libvirt API calls, a
client program connected to a guest, etc). Once collected, the data is
organized for use by the policy evaluation engine. When started, MOM accepts a
user-supplied overcommitment policy. This policy is regularly evaluated using
the latest collected data. In response to certain conditions, the policy may
trigger reconfiguration of the system’s overcommitment mechanisms. Currently
MOM supports control of memory ballooning and KSM but the architecture is
designed to accommodate new mechanisms such as cgroups.

%prep
%setup -q -n %{package_name}-%{package_version}

%build
%configure --docdir="%{_pkgdocdir}"
make %{?_smp_mflags}

%install
rm -rf "%{buildroot}"
make DESTDIR="%{buildroot}" install

install -d -m 0755 "%{buildroot}/%{_initrddir}"
install -m 0755 contrib/momd.init "%{buildroot}/%{_initrddir}/momd"
install -d -m 0755 "%{buildroot}/%{_sysconfdir}"
install -m 0644 doc/mom-balloon+ksm.conf "%{buildroot}/%{_sysconfdir}/momd.conf"

%check
%if 0%{with_check}
make check %{?_smp_mflags}
%endif

%post
/sbin/chkconfig --add momd

%preun
if [ $1 = 0 ] ; then
	/sbin/service momd stop >/dev/null 2>&1 || true
	/sbin/chkconfig --del momd || true
fi

%postun
if [ "$1" -ge "1" ] ; then
	/sbin/service momd condrestart >/dev/null 2>&1 || true
fi

%files
%config(noreplace) %{_sysconfdir}/momd.conf
%doc COPYING
%doc README
%{_initrddir}/momd
%{_sbindir}/momd
%{python_sitelib}/mom/

%changelog
* Sun Jan 19 2014 Kiril Nesenko <knesenko@redhat.com> - 0.3.2
- Change versioning style
- Switched form distutils to autotools builds

* Fri Oct 05 2012 Adam Litke <agl@us.ibm.com> - 0.3.0-1
- Upgrade to version 0.3.0
- Upstream fixes CVE-2012-4480

* Fri Jul 20 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 0.2.2-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_18_Mass_Rebuild

* Wed Jan 12 2011 Adam Litke <agl@us.ibm.com> - 0.2.2-1
- Upgrade to version 0.2.2
- Packaging related changes merged upstream so patches dropped

* Fri Jan 7 2011 Adam Litke <agl@us.ibm.com> - 0.2.1-5
- Address review comments by Michael Schwendt
- Fix use of _defaultdocdir macro
- Add some comments to the spec file

* Tue Oct 26 2010 Adam Litke <agl@us.ibm.com> - 0.2.1-4
- Third round of package review comments
- Remove useless shebang on non-executable python script

* Tue Oct 26 2010 Adam Litke <agl@us.ibm.com> - 0.2.1-3
- Second round of package review comments
- Add a default config file: /etc/momd.conf

* Wed Oct 13 2010 Adam Litke <agl@us.ibm.com> - 0.2.1-2
- Address initial package review comments

* Mon Sep 27 2010 Adam Litke <agl@us.ibm.com> - 0.2.1-1
- Initial package
