#
# ovirt-hosted-engine-setup -- ovirt hosted engine setup
# Copyright (C) 2013-2015 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global         engine ovirt-engine
%global         package_version 1.2.6.1
%global         ovirt_hosted_engine_setup_templates %{_datadir}/%{name}/templates
%global         ovirt_hosted_engine_setup_scripts %{_datadir}/%{name}/scripts
%global         vdsmhooksdir %{_libexecdir}/vdsm/hooks


Summary:        oVirt Hosted Engine setup tool
Name:           ovirt-hosted-engine-setup
Version:        1.2.6.1
Release:        1%{?release_suffix}%{?dist}
License:        LGPLv2+
URL:            http://www.ovirt.org
Source:         http://resources.ovirt.org/pub/ovirt-3.5/src/%{name}/%{name}-%{package_version}.tar.gz
Group:          Applications/System

BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildArch:      noarch

Requires:       python
Requires:       python-ethtool >= 0.6-3
Requires:       otopi >= 1.3.2
Requires:       vdsm >= 4.16.27
Requires:       vdsm-cli >= 4.16.27
Requires:       vdsm-python >= 4.16.27
Requires:       ovirt-host-deploy >= 1.3.1
Requires:       openssh-server
Requires:       python-paramiko
Requires:       virt-viewer
Requires:       openssl
Requires:       sudo
Requires:       bind-utils
Requires:       ovirt-hosted-engine-ha >= 1.2.7
Requires:       sanlock >= 2.8
Requires:       sanlock-python >= 2.8
Requires:       lsof
Requires:       iptables
BuildRequires:  gettext
BuildRequires:  python2-devel

Requires:       %{engine}-sdk-python >= 3.5.4

%if 0%{?fedora}
Requires:       qemu-img
Requires:       iptables-services
%endif

%if 0%{?rhel}
Requires:       qemu-img-rhev >= 0.12.1.2-2.448
%if 0%{?rhel} >= 7
Requires:       iptables-services
%endif
%endif

%description
Hosted Engine setup tool for oVirt project.

%prep
%setup -q -n %{name}-%{package_version}

%build
%configure \
        --docdir="%{_docdir}/%{name}-%{version}" \
        --disable-python-syntax-check \
        %{?conf}
make %{?_smp_mflags}

%install
rm -rf "%{buildroot}"
make %{?_smp_mflags} install DESTDIR="%{buildroot}"

%files
%doc COPYING
%doc README
%dir %{_sysconfdir}/ovirt-hosted-engine-setup.env.d
%dir %{_sysconfdir}/ovirt-hosted-engine
%dir %{_localstatedir}/log/ovirt-hosted-engine-setup
%dir %{_localstatedir}/lib/ovirt-hosted-engine-setup
%dir %{_localstatedir}/lib/ovirt-hosted-engine-setup/answers
%{_sbindir}/hosted-engine
%{_sbindir}/%{name}
%{python_sitelib}/ovirt_hosted_engine_setup/
%{_datadir}/%{name}/
%{_mandir}/man8/*

#move to a separate package?
%{vdsmhooksdir}/before_vm_start/

%changelog
* Wed Oct 14 2015 Simone Tiraboschi <stirabos@redhat.com> - 1.2.6.1-1
- 1.2.6.1-1

* Tue Sep 15 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.6-1
- 1.2.6-1

* Mon Jul 27 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.6-0.0.master
- 1.2.6-0.0.master

* Mon Jul 27 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.5.2-1
- 1.2.5.2-1

* Thu Jul  2 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.5.1-1
- 1.2.5.1-1

* Thu Jun 25 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.5-1
- 1.2.5-1

* Fri May 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.5-0.0.master
- 1.2.5-0.0.master

* Fri May 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.4-1
- 1.2.4-1

* Tue Mar 31 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.4-0.0.master
- 1.2.4-0.0.master

* Tue Mar 31 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.3-0.1.rc
- 1.2.3-0.1.rc

* Mon Jan 19 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.3-0.0.master
- 1.2.3-0.0.master

* Mon Jan 19 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.2-1
- 1.2.2-1

* Fri Oct  3 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.2-0.0.master
- 1.2.2-0.0.master

* Thu Oct  2 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.1-1
- 1.2.1-1

* Mon Sep 22 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.0-1
- 1.2.0-1

* Fri Sep 12 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.0-0.2.master
- 1.2.0-0.2.master

* Fri Jul 11 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.0-0.1.master
- 1.2.0-0.1.master

* Fri Jan 17 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.0-0.0.master
- 1.2.0-0.0.master
