#
# ovirt-release -- repo files for oVirt projects
# Copyright (C) 2012-2014 Red Hat, Inc.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#

%global	package_version 11.1.0
%global	package_name ovirt-release

Name:		%{package_name}
Version:	11.1.0
Release:	1%{?release_suffix}
Summary:	oVirt repository configuration
Epoch:		0
Group:		System Environment/Base

License:	ASL 2.0
URL:		http://ovirt.org
Source0:	http://ovirt.org/releases/stable/src/%{package_name}-%{package_version}.tar.gz

BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}
BuildArch:	noarch

BuildRequires:	automake
BuildRequires:	autoconf
Requires:		system-release
Requires:		tar

%description
This package contains the yum configuration for oVirt repositories


%prep
%setup -q


%build
%configure
make %{?_smp_mflags}


%install
rm -rf "%{buildroot}"
%make_install
#Allow ghost files
install -d 755 "%{buildroot}%{_sysconfdir}"/yum.repos.d
touch "%{buildroot}%{_sysconfdir}"/yum.repos.d/ovirt.repo
touch "%{buildroot}%{_sysconfdir}"/yum.repos.d/fedora-virt-preview.repo
touch "%{buildroot}%{_sysconfdir}"/yum.repos.d/glusterfs-epel.repo
touch "%{buildroot}%{_sysconfdir}"/yum.repos.d/ovirt-epel.repo

%post

# Adjust repos as per dist and version
DIST=Fedora
#Fedora is good for both Fedora and Generic (and probably other based on Fedora)
#Handling EL exception only (for now)
DISTVER="$(rpm --eval "%%dist"|cut -c2-)"
if rpm --eval "%%dist" | grep -qFi 'el'; then
    DIST=EL
fi

sed \
    -e "s/@DIST@/${DIST}/g" \
    -e "s/@DISTVER@/${DISTVER}/g" \
    <"%{_datadir}/%{package_name}/ovirt.repo.in" >%{_sysconfdir}/yum.repos.d/ovirt.repo

sed \
    -e "s/@DIST@/${DIST}/g" \
    -e "s/@DISTVER@/${DISTVER}/g" \
    <"%{_datadir}/%{package_name}/ovirt-nightly.repo.in" >%{_sysconfdir}/yum.repos.d/ovirt-nightly.repo

ADDITIONAL_REPO="fedora-virt-preview.repo"
[ "$DIST" == "EL" ] && ADDITIONAL_REPO="glusterfs-epel.repo"

install -m 644 "%{_datadir}/%{package_name}/$ADDITIONAL_REPO" "%{_sysconfdir}/yum.repos.d/$ADDITIONAL_REPO"

if [ "$DIST" == "EL" ] ; then
#Can't explicitly require epel-release, so adding epel-release to available packages
#This will allow "yum install epel-release".
    install -m 644 "%{_datadir}/%{package_name}/ovirt-epel.repo" "%{_sysconfdir}/yum.repos.d/ovirt-epel.repo"
fi

%files
%defattr(-,root,root,-)
%doc COPYING
%{_datadir}/%{package_name}/
%ghost %config(noreplace) %{_sysconfdir}/yum.repos.d/ovirt.repo
%ghost %config(noreplace,missingok) %{_sysconfdir}/yum.repos.d/fedora-virt-preview.repo
%ghost %config(noreplace,missingok) %{_sysconfdir}/yum.repos.d/glusterfs-epel.repo
%ghost %config(noreplace,missingok) %{_sysconfdir}/yum.repos.d/ovirt-epel.repo

%changelog
* Mon Mar 10 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 11.1.0-1
- Splitted nightly builds in separate ovirt-nightly.repo file.
- Added ovirt-3.4-stable and ovirt-3.3-stable repositories.
- Dropped beta and updates testing in favor of ovirt-3.3-prerelease.

* Tue Feb 25 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 11.0.2-1
- Add new layout nightly builds

* Mon Feb 24 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 11.0.1-1
- Add support for EL6 derived distributions

* Fri Jan 24 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 11.0.0-1
- Unify ovirt-release-fedora and ovirt-release-el6

* Wed Jan 22 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 10.0.1-3
- new ovirt-3.3.3 repository, Releasing oVirt 3.3.3
- 3.3.2 packages are now in stable

* Wed Jan 22 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 10.0.1-2
- Update the repositories with 3.4.0_pre for testing (disabled by default)

* Wed Jan 22 2014 Sandro Bonazzola <sbonazzo@redhat.com> - 10.0.1-1
- Update the repositories with 3.4.0_pre for testing

* Mon Jan 13 2014 Kiril Nesenko <knesenko@redhat.com> - 10-2
- Update the repositories with 3.4.0-alpha testing

* Thu Dec 19 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 10-1
- new ovirt-3.3.2 repository, Releasing oVirt 3.3.2
- ovirt-stable repository now provides Older Stable builds.
- ovirt-updates-testing provides Test Updates builds
- removed ovirt-alpha, obsolete and no longer used in oVirt >= 3.3.0.

* Thu Nov 28 2013 Sandro Bonazzola <sbonazzo@redhat.com> - 9-1
- change glusterfs-epel to use LATEST branch

* Thu Aug 22 2013 Mike Burns <mburns@redhat.com> - 8-1
- Add glusterfs-epel repo to el6 package

* Wed Jun 26 2013 Mike Burns <mburns@redhat.com> - 7-1
- Add Fedora virt-preview repo for Fedora builds

* Tue May 07 2013 Mike Burns <mburns@redhat.com> - 6-1
- Add updates-testing repository

* Thu Jun 14 2012 Mike Burns <mburns@redhat.com> - 2-1
- Add Beta repo
- convert to automake/autoconf build system.

* Mon Mar 19 2012 Stephen Gordon <sgordon@redhat.com> - 1-2
- Removed SRPM repositories as they do not exist.
* Thu Nov 24 2011 Stephen Gordon <sgordon@redhat.com> - 1-1
- Initial creation.
