package org.ovirt.engine.api.resource;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import org.jboss.resteasy.annotations.providers.jaxb.Formatted;
import org.ovirt.engine.api.model.Action;
import org.ovirt.engine.api.model.Actionable;
import org.ovirt.engine.api.model.NIC;


@Produces({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_X_YAML })
public interface VmNicResource extends NicResource {

    @Path("{action: (activate|deactivate)}/{oid}")
    public ActionResource getActionSubresource(@PathParam("action") String action, @PathParam("oid") String oid);

    // TODO remove on 4.1
    @Deprecated
    @POST
    @Formatted
    @Consumes({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_X_YAML })
    @Actionable
    @Path("activate")
    public Response activate(Action action);

    // TODO remove on 4.1
    @Deprecated
    @POST
    @Formatted
    @Consumes({ MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_X_YAML })
    @Actionable
    @Path("deactivate")
    public Response deactivate(Action action);

    @PUT
    @Formatted
    @Override
    @Consumes({MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON, MediaType.APPLICATION_X_YAML})
    public NIC update(NIC device);

    @GET
    @Formatted
    @Override
    public NIC get();

    @Path("reporteddevices")
    public VmReportedDevicesResource getVmReportedDevicesResource();
}
