package org.ovirt.engine.ui.webadmin.section.main.view.popup.storage;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.TableElement;
import com.google.gwt.editor.client.SimpleBeanEditorDriver;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.text.shared.AbstractRenderer;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.ValueBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Inject;
import org.ovirt.engine.ui.common.CommonApplicationConstants;
import org.ovirt.engine.ui.common.CommonApplicationResources;
import org.ovirt.engine.ui.common.CommonApplicationTemplates;
import org.ovirt.engine.ui.common.widget.editor.EntityModelTextBoxOnlyEditor;
import org.ovirt.engine.ui.common.widget.editor.ListModelListBoxOnlyEditor;
import org.ovirt.engine.ui.common.widget.uicommon.storage.AbstractStorageView;
import org.ovirt.engine.ui.uicommonweb.models.EntityModel;
import org.ovirt.engine.ui.uicommonweb.models.storage.NfsStorageModel;
import org.ovirt.engine.ui.webadmin.ApplicationConstants;
import org.ovirt.engine.ui.webadmin.gin.ClientGinjectorProvider;

public class NfsStorageView extends AbstractStorageView<NfsStorageModel> {

    interface Driver extends SimpleBeanEditorDriver<NfsStorageModel, NfsStorageView> {

        Driver driver = GWT.create(Driver.class);
    }

    interface ViewUiBinder extends UiBinder<Widget, NfsStorageView> {

        ViewUiBinder uiBinder = GWT.create(ViewUiBinder.class);
    }

    @UiField
    WidgetStyle style;

    @UiField
    @Path(value = "path.entity")
    EntityModelTextBoxOnlyEditor pathEditor;

    @UiField
    @Ignore
    Label pathLabel;

    @UiField
    @Ignore
    Label pathHintLabel;

    @UiField
    @Ignore
    ToggleButton expander;

    @UiField
    @Ignore
    Label warningLabel;

    @UiField
    @Ignore
    TableElement expanderContent;

    @UiField(provided = true)
    @Path(value = "version.selectedItem")
    ListModelListBoxOnlyEditor<Object> versionEditor;

    @UiField
    @Ignore
    EntityModelTextBoxOnlyEditor versionReadOnlyEditor;

    @UiField
    @Ignore
    Label versionLabel;

    @UiField
    @Path(value = "retransmissions.entity")
    EntityModelTextBoxOnlyEditor retransmissionsEditor;

    @UiField
    @Ignore
    Label retransmissionsLabel;

    @UiField
    @Path(value = "timeout.entity")
    EntityModelTextBoxOnlyEditor timeoutEditor;

    @UiField
    @Ignore
    Label timeoutLabel;

    @UiField
    Label message;

    protected static CommonApplicationConstants constants = GWT.create(CommonApplicationConstants.class);
    protected static CommonApplicationResources resources = GWT.create(CommonApplicationResources.class);
    protected static CommonApplicationTemplates templates = GWT.create(CommonApplicationTemplates.class);

    @Inject
    public NfsStorageView() {
        initEditors();
        initWidget(ViewUiBinder.uiBinder.createAndBindUi(this));
        localize(ClientGinjectorProvider.instance().getApplicationConstants());
        addStyles();
        wireEvents();
        Driver.driver.initialize(this);
    }

    void addStyles() {
        pathEditor.addContentWidgetStyleName(style.pathEditorContent());

        expanderContent.setClassName(style.expanderContent());


        SafeHtml expandImage = SafeHtmlUtils.fromTrustedString(AbstractImagePrototype.create(resources.expanderImage()).getHTML());
        expander.getUpFace().setHTML(templates.imageTextButton(expandImage, constants.advancedParameters()));

        SafeHtml collapseImage = SafeHtmlUtils.fromTrustedString(AbstractImagePrototype.create(resources.expanderDownImage()).getHTML());
        expander.getDownFace().setHTML(templates.imageTextButton(collapseImage, constants.advancedParameters()));
    }

    void wireEvents() {

        expander.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {

                expanderContent.getStyle().setDisplay(expander.isDown() ? Style.Display.BLOCK : Style.Display.NONE);
            }
        });
    }

    void initEditors() {

        versionEditor = new ListModelListBoxOnlyEditor<Object>(new AbstractRenderer<Object>() {
            @Override
            public String render(Object object) {

                EntityModel model = (EntityModel) object;
                return model.getTitle();
            }
        });
    }

    void localize(ApplicationConstants constants) {

        pathLabel.setText(constants.storagePopupNfsPathLabel());
        pathHintLabel.setText(constants.storagePopupNfsPathHintLabel());
        warningLabel.setText(constants.storagePopupNfsAdvancedOptionsLabel());
        versionLabel.setText(constants.storagePopupNfsVersionLabel());
        retransmissionsLabel.setText(constants.storagePopupNfsRetransmissionsLabel());
        timeoutLabel.setText(constants.storagePopupNfsTimeoutLabel());
    }

    @Override
    public void edit(NfsStorageModel object) {
        Driver.driver.edit(object);

        EntityModel version = (EntityModel) object.getVersion().getSelectedItem();
        versionReadOnlyEditor.asValueBox().setValue(version != null ? version.getTitle() : null);

        pathHintLabel.setVisible(object.getPath().getIsAvailable() && object.getPath().getIsChangable());

        styleTextBoxEditor(pathEditor, object.getPath().getIsChangable());
        styleTextBoxEditor(timeoutEditor, object.getTimeout().getIsChangable());
        styleTextBoxEditor(retransmissionsEditor, object.getRetransmissions().getIsChangable());
        styleTextBoxEditor(versionReadOnlyEditor, object.getVersion().getIsChangable());

        setElementVisibility(versionEditor, object.getVersion().getIsChangable() && object.getVersion().getIsAvailable());
        setElementVisibility(versionReadOnlyEditor, !object.getVersion().getIsChangable() || !object.getVersion().getIsAvailable());
        setElementVisibility(versionLabel, object.getVersion().getIsAvailable());
        setElementVisibility(retransmissionsLabel, object.getRetransmissions().getIsAvailable());
        setElementVisibility(timeoutLabel, object.getTimeout().getIsAvailable());


        // When all advanced fields are unavailable - hide the expander.
        boolean anyField = object.getVersion().getIsAvailable()
            || object.getRetransmissions().getIsAvailable()
            || object.getTimeout().getIsAvailable();

        expander.getElement().getStyle().setVisibility(anyField ? Style.Visibility.VISIBLE : Style.Visibility.HIDDEN);
    }

    @Override
    public NfsStorageModel flush() {
        return Driver.driver.flush();
    }

    interface WidgetStyle extends CssResource {

        String pathEditorContent();

        String expanderContent();
    }

    @Override
    public void focus() {
        pathEditor.setFocus(true);
    }

    /*
     * Makes a provided editor look like label (enabled, read-only textbox).
     */
    private void styleTextBoxEditor(EntityModelTextBoxOnlyEditor editor, boolean enabled) {

        if (!enabled) {

            editor.setEnabled(true);

            ValueBox<Object> valueBox = editor.asValueBox();
            valueBox.setReadOnly(true);
            valueBox.getElement().getStyle().setBorderWidth(0, Style.Unit.PX);
        }
    }

    private void setElementVisibility(UIObject object, boolean value) {

        object.getElement().getStyle().setDisplay(value ? Style.Display.BLOCK : Style.Display.NONE);
    }
}
