# Copyright 2018 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
#
# Refer to the README and COPYING files for full details of the license
#
from __future__ import absolute_import

import six

from nose.plugins.attrib import attr

from testlib import mock
from testlib import VdsmTestCase

from vdsm.network import dns


@attr(type='unit')
class TestNetworkDnsUnit(VdsmTestCase):

    @mock.patch.object(dns, 'open', create=True)
    def test_get_host_nameservers(self, mock_open):
        RESOLV_CONF = (
            '# Generated by NetworkManager\n'
            'search example.com company.net\n'
            'domain example.com\n'
            'nameserver 192.168.0.100\n'
            'nameserver 8.8.8.8\n'
            'nameserver 8.8.4.4\n'
        )
        expected_nameservers = ['192.168.0.100', '8.8.8.8', '8.8.4.4']
        resolv_conf_stream = six.StringIO(RESOLV_CONF)
        mock_open.return_value.__enter__.return_value = resolv_conf_stream

        resulted_nameservers = dns.get_host_nameservers()

        self.assertEqual(expected_nameservers, resulted_nameservers)

    @mock.patch.object(dns, 'open', create=True)
    def test_get_host_nameservers_no_resolvconf(self, mock_open):
        mock_open.return_value.__enter__.side_effect = IOError()

        nameservers = dns.get_host_nameservers()

        self.assertEqual(nameservers, [])


@attr(type='integration')
class TestNetworkDnsIntegration(VdsmTestCase):

    def test_read_dns_entries_from_resolv_conf(self):
        # Assuming at least one DNS entry exists on the host running the tests
        nameservers = dns.get_host_nameservers()
        self.assertTrue(nameservers, 'No DNS entries detected')
