/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.j2ee;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.j2ee.AbstractBeanCheck;
import com.puppycrawl.tools.checkstyle.checks.j2ee.BeanManagedMethodChecker;
import com.puppycrawl.tools.checkstyle.checks.j2ee.ContainerManagedMethodChecker;
import com.puppycrawl.tools.checkstyle.checks.j2ee.EntityBeanMethodChecker;
import com.puppycrawl.tools.checkstyle.checks.j2ee.PersistenceOption;
import com.puppycrawl.tools.checkstyle.checks.j2ee.Utils;
import org.apache.commons.beanutils.ConversionException;

public class EntityBeanCheck
extends AbstractBeanCheck {
    private PersistenceOption mPersistenceOption = PersistenceOption.MIXED;
    private String mVersion = "2.0";

    public EntityBeanCheck() {
        this.setMethodChecker(new EntityBeanMethodChecker(this));
    }

    public void setPersistence(String aOption) throws ConversionException {
        this.mPersistenceOption = (PersistenceOption)this.mPersistenceOption.decode(aOption);
        if (this.mPersistenceOption == null) {
            throw new ConversionException("unable to parse " + aOption);
        }
        if (this.mPersistenceOption == PersistenceOption.BEAN) {
            this.setMethodChecker(new BeanManagedMethodChecker(this));
        } else if (this.mPersistenceOption == PersistenceOption.CONTAINER) {
            this.setMethodChecker(new ContainerManagedMethodChecker(this));
        } else {
            this.setMethodChecker(new EntityBeanMethodChecker(this));
        }
    }

    public PersistenceOption getPersistenceOption() {
        return this.mPersistenceOption;
    }

    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void visitToken(DetailAST aAST) {
        if (Utils.hasImplements(aAST, "javax.ejb.EntityBean")) {
            this.checkBean(aAST, "Entity bean", true);
            this.checkAbstract(aAST);
            this.getMethodChecker().checkMethods(aAST);
        }
    }

    private void checkAbstract(DetailAST aAST) {
        if (this.getPersistenceOption() == PersistenceOption.BEAN && Utils.isAbstract(aAST)) {
            this.logName(aAST, "abstract.bean", new Object[0]);
        }
        if (this.getPersistenceOption() == PersistenceOption.CONTAINER && !Utils.isAbstract(aAST)) {
            this.logName(aAST, "nonabstract.bean", new Object[0]);
        }
    }
}

