# Copyright (C) 2018-2019 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

%global         package_version 1.2.0
%global         srcname ovirt-setup-lib

%if 0%{?fedora} || 0%{?rhel} >= 8
%global with_python3 1
%else
%global with_python3 0
%endif

%if  0%{?rhel} >= 8
%global with_python2 0
%else
%global with_python2 1
%endif

Summary:        oVirt setup common library
Name:           %{srcname}
Version:        1.2.0
Release:        1%{?release_suffix}%{?dist}
Source0:        http://resources.ovirt.org/pub/ovirt-master-snapshot/src/%{srcname}/%{srcname}-%{package_version}.tar.gz
License:        ASL 2.0
Group:          Development/Libraries
BuildArch:      noarch
Url:            http://www.ovirt.org

BuildRequires:  gettext
%if 0%{?with_python2}
BuildRequires:  python2-devel
Requires: python2-%{srcname}
%endif

%if 0%{?with_python3}
BuildRequires:  python3-devel
%if 0%{!?with_python2}
Requires: python3-%{srcname}
%endif
%endif

%description
oVirt setup common library

%if 0%{?with_python2}
%package -n python2-%{srcname}
Summary:        oVirt setup common library
%{?python_provide:%python_provide python2-%{srcname}}
Provides: ovirt-setup-lib = %{version}
Obsoletes: ovirt-setup-lib < %{version}
Requires: python-setuptools
Requires: python-netaddr
Requires: python-six

%description -n python2-%{srcname}
oVirt setup common library
%endif

%if 0%{?with_python3}
%package -n python3-%{srcname}
Summary:        oVirt setup common library
%{?python_provide:%python_provide python3-%{srcname}}
Requires: python3-setuptools
Requires: python3-netaddr
Requires: python3-six

%description -n python3-%{srcname}
oVirt setup common library
%endif

%prep
%setup -q -n %{srcname}-%{package_version}
%if 0%{?with_python3}
    rm -rf %{py3dir}
    cp -a . %{py3dir}
    find %{py3dir} -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python3}|'
%endif # with_python3
%if 0%{?with_python2}
find -name '*.py' | xargs sed -i '1s|^#!python|#!%{__python2}|'
%endif # with_python2

%build
%if 0%{?with_python2}
%configure \
        PYTHON="%{__python2}" \
        --docdir="%{_pkgdocdir}" \
        --disable-python-syntax-check \
        %{?conf}
make %{?_smp_mflags}
%endif # with_python2

%if 0%{?with_python3}
pushd %{py3dir}
%configure \
        PYTHON="%{__python3}" \
        --docdir="%{_pkgdocdir}" \
        --disable-python-syntax-check \
        %{?conf}
make %{?_smp_mflags}
popd
%endif # with_python3

%install
%if 0%{?with_python2}
make %{?_smp_mflags} install DESTDIR="%{buildroot}"
%endif # with_python2

%if 0%{?with_python3}
pushd %{py3dir}
make %{?_smp_mflags} install DESTDIR="%{buildroot}"
popd
%endif # with_python3
rm -f %{buildroot}%{_pkgdocdir}/README.md

%clean
rm -rf %{buildroot}

%if 0%{?with_python2}
%files -n python2-%{srcname}
%{python2_sitelib}/ovirt_setup_lib/
%doc README.md
%license COPYING
%endif

%if 0%{?with_python3}
%files -n python3-%{srcname}
%{python3_sitelib}/ovirt_setup_lib/
%doc README.md
%license COPYING
%endif

%changelog
* Tue Jan 08 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 1.2.0-1
- 1.2.0-1

* Fri Aug 11 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.4-1
- 1.1.4-1

* Wed Jun  7 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.3-1
- 1.1.3-1

* Tue Jun  6 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.2-1
- Resolves: BZ#1452243

* Thu May 25 2017 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.1-1
- Resolves: BZ#1452243

* Mon Dec 19 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.0-1
- Resolves: BZ#1366270
  hosted-engine-setup (and cockpit) accepts host address with an underscore
  while the engine correctly refuses them

* Fri Sep 30 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.1.0-0.0.master
- Dropped EL6 support

* Tue May 31 2016 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.2-1
- 1.0.2-1

* Tue Dec 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.1-1
- 1.0.1-1

* Tue Sep 22 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-1
- 1.0.0-1

* Wed Jul 15 2015 Sandro Bonazzola <sbonazzo@redhat.com> - 1.0.0-0.0.master
- initial packaging
- doc: https://fedoraproject.org/wiki/Changes/UnversionedDocdirs
- python: https://fedoraproject.org/wiki/Packaging:Python#Macros

