#
# Copyright 2013-2014 Red Hat, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

Name: ovirt-scheduler-proxy
Version: 0.1.9
Release: 1%{?dist}
Summary: Scheduling Proxy for Open Virtualization
Group: Virtualization/Management
License: ASL 2.0
URL: http://www.ovirt.org

# The source is tracked by git, please use the following to get the tarball
# git clone git://gerrit.ovirt.org/ovirt-scheduler-proxy.git
# cd ovirt-scheduler-proxy
# git checkout %%{version}
# make tarball
# Some releases can also be downloaded from
# http://ovirt.org/releases/stable/src/%%{name}-%%{version}.tar.gz
Source: %{name}-%{version}.tar.gz
BuildArch: noarch

BuildRequires: systemd

BuildRequires: python3-devel
BuildRequires: maven
BuildRequires: java-11-openjdk-devel >= 11.0.4

Requires: python3

%description
The scheduler proxy runs user defined scripts to filter and fine-tune
load-balancing of their oVirt system.


%prep
%setup -q

# remove integration (java) tests
rm -rf tests/java

%build
%{__python3} setup.py \
    build


%install

# Install the python files:
%{__python3} setup.py \
    install \
    -O1 \
    --skip-build \
    --root %{buildroot}

# Install the systemd service file:
install \
    -dm 755 \
    %{buildroot}%{_unitdir}
install \
    -m 644 \
    packaging/ovirt-scheduler-proxy.systemd \
     %{buildroot}%{_unitdir}/ovirt-scheduler-proxy.service


# Install the data directory:
install \
    -dm 755 \
    %{buildroot}%{_datadir}/%{name}

# Install the directory for plugins:
install \
    -dm 755 \
    %{buildroot}%{_datadir}/%{name}/plugins

# Install the directory for logs:
install \
    -dm 755 \
    %{buildroot}%{_localstatedir}/log/%{name}

%check
make pythontest

%pre

# Create the group if it doesn't exist:
getent group ovirt &>/dev/null || \
    groupadd \
        -g 108 \
        ovirt

# Create the user if it doesn't exist.
# Home directory is not created, becasue SELinux does not allow it.
getent passwd ovirt &>/dev/null || \
    useradd \
        -u 108 \
        -g ovirt \
        -c "oVirt Manager" \
        -s /sbin/nologin \
        -M \
        -d %{_datadir}/%{name} \
        ovirt


%post
# Make sure that systemd reloads its configuration once the package is
# installed, otherwise it won't recognize the new service name:
%systemd_post ovirt-scheduler-proxy.service


%postun
# Make sure that the service is stoped and removed from the systemd
# configuration:
%systemd_postun ovirt-scheduler-proxy.service

%preun
# Make sure that the service is stoped
%systemd_preun ovirt-scheduler-proxy.service


%files
# Python files (included the generated egg):
%{python3_sitelib}/ovirtscheduler
%{python3_sitelib}/ovirt_scheduler_proxy-*.egg-info

%{_unitdir}/ovirt-scheduler-proxy.service

# Data directory:
%{_datadir}/ovirt-scheduler-proxy

# Logs directory needs to be owned by the user that runs the service because it
# needs to create files inside:
%attr(-, ovirt, ovirt) %{_localstatedir}/log/ovirt-scheduler-proxy

# Documentation and example files
%doc LICENSE README doc/*

%changelog
* Tue Feb 18 2020 Liran Rotenberg <lrotenbe@redhat.com> 0.1.9-1
- Transition to python3 and java 11

* Tue May 28 2019 Sandro Bonazzola <sbonazzo@redhat.com> - 0.1.8-2
- Fix spec file for Fedora 29 compatibility

* Thu Nov 09 2017 Andrej Krejcir <akrejcir@redhat.com> 0.1.8-1
- Fix installation errors on CentOS 7.4
  Resolves: rhbz#1494390

* Thu Jun 08 2017 Martin Sivak <msivak@redhat.com> 0.1.7-1
- Fix timeout and forced stop of scheduler methods
  Resolves: rhbz#1444611

* Wed Jan 21 2015 Martin Sivak <msivak@redhat.com> 0.1.6-1
- Support RHEL7 build environment
  Resolves: rhbz#1159293

* Wed Jul 16 2014 Martin Sivak <msivak@redhat.com> 0.1.5-1
- Makefile cleanup
- Errors reported to the engine over xmlrpc
  Resolves: rhbz#1066576
- Slow DNS lookup disabled

* Thu Feb 27 2014 Martin Sivak <msivak@redhat.com> 0.1.4-1
- Build process cleanup and update
- Better directory structure
- Fixes to preun and postun scripts
  Resolves: rhbz#1055156
- Return all hosts when all filters fail
  Resolves: rhbz#1002444

* Mon Nov 25 2013 Martin Sivak <msivak@redhat.com> - 0.1.3-1
- Added ovirt java sdk to pom.xml for java tests
- Better logging
- More sample plugins
- Failing filter plugin does not cause the result to be []
  Resolves: rhbz#1002444

* Tue Sep 10 2013 Martin Sivak <msivak@redhat.com> - 0.1.2-1
- Added log rotation to ovirtshed daemon
- sample plugins and files included to the package

* Thu Sep 05 2013 Juan Hernandez <juan.hernandez@redhat.com> - 0.1.1-1
- Fixes in license headers to adapt them to ASL 2.0
- Added ASL 2.0 license file

* Fri Aug 09 2013 Martin Sivak <msivak@redhat.com> - 0.1-1
- Initial packaging
