/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.decorators.OpenStackImageProviderCertificates;
import org.ovirt.engine.sdk.decorators.OpenStackImageProviderOpenStackImages;
import org.ovirt.engine.sdk.entities.Action;
import org.ovirt.engine.sdk.entities.Response;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class OpenStackImageProvider
extends org.ovirt.engine.sdk.entities.OpenStackImageProvider {
    private HttpProxyBroker proxy;
    private final Object LOCK = new Object();
    private volatile OpenStackImageProviderCertificates openStackImageProviderCertificates;
    private volatile OpenStackImageProviderOpenStackImages openStackImageProviderOpenStackImages;

    public OpenStackImageProvider(HttpProxyBroker proxy) {
        this.proxy = proxy;
    }

    private HttpProxyBroker getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenStackImageProviderCertificates getCertificates() {
        if (this.openStackImageProviderCertificates == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.openStackImageProviderCertificates == null) {
                    this.openStackImageProviderCertificates = new OpenStackImageProviderCertificates(this.proxy, this);
                }
            }
        }
        return this.openStackImageProviderCertificates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenStackImageProviderOpenStackImages getOpenStackImages() {
        if (this.openStackImageProviderOpenStackImages == null) {
            Object object = this.LOCK;
            synchronized (object) {
                if (this.openStackImageProviderOpenStackImages == null) {
                    this.openStackImageProviderOpenStackImages = new OpenStackImageProviderOpenStackImages(this.proxy, this);
                }
            }
        }
        return this.openStackImageProviderOpenStackImages;
    }

    public Response delete() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Response delete(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().delete(url, Response.class, headers);
    }

    public Action importcertificates(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/importcertificates";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action importcertificates(Action action, Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/importcertificates";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action importcertificates(Action action, Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/importcertificates";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action testconnectivity(Action action) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/testconnectivity";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action testconnectivity(Action action, Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/testconnectivity";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public Action testconnectivity(Action action, Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref() + "/testconnectivity";
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().action(url, action, Action.class, Action.class, headers);
    }

    public OpenStackImageProvider update() throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.OpenStackImageProvider.class, OpenStackImageProvider.class, headers);
    }

    public OpenStackImageProvider update(Boolean async) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.OpenStackImageProvider.class, OpenStackImageProvider.class, headers);
    }

    public OpenStackImageProvider update(Boolean async, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.OpenStackImageProvider.class, OpenStackImageProvider.class, headers);
    }

    public OpenStackImageProvider update(Boolean async, String correlationId, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.getHref();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        if (async != null) {
            urlBuilder.add("async", async, UrlParameterType.MATRIX);
        }
        url = urlBuilder.build();
        return this.getProxy().update(url, this, org.ovirt.engine.sdk.entities.OpenStackImageProvider.class, OpenStackImageProvider.class, headers);
    }
}

