%global make_common_opts \\\
	PREFIX=%{_prefix} \\\
	SYSCONF_DIR=%{_sysconfdir} \\\
	DATA_DIR=%{_datadir} \\\
	PKG_DATA_DIR=%{_datadir}/%{name} \\\
	%{nil}
Name:		ovirt-engine-extension-aaa-jdbc
Version:	1.1.10
Release:	1%{?dist}
License:	ASL 2.0
Summary:	oVirt Engine Local Users Extension
Group:		Virtualization/Management
URL:		http://www.ovirt.org
BuildArch:	noarch
Source:		http://resources.ovirt.org/pub/src/%{name}/%{name}-1.1.10.tar.gz

BuildRequires: java-1.8.0-openjdk-devel >= 1:1.8.0

BuildRequires: apache-commons-codec
BuildRequires: apache-commons-lang
BuildRequires: ant
BuildRequires: jackson
BuildRequires: jpackage-utils
BuildRequires: ovirt-engine-extensions-api
BuildRequires: postgresql-jdbc
BuildRequires: slf4j >= 1.7

%if 0%{?fedora}
BuildRequires: slf4j-jdk14 >= 1.7
%endif

Requires: ovirt-engine-extensions-api-impl >= 3.5

%description
Local JDBC user management for oVirt engine.

%prep
%setup -c -q

%build
cat > build.properties << __EOF__
jar.commons-codec=$(build-classpath commons-codec)
jar.commons-lang=$(build-classpath commons-lang)
jar.jackson-core-asl=$(build-classpath jackson/jackson-core-asl)
jar.jackson-mapper-asl=$(build-classpath jackson/jackson-mapper-asl)
jar.ovirt-engine-extensions-api=$(build-classpath ovirt-engine/ovirt-engine-extensions-api)
jar.jdbc=$(build-classpath postgresql-jdbc)
jar.slf4j-api=$(build-classpath slf4j/slf4j-api)
package.display.name=%{name}-%{version}-%{release}

__EOF__

make %{make_common_opts} all

%install
rm -fr "%{buildroot}"
make %{make_common_opts} install-no-build DESTDIR="%{buildroot}"

%files
%doc README.admin
%doc README.developer
%{_datadir}/%{name}/
%{_sysconfdir}/ovirt-engine/engine.conf.d/50-%{name}.conf
%{_bindir}/ovirt-aaa-jdbc-tool

%changelog
* Wed Mar 06 2019 Martin Perina <mperina@redhat.com> 1.1.10-1
- Fixed bug 1685968

* Mon Mar 04 2019 Martin Perina <mperina@redhat.com> 1.1.9-1
- Fixed bug 1619391

* Fri Nov 23 2018 Martin Perina <mperina@redhat.com> 1.1.8-1
- Fix Fedora build issues

* Wed Feb 14 2018 Martin Perina <mperina@redhat.com> 1.1.7-1
- Add missing indexes
- Use NativePRNG instead of SHA1PRNG

* Wed Jul 12 2017 Martin Perina <mperina@redhat.com> 1.1.6-1
- Contains fix for last minute issue found when verifying bug 1389673

* Thu May 19 2017 Martin Perina <mperina@redhat.com> 1.1.5-1
- Fixed bug 1389673

* Thu Feb 09 2017 Martin Perina <mperina@redhat.com> 1.1.4-1
- Fixed bug 1415704

* Mon Jan 30 2017 Martin Perina <mperina@redhat.com> 1.1.3-1
- Fixed bug 1416935

* Fri Nov 18 2016 Martin Perina <mperina@redhat.com> 1.1.2-1
- Fixed bug 1391154
- Newly required OpenJDK 1.8 to support new langiage features

* Tue Oct 11 2016 Martin Perina <mperina@redhat.com> 1.1.1-1
- Fixed bug 1373111
- Fixed wrong return state when add group failed after group was added to db

* Thu May 26 2016 Martin Perina <mperina@redhat.com> 1.1.0-1
- Removes EL6 support
- Fixed classloading issue in WildFly 10

* Fri Apr 15 2016 Martin Perina <mperina@redhat.com> 1.0.7-1
- Fixed bug 1304368

* Thu Jan 28 2016 Martin Perina <mperina@redhat.com> 1.0.6-1
- Fixed bugs 1299773, 1299793

* Tue Jan 05 2016 Martin Perina <mperina@redhat.com> 1.0.5-1
- Fixes documentation about upgrading aaa-jdbc (bug 1293338)

* Fri Nov 27 2015 Martin Perina <mperina@redhat.com> 1.0.4-1
- Finally fixed bug 1241879

* Mon Nov 23 2015 Martin Perina <mperina@redhat.com> 1.0.3-1
- Fixed bug 1283936

* Fri Nov 06 2015 Martin Perina <mperina@redhat.com> 1.0.2-1
- Fixed bugs 1277398, 1241883, 1241879, 1275667

* Mon Oct 19 2015 Martin Perina <mperina@redhat.com> 1.0.1-1
- Fixed bugs 1269870, 1270821, 1241851

* Tue Oct 06 2015 Martin Perina <mperina@redhat.com> 1.0.0-1
- Initial release

