/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.ClusterContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlAffinityGroupReader;
import org.ovirt.engine.sdk4.internal.xml.XmlBiosTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlClusterFeatureReader;
import org.ovirt.engine.sdk4.internal.xml.XmlCpuProfileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlCpuReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDataCenterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDisplayReader;
import org.ovirt.engine.sdk4.internal.xml.XmlErrorHandlingReader;
import org.ovirt.engine.sdk4.internal.xml.XmlExternalProviderReader;
import org.ovirt.engine.sdk4.internal.xml.XmlFencingPolicyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlFirewallTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterHookReader;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterVolumeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlKsmReader;
import org.ovirt.engine.sdk4.internal.xml.XmlLogMaxMemoryUsedThresholdTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlMacPoolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlMemoryPolicyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlMigrationOptionsReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkFilterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPermissionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlPropertyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlRngSourceReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSchedulingPolicyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSerialNumberReader;
import org.ovirt.engine.sdk4.internal.xml.XmlSwitchTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVersionReader;
import org.ovirt.engine.sdk4.types.AffinityGroup;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.ClusterFeature;
import org.ovirt.engine.sdk4.types.CpuProfile;
import org.ovirt.engine.sdk4.types.ExternalProvider;
import org.ovirt.engine.sdk4.types.GlusterHook;
import org.ovirt.engine.sdk4.types.GlusterVolume;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkFilter;
import org.ovirt.engine.sdk4.types.Permission;

public class XmlClusterReader {
    public static Cluster readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        ClusterContainer object = new ClusterContainer();
        block102: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block102;
                }
                case "id": {
                    object.id(image);
                    continue block102;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block103: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "affinity_groups": {
                    object.affinityGroups(XmlAffinityGroupReader.readMany(reader));
                    continue block103;
                }
                case "ballooning_enabled": {
                    object.ballooningEnabled(reader.readBoolean());
                    continue block103;
                }
                case "bios_type": {
                    object.biosType(XmlBiosTypeReader.readOne(reader));
                    continue block103;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block103;
                }
                case "cpu": {
                    object.cpu(XmlCpuReader.readOne(reader));
                    continue block103;
                }
                case "cpu_profiles": {
                    object.cpuProfiles(XmlCpuProfileReader.readMany(reader));
                    continue block103;
                }
                case "custom_scheduling_policy_properties": {
                    object.customSchedulingPolicyProperties(XmlPropertyReader.readMany(reader));
                    continue block103;
                }
                case "data_center": {
                    object.dataCenter(XmlDataCenterReader.readOne(reader));
                    continue block103;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block103;
                }
                case "display": {
                    object.display(XmlDisplayReader.readOne(reader));
                    continue block103;
                }
                case "enabled_features": {
                    object.enabledFeatures(XmlClusterFeatureReader.readMany(reader));
                    continue block103;
                }
                case "error_handling": {
                    object.errorHandling(XmlErrorHandlingReader.readOne(reader));
                    continue block103;
                }
                case "external_network_providers": {
                    object.externalNetworkProviders(XmlExternalProviderReader.readMany(reader));
                    continue block103;
                }
                case "fencing_policy": {
                    object.fencingPolicy(XmlFencingPolicyReader.readOne(reader));
                    continue block103;
                }
                case "firewall_type": {
                    object.firewallType(XmlFirewallTypeReader.readOne(reader));
                    continue block103;
                }
                case "gluster_hooks": {
                    object.glusterHooks(XmlGlusterHookReader.readMany(reader));
                    continue block103;
                }
                case "gluster_service": {
                    object.glusterService(reader.readBoolean());
                    continue block103;
                }
                case "gluster_tuned_profile": {
                    object.glusterTunedProfile(reader.readString());
                    continue block103;
                }
                case "gluster_volumes": {
                    object.glusterVolumes(XmlGlusterVolumeReader.readMany(reader));
                    continue block103;
                }
                case "ha_reservation": {
                    object.haReservation(reader.readBoolean());
                    continue block103;
                }
                case "ksm": {
                    object.ksm(XmlKsmReader.readOne(reader));
                    continue block103;
                }
                case "log_max_memory_used_threshold": {
                    object.logMaxMemoryUsedThreshold(reader.readInteger());
                    continue block103;
                }
                case "log_max_memory_used_threshold_type": {
                    object.logMaxMemoryUsedThresholdType(XmlLogMaxMemoryUsedThresholdTypeReader.readOne(reader));
                    continue block103;
                }
                case "mac_pool": {
                    object.macPool(XmlMacPoolReader.readOne(reader));
                    continue block103;
                }
                case "maintenance_reason_required": {
                    object.maintenanceReasonRequired(reader.readBoolean());
                    continue block103;
                }
                case "management_network": {
                    object.managementNetwork(XmlNetworkReader.readOne(reader));
                    continue block103;
                }
                case "memory_policy": {
                    object.memoryPolicy(XmlMemoryPolicyReader.readOne(reader));
                    continue block103;
                }
                case "migration": {
                    object.migration(XmlMigrationOptionsReader.readOne(reader));
                    continue block103;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block103;
                }
                case "network_filters": {
                    object.networkFilters(XmlNetworkFilterReader.readMany(reader));
                    continue block103;
                }
                case "networks": {
                    object.networks(XmlNetworkReader.readMany(reader));
                    continue block103;
                }
                case "optional_reason": {
                    object.optionalReason(reader.readBoolean());
                    continue block103;
                }
                case "permissions": {
                    object.permissions(XmlPermissionReader.readMany(reader));
                    continue block103;
                }
                case "required_rng_sources": {
                    object.requiredRngSources(XmlRngSourceReader.readMany(reader));
                    continue block103;
                }
                case "scheduling_policy": {
                    object.schedulingPolicy(XmlSchedulingPolicyReader.readOne(reader));
                    continue block103;
                }
                case "serial_number": {
                    object.serialNumber(XmlSerialNumberReader.readOne(reader));
                    continue block103;
                }
                case "supported_versions": {
                    object.supportedVersions(XmlVersionReader.readMany(reader));
                    continue block103;
                }
                case "switch_type": {
                    object.switchType(XmlSwitchTypeReader.readOne(reader));
                    continue block103;
                }
                case "threads_as_cores": {
                    object.threadsAsCores(reader.readBoolean());
                    continue block103;
                }
                case "trusted_service": {
                    object.trustedService(reader.readBoolean());
                    continue block103;
                }
                case "tunnel_migration": {
                    object.tunnelMigration(reader.readBoolean());
                    continue block103;
                }
                case "version": {
                    object.version(XmlVersionReader.readOne(reader));
                    continue block103;
                }
                case "virt_service": {
                    object.virtService(reader.readBoolean());
                    continue block103;
                }
                case "vnc_encryption": {
                    object.vncEncryption(reader.readBoolean());
                    continue block103;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block103;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlClusterReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Cluster> iterateMany(final XmlReader reader) {
        return new Iterator<Cluster>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Cluster next() {
                Cluster next = XmlClusterReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Cluster> readMany(XmlReader reader) {
        ArrayList<Cluster> list = new ArrayList<Cluster>();
        Iterator<Cluster> iterator = XmlClusterReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(ClusterContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "affinitygroups": {
                    ArrayListWithHref<AffinityGroup> list = new ArrayListWithHref<AffinityGroup>(object.affinityGroups());
                    list.href(href);
                    object.affinityGroups(list);
                    break;
                }
                case "cpuprofiles": {
                    ArrayListWithHref<CpuProfile> list = new ArrayListWithHref<CpuProfile>(object.cpuProfiles());
                    list.href(href);
                    object.cpuProfiles(list);
                    break;
                }
                case "enabledfeatures": {
                    ArrayListWithHref<ClusterFeature> list = new ArrayListWithHref<ClusterFeature>(object.enabledFeatures());
                    list.href(href);
                    object.enabledFeatures(list);
                    break;
                }
                case "externalnetworkproviders": {
                    ArrayListWithHref<ExternalProvider> list = new ArrayListWithHref<ExternalProvider>(object.externalNetworkProviders());
                    list.href(href);
                    object.externalNetworkProviders(list);
                    break;
                }
                case "glusterhooks": {
                    ArrayListWithHref<GlusterHook> list = new ArrayListWithHref<GlusterHook>(object.glusterHooks());
                    list.href(href);
                    object.glusterHooks(list);
                    break;
                }
                case "glustervolumes": {
                    ArrayListWithHref<GlusterVolume> list = new ArrayListWithHref<GlusterVolume>(object.glusterVolumes());
                    list.href(href);
                    object.glusterVolumes(list);
                    break;
                }
                case "networkfilters": {
                    ArrayListWithHref<NetworkFilter> list = new ArrayListWithHref<NetworkFilter>(object.networkFilters());
                    list.href(href);
                    object.networkFilters(list);
                    break;
                }
                case "networks": {
                    ArrayListWithHref<Network> list = new ArrayListWithHref<Network>(object.networks());
                    list.href(href);
                    object.networks(list);
                    break;
                }
                case "permissions": {
                    ArrayListWithHref<Permission> list = new ArrayListWithHref<Permission>(object.permissions());
                    list.href(href);
                    object.permissions(list);
                    break;
                }
            }
        }
    }
}

