/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DataCenterBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.AttachedStorageDomainsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ClustersServiceImpl;
import org.ovirt.engine.sdk4.internal.services.DataCenterNetworksServiceImpl;
import org.ovirt.engine.sdk4.internal.services.IscsiBondsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.QossServiceImpl;
import org.ovirt.engine.sdk4.internal.services.QuotasServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDataCenterReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDataCenterWriter;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.AttachedStorageDomainsService;
import org.ovirt.engine.sdk4.services.ClustersService;
import org.ovirt.engine.sdk4.services.DataCenterNetworksService;
import org.ovirt.engine.sdk4.services.DataCenterService;
import org.ovirt.engine.sdk4.services.IscsiBondsService;
import org.ovirt.engine.sdk4.services.QossService;
import org.ovirt.engine.sdk4.services.QuotasService;
import org.ovirt.engine.sdk4.types.DataCenter;

public class DataCenterServiceImpl
extends ServiceImpl
implements DataCenterService {
    public DataCenterServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public DataCenterService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public DataCenterService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public DataCenterService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public ClustersService clustersService() {
        return new ClustersServiceImpl(this.getConnection(), this.getPath() + "/clusters");
    }

    @Override
    public IscsiBondsService iscsiBondsService() {
        return new IscsiBondsServiceImpl(this.getConnection(), this.getPath() + "/iscsibonds");
    }

    @Override
    public DataCenterNetworksService networksService() {
        return new DataCenterNetworksServiceImpl(this.getConnection(), this.getPath() + "/networks");
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public QossService qossService() {
        return new QossServiceImpl(this.getConnection(), this.getPath() + "/qoss");
    }

    @Override
    public QuotasService quotasService() {
        return new QuotasServiceImpl(this.getConnection(), this.getPath() + "/quotas");
    }

    @Override
    public AttachedStorageDomainsService storageDomainsService() {
        return new AttachedStorageDomainsServiceImpl(this.getConnection(), this.getPath() + "/storagedomains");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("clusters")) {
            return this.clustersService();
        }
        if (path.startsWith("clusters/")) {
            return this.clustersService().service(path.substring(9));
        }
        if (path.equals("iscsibonds")) {
            return this.iscsiBondsService();
        }
        if (path.startsWith("iscsibonds/")) {
            return this.iscsiBondsService().service(path.substring(11));
        }
        if (path.equals("networks")) {
            return this.networksService();
        }
        if (path.startsWith("networks/")) {
            return this.networksService().service(path.substring(9));
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        if (path.equals("qoss")) {
            return this.qossService();
        }
        if (path.startsWith("qoss/")) {
            return this.qossService().service(path.substring(5));
        }
        if (path.equals("quotas")) {
            return this.quotasService();
        }
        if (path.startsWith("quotas/")) {
            return this.quotasService().service(path.substring(7));
        }
        if (path.equals("storagedomains")) {
            return this.storageDomainsService();
        }
        if (path.startsWith("storagedomains/")) {
            return this.storageDomainsService().service(path.substring(15));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "DataCenterService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements DataCenterService.UpdateResponse {
        private DataCenter dataCenter;

        private UpdateResponseImpl() {
        }

        public void dataCenter(DataCenter dataCenter) {
            this.dataCenter = dataCenter;
        }

        @Override
        public DataCenter dataCenter() {
            return this.dataCenter;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<DataCenterService.UpdateRequest, DataCenterService.UpdateResponse>
    implements DataCenterService.UpdateRequest {
        private Boolean async;
        private DataCenter dataCenter;

        private UpdateRequestImpl() {
        }

        @Override
        public DataCenterService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public DataCenterService.UpdateRequest dataCenter(DataCenter dataCenter) {
            this.dataCenter = dataCenter;
            return this;
        }

        @Override
        public DataCenterService.UpdateRequest dataCenter(DataCenterBuilder dataCenter) {
            this.dataCenter = dataCenter.build();
            return this;
        }

        @Override
        public DataCenterService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DataCenterServiceImpl.this.getConnection().getUrl() + DataCenterServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDataCenterWriter.writeOne(this.dataCenter, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DataCenterServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.dataCenter(XmlDataCenterReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DataCenterServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements DataCenterService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<DataCenterService.RemoveRequest, DataCenterService.RemoveResponse>
    implements DataCenterService.RemoveRequest {
        private Boolean async;
        private Boolean force;

        private RemoveRequestImpl() {
        }

        @Override
        public DataCenterService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public DataCenterService.RemoveRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public DataCenterService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DataCenterServiceImpl.this.getConnection().getUrl() + DataCenterServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.force != null) {
                    uriBuilder.addParameter("force", XmlWriter.renderBoolean(this.force));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DataCenterServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            DataCenterServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements DataCenterService.GetResponse {
        private DataCenter dataCenter;

        private GetResponseImpl() {
        }

        public void dataCenter(DataCenter dataCenter) {
            this.dataCenter = dataCenter;
        }

        @Override
        public DataCenter dataCenter() {
            return this.dataCenter;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<DataCenterService.GetRequest, DataCenterService.GetResponse>
    implements DataCenterService.GetRequest {
        private Boolean filter;
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public DataCenterService.GetRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public DataCenterService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public DataCenterService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DataCenterServiceImpl.this.getConnection().getUrl() + DataCenterServiceImpl.this.getPath());
                if (this.filter != null) {
                    uriBuilder.addParameter("filter", XmlWriter.renderBoolean(this.filter));
                }
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DataCenterServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.dataCenter(XmlDataCenterReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DataCenterServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

