/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.containers;

import java.math.BigInteger;
import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.IdentifiedContainer;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.DnsResolverConfiguration;
import org.ovirt.engine.sdk4.types.Ip;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkLabel;
import org.ovirt.engine.sdk4.types.NetworkStatus;
import org.ovirt.engine.sdk4.types.NetworkUsage;
import org.ovirt.engine.sdk4.types.OpenStackNetworkProvider;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Qos;
import org.ovirt.engine.sdk4.types.Vlan;
import org.ovirt.engine.sdk4.types.VnicProfile;

public class NetworkContainer
extends IdentifiedContainer
implements Network {
    private Boolean display;
    private DnsResolverConfiguration dnsResolverConfiguration;
    private Ip ip;
    private BigInteger mtu;
    private Boolean profileRequired;
    private Boolean required;
    private NetworkStatus status;
    private Boolean stp;
    private List<NetworkUsage> usages;
    private String vdsmName;
    private Vlan vlan;
    private Cluster cluster;
    private DataCenter dataCenter;
    private OpenStackNetworkProvider externalProvider;
    private Network externalProviderPhysicalNetwork;
    private List<NetworkLabel> networkLabels;
    private List<Permission> permissions;
    private Qos qos;
    private List<VnicProfile> vnicProfiles;

    @Override
    public boolean display() {
        return this.display;
    }

    public void display(boolean newDisplay) {
        this.display = newDisplay;
    }

    public void display(Boolean newDisplay) {
        this.display = newDisplay;
    }

    @Override
    public boolean displayPresent() {
        return this.display != null;
    }

    @Override
    public DnsResolverConfiguration dnsResolverConfiguration() {
        return this.dnsResolverConfiguration;
    }

    public void dnsResolverConfiguration(DnsResolverConfiguration newDnsResolverConfiguration) {
        this.dnsResolverConfiguration = newDnsResolverConfiguration;
    }

    @Override
    public boolean dnsResolverConfigurationPresent() {
        return this.dnsResolverConfiguration != null;
    }

    @Override
    public Ip ip() {
        return this.ip;
    }

    public void ip(Ip newIp) {
        this.ip = newIp;
    }

    @Override
    public boolean ipPresent() {
        return this.ip != null;
    }

    @Override
    public BigInteger mtu() {
        return this.mtu;
    }

    @Override
    public Byte mtuAsByte() {
        return NetworkContainer.asByte("Network", "mtu", this.mtu);
    }

    @Override
    public Short mtuAsShort() {
        return NetworkContainer.asShort("Network", "mtu", this.mtu);
    }

    @Override
    public Integer mtuAsInteger() {
        return NetworkContainer.asInteger("Network", "mtu", this.mtu);
    }

    @Override
    public Long mtuAsLong() {
        return NetworkContainer.asLong("Network", "mtu", this.mtu);
    }

    public void mtu(BigInteger newMtu) {
        this.mtu = newMtu;
    }

    @Override
    public boolean mtuPresent() {
        return this.mtu != null;
    }

    @Override
    public boolean profileRequired() {
        return this.profileRequired;
    }

    public void profileRequired(boolean newProfileRequired) {
        this.profileRequired = newProfileRequired;
    }

    public void profileRequired(Boolean newProfileRequired) {
        this.profileRequired = newProfileRequired;
    }

    @Override
    public boolean profileRequiredPresent() {
        return this.profileRequired != null;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    public void required(boolean newRequired) {
        this.required = newRequired;
    }

    public void required(Boolean newRequired) {
        this.required = newRequired;
    }

    @Override
    public boolean requiredPresent() {
        return this.required != null;
    }

    @Override
    public NetworkStatus status() {
        return this.status;
    }

    public void status(NetworkStatus newStatus) {
        this.status = newStatus;
    }

    @Override
    public boolean statusPresent() {
        return this.status != null;
    }

    @Override
    public boolean stp() {
        return this.stp;
    }

    public void stp(boolean newStp) {
        this.stp = newStp;
    }

    public void stp(Boolean newStp) {
        this.stp = newStp;
    }

    @Override
    public boolean stpPresent() {
        return this.stp != null;
    }

    @Override
    public List<NetworkUsage> usages() {
        return NetworkContainer.makeUnmodifiableList(this.usages);
    }

    public void usages(List<NetworkUsage> newUsages) {
        this.usages = NetworkContainer.makeArrayList(newUsages);
    }

    @Override
    public boolean usagesPresent() {
        return this.usages != null && !this.usages.isEmpty();
    }

    @Override
    public String vdsmName() {
        return this.vdsmName;
    }

    public void vdsmName(String newVdsmName) {
        this.vdsmName = newVdsmName;
    }

    @Override
    public boolean vdsmNamePresent() {
        return this.vdsmName != null;
    }

    @Override
    public Vlan vlan() {
        return this.vlan;
    }

    public void vlan(Vlan newVlan) {
        this.vlan = newVlan;
    }

    @Override
    public boolean vlanPresent() {
        return this.vlan != null;
    }

    @Override
    public Cluster cluster() {
        return this.cluster;
    }

    public void cluster(Cluster newCluster) {
        this.cluster = newCluster;
    }

    @Override
    public boolean clusterPresent() {
        return this.cluster != null;
    }

    @Override
    public DataCenter dataCenter() {
        return this.dataCenter;
    }

    public void dataCenter(DataCenter newDataCenter) {
        this.dataCenter = newDataCenter;
    }

    @Override
    public boolean dataCenterPresent() {
        return this.dataCenter != null;
    }

    @Override
    public OpenStackNetworkProvider externalProvider() {
        return this.externalProvider;
    }

    public void externalProvider(OpenStackNetworkProvider newExternalProvider) {
        this.externalProvider = newExternalProvider;
    }

    @Override
    public boolean externalProviderPresent() {
        return this.externalProvider != null;
    }

    @Override
    public Network externalProviderPhysicalNetwork() {
        return this.externalProviderPhysicalNetwork;
    }

    public void externalProviderPhysicalNetwork(Network newExternalProviderPhysicalNetwork) {
        this.externalProviderPhysicalNetwork = newExternalProviderPhysicalNetwork;
    }

    @Override
    public boolean externalProviderPhysicalNetworkPresent() {
        return this.externalProviderPhysicalNetwork != null;
    }

    @Override
    public List<NetworkLabel> networkLabels() {
        return NetworkContainer.makeUnmodifiableList(this.networkLabels);
    }

    public void networkLabels(List<NetworkLabel> newNetworkLabels) {
        this.networkLabels = NetworkContainer.makeArrayList(newNetworkLabels);
    }

    @Override
    public boolean networkLabelsPresent() {
        return this.networkLabels != null && !this.networkLabels.isEmpty();
    }

    @Override
    public List<Permission> permissions() {
        return NetworkContainer.makeUnmodifiableList(this.permissions);
    }

    public void permissions(List<Permission> newPermissions) {
        this.permissions = NetworkContainer.makeArrayList(newPermissions);
    }

    @Override
    public boolean permissionsPresent() {
        return this.permissions != null && !this.permissions.isEmpty();
    }

    @Override
    public Qos qos() {
        return this.qos;
    }

    public void qos(Qos newQos) {
        this.qos = newQos;
    }

    @Override
    public boolean qosPresent() {
        return this.qos != null;
    }

    @Override
    public List<VnicProfile> vnicProfiles() {
        return NetworkContainer.makeUnmodifiableList(this.vnicProfiles);
    }

    public void vnicProfiles(List<VnicProfile> newVnicProfiles) {
        this.vnicProfiles = NetworkContainer.makeArrayList(newVnicProfiles);
    }

    @Override
    public boolean vnicProfilesPresent() {
        return this.vnicProfiles != null && !this.vnicProfiles.isEmpty();
    }
}

