/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.SessionContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlIpReader;
import org.ovirt.engine.sdk4.internal.xml.XmlUserReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.types.Session;

public class XmlSessionReader {
    public static Session readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        SessionContainer object = new SessionContainer();
        block30: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block30;
                }
                case "id": {
                    object.id(image);
                    continue block30;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block31: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "comment": {
                    object.comment(reader.readString());
                    continue block31;
                }
                case "console_user": {
                    object.consoleUser(reader.readBoolean());
                    continue block31;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block31;
                }
                case "ip": {
                    object.ip(XmlIpReader.readOne(reader));
                    continue block31;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block31;
                }
                case "protocol": {
                    object.protocol(reader.readString());
                    continue block31;
                }
                case "user": {
                    object.user(XmlUserReader.readOne(reader));
                    continue block31;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block31;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.skip();
                    continue block31;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlSessionReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Session> iterateMany(final XmlReader reader) {
        return new Iterator<Session>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Session next() {
                Session next = XmlSessionReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Session> readMany(XmlReader reader) {
        ArrayList<Session> list = new ArrayList<Session>();
        Iterator<Session> iterator = XmlSessionReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(SessionContainer object, String[] link) {
    }
}

