/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum FirewallType {
    FIREWALLD("firewalld"),
    IPTABLES("iptables");

    private static final Logger log;
    private String image;

    private FirewallType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static FirewallType fromValue(String value) {
        try {
            return FirewallType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'FirewallType' enumerated type. Valid values are 'firewalld' and 'iptables'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(FirewallType.class);
    }
}

