/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StatisticUnit {
    BITS_PER_SECOND("bits_per_second"),
    BYTES("bytes"),
    BYTES_PER_SECOND("bytes_per_second"),
    COUNT_PER_SECOND("count_per_second"),
    NONE("none"),
    PERCENT("percent"),
    SECONDS("seconds");

    private static final Logger log;
    private String image;

    private StatisticUnit(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static StatisticUnit fromValue(String value) {
        try {
            return StatisticUnit.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'StatisticUnit' enumerated type. Valid values are 'bits_per_second', 'bytes', 'bytes_per_second', 'count_per_second', 'none', 'percent' and 'seconds'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(StatisticUnit.class);
    }
}

