/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LogSeverity {
    ALERT("alert"),
    ERROR("error"),
    NORMAL("normal"),
    WARNING("warning");

    private static final Logger log;
    private String image;

    private LogSeverity(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static LogSeverity fromValue(String value) {
        try {
            return LogSeverity.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'LogSeverity' enumerated type. Valid values are 'alert', 'error', 'normal' and 'warning'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(LogSeverity.class);
    }
}

