/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import org.ovirt.engine.sdk4.types.Rate;
import org.ovirt.engine.sdk4.types.RngDevice;
import org.ovirt.engine.sdk4.types.RngSource;

public class RngDeviceContainer extends Container implements RngDevice {
    private Rate rate;
    private RngSource source;
    
    public Rate rate() {
        return rate;
    }
    
    public void rate(Rate newRate) {
        rate = newRate;
    }
    
    public boolean ratePresent() {
        return rate != null;
    }
    
    public RngSource source() {
        return source;
    }
    
    public void source(RngSource newSource) {
        source = newSource;
    }
    
    public boolean sourcePresent() {
        return source != null;
    }
    
}
