/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.util.List;

/**
 * Type representing a virtual machine template.
 * This allows a rapid instanstiation of virtual machines with common configuration and disk states.
 */
public interface Template extends VmBase {
    TemplateStatus status();
    
    boolean statusPresent();
    
    TemplateVersion version();
    
    boolean versionPresent();
    
    Vm vm();
    
    boolean vmPresent();
    
    List<Cdrom> cdroms();
    
    boolean cdromsPresent();
    
    List<DiskAttachment> diskAttachments();
    
    boolean diskAttachmentsPresent();
    
    List<GraphicsConsole> graphicsConsoles();
    
    boolean graphicsConsolesPresent();
    
    List<Nic> nics();
    
    boolean nicsPresent();
    
    List<Permission> permissions();
    
    boolean permissionsPresent();
    
    List<Tag> tags();
    
    boolean tagsPresent();
    
    List<Watchdog> watchdogs();
    
    boolean watchdogsPresent();
    
}
