/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;

import java.lang.String;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

/**
 * Represents basic virtual machine configuration.
 * This is used by virtual machines, templates and instance types.
 */
public interface VmBase extends Identified {
    Bios bios();
    
    boolean biosPresent();
    
    Console console();
    
    boolean consolePresent();
    
    Cpu cpu();
    
    boolean cpuPresent();
    
    BigInteger cpuShares();
    
    boolean cpuSharesPresent();
    
    Date creationTime();
    
    boolean creationTimePresent();
    
    Version customCompatibilityVersion();
    
    boolean customCompatibilityVersionPresent();
    
    String customCpuModel();
    
    boolean customCpuModelPresent();
    
    String customEmulatedMachine();
    
    boolean customEmulatedMachinePresent();
    
    List<CustomProperty> customProperties();
    
    boolean customPropertiesPresent();
    
    boolean deleteProtected();
    
    boolean deleteProtectedPresent();
    
    Display display();
    
    boolean displayPresent();
    
    Domain domain();
    
    boolean domainPresent();
    
    HighAvailability highAvailability();
    
    boolean highAvailabilityPresent();
    
    Initialization initialization();
    
    boolean initializationPresent();
    
    Io io();
    
    boolean ioPresent();
    
    Icon largeIcon();
    
    boolean largeIconPresent();
    
    BigInteger memory();
    
    boolean memoryPresent();
    
    MemoryPolicy memoryPolicy();
    
    boolean memoryPolicyPresent();
    
    MigrationOptions migration();
    
    boolean migrationPresent();
    
    BigInteger migrationDowntime();
    
    boolean migrationDowntimePresent();
    
    String origin();
    
    boolean originPresent();
    
    OperatingSystem os();
    
    boolean osPresent();
    
    RngDevice rngDevice();
    
    boolean rngDevicePresent();
    
    SerialNumber serialNumber();
    
    boolean serialNumberPresent();
    
    Icon smallIcon();
    
    boolean smallIconPresent();
    
    boolean soundcardEnabled();
    
    boolean soundcardEnabledPresent();
    
    Sso sso();
    
    boolean ssoPresent();
    
    boolean startPaused();
    
    boolean startPausedPresent();
    
    boolean stateless();
    
    boolean statelessPresent();
    
    TimeZone timeZone();
    
    boolean timeZonePresent();
    
    boolean tunnelMigration();
    
    boolean tunnelMigrationPresent();
    
    VmType type();
    
    boolean typePresent();
    
    Usb usb();
    
    boolean usbPresent();
    
    VirtioScsi virtioScsi();
    
    boolean virtioScsiPresent();
    
    Cluster cluster();
    
    boolean clusterPresent();
    
    CpuProfile cpuProfile();
    
    boolean cpuProfilePresent();
    
    Quota quota();
    
    boolean quotaPresent();
    
    StorageDomain storageDomain();
    
    boolean storageDomainPresent();
    
}
