/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.services.MoveableService;
import org.ovirt.engine.sdk4.types.Action;

public class MoveableServiceImpl
extends ServiceImpl
implements MoveableService {
    public MoveableServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public MoveableService.MoveRequest move() {
        return new MoveRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "MoveableService:" + this.getPath();
    }

    private class MoveResponseImpl
    implements MoveableService.MoveResponse {
        private MoveResponseImpl() {
        }
    }

    private class MoveRequestImpl
    implements MoveableService.MoveRequest {
        private Boolean async;

        private MoveRequestImpl() {
        }

        @Override
        public MoveableService.MoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public MoveableService.MoveResponse send() {
            HttpPost request = new HttpPost(MoveableServiceImpl.this.getConnection().getUrl() + MoveableServiceImpl.this.getPath() + "/move");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            HttpResponse response = MoveableServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = MoveableServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new MoveResponseImpl();
        }
    }
}

