/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.internal.containers.IdentifiedContainer;
import org.ovirt.engine.sdk4.types.Domain;
import org.ovirt.engine.sdk4.types.Group;
import org.ovirt.engine.sdk4.types.Permission;
import org.ovirt.engine.sdk4.types.Role;
import org.ovirt.engine.sdk4.types.Tag;

public class GroupContainer
extends IdentifiedContainer
implements Group {
    private String domainEntryId;
    private String namespace;
    private Domain domain;
    private List<Permission> permissions;
    private List<Role> roles;
    private List<Tag> tags;

    @Override
    public String domainEntryId() {
        return this.domainEntryId;
    }

    public void domainEntryId(String newDomainEntryId) {
        this.domainEntryId = newDomainEntryId;
    }

    @Override
    public boolean domainEntryIdPresent() {
        return this.domainEntryId != null;
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    public void namespace(String newNamespace) {
        this.namespace = newNamespace;
    }

    @Override
    public boolean namespacePresent() {
        return this.namespace != null;
    }

    @Override
    public Domain domain() {
        return this.domain;
    }

    public void domain(Domain newDomain) {
        this.domain = newDomain;
    }

    @Override
    public boolean domainPresent() {
        return this.domain != null;
    }

    @Override
    public List<Permission> permissions() {
        return GroupContainer.makeUnmodifiableList(this.permissions);
    }

    public void permissions(List<Permission> newPermissions) {
        this.permissions = GroupContainer.makeArrayList(newPermissions);
    }

    @Override
    public boolean permissionsPresent() {
        return this.permissions != null && !this.permissions.isEmpty();
    }

    @Override
    public List<Role> roles() {
        return GroupContainer.makeUnmodifiableList(this.roles);
    }

    public void roles(List<Role> newRoles) {
        this.roles = GroupContainer.makeArrayList(newRoles);
    }

    @Override
    public boolean rolesPresent() {
        return this.roles != null && !this.roles.isEmpty();
    }

    @Override
    public List<Tag> tags() {
        return GroupContainer.makeUnmodifiableList(this.tags);
    }

    public void tags(List<Tag> newTags) {
        this.tags = GroupContainer.makeArrayList(newTags);
    }

    @Override
    public boolean tagsPresent() {
        return this.tags != null && !this.tags.isEmpty();
    }
}

